/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.migration.manager.impl;

import com.jxdinfo.hussar.migration.manager.HussarBaseMigrationTaskManager;
import com.jxdinfo.hussar.migration.properties.HussarBaseMigrationProperties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="com.jxdinfo.hussar.migration.manager.impl.hussarBaseMigrationTaskManagerImpl")
public class HussarBaseMigrationTaskManagerImpl
implements HussarBaseMigrationTaskManager {
    private static final Logger logger = LoggerFactory.getLogger(HussarBaseMigrationTaskManagerImpl.class);
    private volatile ExecutorService pool;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    @Autowired
    private HussarBaseMigrationProperties properties;

    @Override
    public void schedule(boolean exclusive, Runnable task) {
        logger.info("migration task runner: scheduled a task");
        this.getPool().submit(() -> {
            if (this.properties.isDefaultPoolUseLock()) {
                Lock taskLock = exclusive ? this.lock.writeLock() : this.lock.readLock();
                taskLock.lock();
                try {
                    logger.info("migration task runner: a scheduled task is now running with lock");
                    task.run();
                }
                finally {
                    taskLock.unlock();
                }
            } else {
                logger.info("migration task runner: a scheduled task is now running without lock");
                task.run();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getPool() {
        if (this.pool == null) {
            HussarBaseMigrationTaskManagerImpl hussarBaseMigrationTaskManagerImpl = this;
            synchronized (hussarBaseMigrationTaskManagerImpl) {
                if (this.pool == null) {
                    int size = this.properties.getDefaultPoolSize();
                    this.pool = new ScheduledThreadPoolExecutor(size);
                    logger.info("initialized migration task runner thread pool of size {}", (Object)size);
                }
            }
        }
        return this.pool;
    }
}

