/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.migration.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.CoreVersion;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.identity.user.model.SysUsers;
import com.jxdinfo.hussar.identity.user.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.migration.constants.MigrationDumpStatus;
import com.jxdinfo.hussar.migration.constants.MigrationExceptionEnum;
import com.jxdinfo.hussar.migration.constants.MigrationTaskStatus;
import com.jxdinfo.hussar.migration.dto.MigrationDumpDto;
import com.jxdinfo.hussar.migration.dto.MigrationDumpItemDto;
import com.jxdinfo.hussar.migration.dto.MigrationDumpListDto;
import com.jxdinfo.hussar.migration.exceptions.MigrationException;
import com.jxdinfo.hussar.migration.manager.HussarBaseMigrationDumpRecordManager;
import com.jxdinfo.hussar.migration.manager.HussarBaseMigrationLogManager;
import com.jxdinfo.hussar.migration.manager.HussarBaseMigrationStorageManager;
import com.jxdinfo.hussar.migration.manager.HussarBaseMigrationTaskManager;
import com.jxdinfo.hussar.migration.manifest.MigrationArchiveItem;
import com.jxdinfo.hussar.migration.manifest.MigrationArchiveManifest;
import com.jxdinfo.hussar.migration.model.MigrationDumpModel;
import com.jxdinfo.hussar.migration.plugin.MigrationPlugin;
import com.jxdinfo.hussar.migration.plugin.MigrationPluginHolder;
import com.jxdinfo.hussar.migration.plugin.MigrationPluginMetadata;
import com.jxdinfo.hussar.migration.plugin.context.AbstractMigrationWritableContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationDumpContext;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationDumpItemVo;
import com.jxdinfo.hussar.migration.properties.HussarBaseMigrationProperties;
import com.jxdinfo.hussar.migration.service.HussarBaseMigrationDumpService;
import com.jxdinfo.hussar.migration.utils.MigrationArchiveOptions;
import com.jxdinfo.hussar.migration.utils.MigrationArchiveUtils;
import com.jxdinfo.hussar.migration.utils.MigrationExceptionUtils;
import com.jxdinfo.hussar.migration.vo.MigrationDumpRecordVo;
import com.jxdinfo.hussar.migration.vo.MigrationDumpReportVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.id.UUID;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.migration.service.impl.hussarBaseMigrationDumpServiceImpl")
public class HussarBaseMigrationDumpServiceImpl
implements HussarBaseMigrationDumpService {
    private static final Logger logger = LoggerFactory.getLogger(HussarBaseMigrationDumpServiceImpl.class);
    private static final String WORKSPACE_PREFIX = "hussar-dump-workspace-";
    private static final int STAGE_PREPARE = 0;
    private static final int STAGE_RUNNING = 1;
    private static final int STAGE_PACKAGE = 2;
    private static final String MESSAGE_DUMP_SUCCESS = "\u6210\u529f\u5bfc\u51fa %d \u79cd\u4e1a\u52a1\u7c7b\u578b\uff0c\u603b\u8ba1 %d \u6761\u6570\u636e";
    private static final String MESSAGE_DUMP_FAILED = "\u5bfc\u51fa\u4efb\u52a1\u6267\u884c\u5931\u8d25";
    private static final String MESSAGE_ITEM_FAILED = "\u5bfc\u51fa\u6761\u76ee %s \u6267\u884c\u5931\u8d25";
    private static final String MESSAGE_PREPARE_FAILED = "\u51c6\u5907\u9636\u6bb5\u5931\u8d25";
    private static final String MESSAGE_RUNNING_FAILED = "\u6267\u884c\u5bfc\u51fa\u9636\u6bb5\u5931\u8d25";
    private static final String MESSAGE_PACKAGE_FAILED = "\u6253\u5305\u9636\u6bb5\u5931\u8d25";
    private static final String MESSAGE_OTHERWISE_FAILED = "\u672a\u77e5\u9636\u6bb5\u5931\u8d25";
    private static final String MESSAGE_BAD_TASK_STATUS = "\u5bfc\u51fa\u9636\u6bb5\u6267\u884c\u7ed3\u679c\u7f3a\u5c11\u5b8c\u6210\u6216\u5931\u8d25\u7684\u6267\u884c\u72b6\u6001";
    private static final String MESSAGE_FAILED_ITEM_STATUS = "\u5bfc\u51fa\u9636\u6bb5\u4e1a\u52a1\u6761\u76ee %s (%s) \u6267\u884c\u8fd4\u56de\u5931\u8d25\u7ed3\u679c";
    private static final String MESSAGE_INVALID_ITEM_STATUS = "\u5bfc\u51fa\u9636\u6bb5\u4e1a\u52a1\u6761\u76ee %s (%s) \u6267\u884c\u8fd4\u56de\u72b6\u6001\u7801\u4e0d\u662f\u5b8c\u6210\u6216\u5931\u8d25";
    @Autowired
    private HussarBaseMigrationProperties properties;
    @Autowired
    private HussarBaseMigrationDumpRecordManager dumpRecordManager;
    @Autowired
    private HussarBaseMigrationTaskManager taskManager;
    @Autowired
    private HussarBaseMigrationStorageManager storageManager;
    @Autowired
    private HussarBaseMigrationLogManager logManager;
    @Autowired
    private IHussarBaseUserBoService hussarBaseUserBoService;

    public ApiResponse<Long> dump(MigrationDumpDto migrationDumpDto) {
        if (migrationDumpDto == null) {
            return ApiResponse.fail((int)MigrationExceptionEnum.MIGRATION_ILLEGAL_DTO_EXCEPTION.getCode(), (String)MigrationExceptionEnum.MIGRATION_ILLEGAL_DTO_EXCEPTION.getMessage());
        }
        MigrationDumpModel record = new MigrationDumpModel();
        record.setDumpStatus(1);
        record.setDumpDescription(migrationDumpDto.getDescription());
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user != null) {
            record.setCreator(user.getUserId());
        }
        record.setCreateTime(LocalDateTime.now());
        this.dumpRecordManager.saveOrUpdate((Object)record);
        logger.info("created migration dump task {} status {}", (Object)record.getId(), (Object)MigrationDumpStatus.display((Integer)record.getDumpStatus()));
        String encodedParametersLog = this.logManager.encode(String.format("dump_%s_log.params_", record.getId()), migrationDumpDto);
        record.setDumpParameters(encodedParametersLog);
        this.dumpRecordManager.saveOrUpdate((Object)record);
        this.taskManager.schedule(false, () -> {
            block15: {
                try {
                    record.setDumpStatus(2);
                    record.setDumpStart(LocalDateTime.now());
                    this.dumpRecordManager.saveOrUpdate((Object)record);
                    logger.info("migration dump task {} status: {}", (Object)record.getId(), (Object)MigrationDumpStatus.display((Integer)record.getDumpStatus()));
                    MigrationDumpReportVo dumpReport = this.doDump(record, migrationDumpDto, user, this.properties.isFastFail());
                    String encodedResultLog = this.logManager.encode(String.format("dump_%s_log.result_", record.getId()), dumpReport);
                    record.setDumpResult(encodedResultLog);
                    if (MigrationTaskStatus.isSuccess((Integer)dumpReport.getStatus())) {
                        record.setDumpStatus(0);
                        break block15;
                    }
                    if (MigrationTaskStatus.isFailed((Integer)dumpReport.getStatus())) {
                        record.setDumpStatus(-1);
                        record.setDumpError(dumpReport.getMessage());
                        break block15;
                    }
                    throw new MigrationException(MESSAGE_BAD_TASK_STATUS);
                }
                catch (Exception ex) {
                    logger.error("migration dump thread failed", (Throwable)ex);
                    record.setDumpStatus(-1);
                    record.setDumpError("\u5bfc\u51fa\u4efb\u52a1\u6267\u884c\u5931\u8d25: " + ex);
                    try {
                        MigrationDumpReportVo dumpErrorReport = new MigrationDumpReportVo();
                        dumpErrorReport.setStatus(Integer.valueOf(-1));
                        dumpErrorReport.setMessage("\u5bfc\u51fa\u4efb\u52a1\u6267\u884c\u5931\u8d25: " + MigrationExceptionUtils.toMessage(ex));
                        String encodedResultLog = this.logManager.encode(String.format("dump_%s_log.result_", record.getId()), dumpErrorReport);
                        record.setDumpResult(encodedResultLog);
                    }
                    catch (Exception innerEx) {
                        logger.error("failed to flush back migration dump thread failure message", (Throwable)innerEx);
                    }
                }
                finally {
                    record.setDumpEnd(LocalDateTime.now());
                    try {
                        this.dumpRecordManager.saveOrUpdate((Object)record);
                        logger.info("migration dump task {} status: {}", (Object)record.getId(), (Object)MigrationDumpStatus.display((Integer)record.getDumpStatus()));
                    }
                    catch (Exception ex) {
                        logger.error("failed to update migration dump record", (Throwable)ex);
                    }
                }
            }
        });
        return ApiResponse.success((Object)record.getId());
    }

    private MigrationDumpReportVo doDump(MigrationDumpModel record, MigrationDumpDto migrationDumpDto, SecurityUser user, boolean fastFail) {
        logger.info("migration dump task {} execute stage: PREPARE", (Object)record.getId());
        MigrationDumpReportVo dumpReport = new MigrationDumpReportVo();
        int lastStage = 0;
        try {
            File workspace = Files.createTempDirectory(WORKSPACE_PREFIX, new FileAttribute[0]).toFile();
            MigrationArchiveManifest manifest = new MigrationArchiveManifest();
            manifest.setVersion(1L);
            manifest.setFull(migrationDumpDto.isFull());
            manifest.setUnified(migrationDumpDto.isUnified());
            manifest.setDescription(migrationDumpDto.getDescription());
            LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
            manifest.setTags(tags);
            tags.put("system.os", System.getProperty("os.name"));
            tags.put("system.jvm", System.getProperty("java.runtime.version"));
            tags.put("system.arch", System.getProperty("os.arch"));
            tags.put("system.encoding", System.getProperty("file.encoding"));
            tags.put("hussar.migration.platform", CoreVersion.getFrameworkVersion());
            if (user != null) {
                if (user.getUserName() != null) {
                    tags.put("hussar.migration.username", user.getUserName());
                } else if (user.getAccount() != null) {
                    tags.put("hussar.migration.username", user.getAccount());
                }
            }
            tags.put("hussar.migration.timestamp", LocalDateTime.now().atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
            for (Map.Entry tagEntry : Optional.ofNullable(migrationDumpDto.getTags()).orElse(Collections.emptyMap()).entrySet()) {
                tags.putIfAbsent((String)tagEntry.getKey(), (String)tagEntry.getValue());
            }
            List itemDtoList = Optional.ofNullable(migrationDumpDto.getItems()).orElseGet(Collections::emptyList);
            List services = itemDtoList.stream().filter(Objects::nonNull).map(dto -> MigrationPluginHolder.lookup(dto.getType())).distinct().collect(Collectors.toList());
            HashMap<String, MigrationPlugin> serviceCache = new HashMap<String, MigrationPlugin>();
            HashMap<String, MigrationPluginMetadata> metadataCache = new HashMap<String, MigrationPluginMetadata>();
            for (MigrationPlugin service : services) {
                MigrationPluginMetadata metadata = service.metadata();
                String type = metadata.getServiceType();
                serviceCache.put(type, service);
                metadataCache.put(type, metadata);
            }
            List sortedItemDtoList = itemDtoList.stream().filter(Objects::nonNull).sorted(Comparator.comparingInt(dto -> Optional.ofNullable(metadataCache.get(dto.getType())).map(MigrationPluginMetadata::getDumpPrecedence).orElse(0))).collect(Collectors.toList());
            List<MigrationArchiveItem> items = sortedItemDtoList.stream().map(dto -> {
                String type = dto.getType();
                MigrationArchiveItem item = new MigrationArchiveItem();
                item.setUuid(UUID.randomUUID().toString(true));
                item.setType(type);
                item.setVersion(Optional.ofNullable(metadataCache.get(type)).map(MigrationPluginMetadata::getVersion).orElse(null));
                return item;
            }).collect(Collectors.toList());
            manifest.setItems(items);
            logger.info("migration dump task {} execute stage: RUNNING", (Object)record.getId());
            logger.info("migration dump task {} run items: total {}, workspace {}", new Object[]{record.getId(), items.size(), workspace});
            lastStage = 1;
            List itemResults = items.stream().map(item -> {
                MigrationDumpItemVo itemResult = MigrationDumpItemVo.of((Integer)1);
                itemResult.setUuid(item.getUuid());
                itemResult.setType(item.getType());
                return itemResult;
            }).collect(Collectors.toList());
            dumpReport.setItems(itemResults);
            boolean allSuccess = true;
            for (int i = 0; i < items.size(); ++i) {
                MigrationArchiveItem item2 = items.get(i);
                MigrationPlugin service = (MigrationPlugin)serviceCache.get(item2.getType());
                Map parameters = ((MigrationDumpItemDto)sortedItemDtoList.get(i)).getParameters();
                if (parameters == null) {
                    logger.warn("archive item {} of type {} dump parameter is missing", (Object)item2.getUuid(), (Object)item2.getType());
                }
                File itemWorkspace = new File(workspace, item2.getUuid());
                FileUtils.forceMkdirParent((File)itemWorkspace);
                DumpItemContext context = new DumpItemContext(record.getId(), manifest, item2, itemWorkspace);
                logger.info("migration dump task {} run item: item {}/{}, uuid {}, service type {}, service class {}", new Object[]{record.getId(), i + 1, items.size(), item2.getUuid(), item2.getType(), service.getClass().getName()});
                boolean throwByReturnFailed = false;
                try {
                    ((MigrationDumpItemVo)itemResults.get(i)).setStatus(Integer.valueOf(2));
                    MigrationDumpItemVo itemResult = service.dump((MigrationDumpContext)context, parameters);
                    itemResult.setUuid(item2.getUuid());
                    itemResult.setType(item2.getType());
                    itemResults.set(i, itemResult);
                    if (MigrationTaskStatus.isFailed((Integer)itemResult.getStatus())) {
                        throwByReturnFailed = true;
                        throw new MigrationException(String.format(MESSAGE_FAILED_ITEM_STATUS, item2.getUuid(), item2.getType()));
                    }
                    if (MigrationTaskStatus.isSuccess((Integer)itemResult.getStatus())) continue;
                    throw new MigrationException(String.format(MESSAGE_INVALID_ITEM_STATUS, item2.getUuid(), item2.getType()) + ": " + itemResult.getStatus());
                }
                catch (Exception ex) {
                    logger.error("migration dump item {} ({}) of task {} execute failed", new Object[]{item2.getUuid(), item2.getType(), record.getId(), ex});
                    MigrationDumpItemVo itemResult = (MigrationDumpItemVo)itemResults.get(i);
                    itemResult.setStatus(Integer.valueOf(-1));
                    if (!throwByReturnFailed) {
                        itemResult.setMessage(String.format(MESSAGE_ITEM_FAILED, item2.getType()) + ": " + MigrationExceptionUtils.toMessage(ex));
                    }
                    if (fastFail) {
                        throw ex;
                    }
                    allSuccess = false;
                }
            }
            dumpReport.setStatus(Integer.valueOf(allSuccess ? 0 : -1));
            if (allSuccess) {
                long total = 0L;
                for (MigrationDumpItemVo itemResult : itemResults) {
                    Optional<Long> itemTotal = Optional.ofNullable(itemResult).map(MigrationDumpItemVo::getTotal);
                    if (!itemTotal.isPresent()) {
                        Long dumpId = record.getId();
                        String uuid = Optional.ofNullable(itemResult).map(MigrationDumpItemVo::getUuid).orElse(null);
                        String type = Optional.ofNullable(itemResult).map(MigrationDumpItemVo::getType).orElse(null);
                        logger.warn("migration dump item {} ({}) of task {} succeed without reporting total data count", new Object[]{uuid, type, dumpId});
                    }
                    total += itemTotal.orElse(0L).longValue();
                }
                dumpReport.setTotal(Long.valueOf(total));
                dumpReport.setMessage(String.format(MESSAGE_DUMP_SUCCESS, itemResults.size(), total));
            }
            logger.info("migration dump task {} execute stage: PACKAGE", (Object)record.getId());
            lastStage = 2;
            IdempotentJsonUtils.write((Object)manifest, (File)new File(workspace, "manifest.json"));
            File archive = Files.createTempFile("archive_dump_", ".hussar", new FileAttribute[0]).toFile();
            MigrationArchiveOptions options = new MigrationArchiveOptions();
            if (migrationDumpDto.isChecksum()) {
                options.setChecksumType(this.properties.getChecksum());
            }
            if (migrationDumpDto.isSignature()) {
                options.setSignatureType(this.properties.getSignature());
                options.setSignaturePrivateKey(this.properties.getSignaturePrivateKey());
            }
            if (migrationDumpDto.isEncryption()) {
                options.setEncryptionType(this.properties.getEncryption());
                options.setEncryptionKey(this.properties.getEncryptionKey());
            }
            MigrationArchiveUtils.archive(archive, workspace, options);
            String filename = "archive_dump_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "-" + Hex.encodeHexString((byte[])DigestUtils.digest((MessageDigest)MessageDigest.getInstance("SHA-1"), (File)archive)).substring(0, 12) + ".hussar";
            String handle = this.storageManager.upload(filename, archive);
            record.setDumpFile(handle);
            try {
                FileUtils.forceDelete((File)archive);
                FileUtils.forceDelete((File)workspace);
            }
            catch (IOException ex) {
                logger.warn("failed to remove temporary dump workspace or archive");
            }
        }
        catch (Exception ex) {
            logger.error("migration dump task {} execute failed", (Object)record.getId(), (Object)ex);
            dumpReport.setStatus(Integer.valueOf(-1));
            switch (lastStage) {
                case 0: {
                    dumpReport.setMessage("\u51c6\u5907\u9636\u6bb5\u5931\u8d25: " + MigrationExceptionUtils.toMessage(ex));
                    break;
                }
                case 1: {
                    dumpReport.setMessage("\u6267\u884c\u5bfc\u51fa\u9636\u6bb5\u5931\u8d25: " + MigrationExceptionUtils.toMessage(ex));
                    break;
                }
                case 2: {
                    dumpReport.setMessage("\u6253\u5305\u9636\u6bb5\u5931\u8d25: " + MigrationExceptionUtils.toMessage(ex));
                    break;
                }
                default: {
                    dumpReport.setMessage("\u672a\u77e5\u9636\u6bb5\u5931\u8d25: " + MigrationExceptionUtils.toMessage(ex));
                }
            }
        }
        return dumpReport;
    }

    public ApiResponse<MigrationDumpReportVo> report(Long dumpId) {
        MigrationDumpModel record = (MigrationDumpModel)((Object)this.dumpRecordManager.getById(dumpId));
        if (record == null) {
            logger.error("migration dump task not found: {}", (Object)dumpId);
            return ApiResponse.fail((int)MigrationExceptionEnum.TASK_NOT_FOUND_EXCEPTION.getCode(), (String)MigrationExceptionEnum.TASK_NOT_FOUND_EXCEPTION.getMessage());
        }
        if (!MigrationDumpStatus.isReportQueryable((Integer)record.getDumpStatus())) {
            logger.error("migration dump report not queryable: task {}, status {}", (Object)dumpId, (Object)record.getDumpStatus());
            return ApiResponse.fail((int)MigrationExceptionEnum.TASK_DUMP_REPORT_DISALLOWED_EXCEPTION.getCode(), (String)MigrationExceptionEnum.TASK_DUMP_REPORT_DISALLOWED_EXCEPTION.getMessage());
        }
        if (record.getDumpResult() == null) {
            logger.error("migration dump result log not found: task {}, status {}", (Object)dumpId, (Object)record.getDumpStatus());
            return ApiResponse.fail((int)MigrationExceptionEnum.TASK_DUMP_REPORT_EXCEPTION.getCode(), (String)MigrationExceptionEnum.TASK_DUMP_REPORT_EXCEPTION.getMessage());
        }
        try {
            MigrationDumpReportVo dumpReport = this.logManager.decode(record.getDumpResult(), MigrationDumpReportVo.class);
            return ApiResponse.success((Object)dumpReport);
        }
        catch (MigrationException ex) {
            logger.error("failed to decode migration dump result log: task {}, status {}, result {}", new Object[]{dumpId, record.getDumpStatus(), record.getDumpResult(), ex});
            return ApiResponse.fail((int)MigrationExceptionEnum.TASK_DUMP_REPORT_EXCEPTION.getCode(), (String)MigrationExceptionEnum.TASK_DUMP_REPORT_EXCEPTION.getMessage());
        }
    }

    public void download(HttpServletResponse response, Long dumpId) {
        MigrationDumpModel record = (MigrationDumpModel)((Object)this.dumpRecordManager.getById(dumpId));
        if (record == null) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            response.setContentType("application/json");
            throw new HussarException(MigrationExceptionEnum.TASK_NOT_FOUND_EXCEPTION.getCode(), MigrationExceptionEnum.TASK_NOT_FOUND_EXCEPTION.getMessage());
        }
        if (!MigrationDumpStatus.isSuccess((Integer)record.getDumpStatus())) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            response.setContentType("application/json");
            if (MigrationDumpStatus.isFailed((Integer)record.getDumpStatus())) {
                throw new HussarException(MigrationExceptionEnum.TASK_NOT_SUCCESS_EXCEPTION.getCode(), MigrationExceptionEnum.TASK_NOT_SUCCESS_EXCEPTION.getMessage());
            }
            throw new HussarException(MigrationExceptionEnum.TASK_NOT_COMPLETE_EXCEPTION.getCode(), MigrationExceptionEnum.TASK_NOT_COMPLETE_EXCEPTION.getMessage());
        }
        String handle = record.getDumpFile();
        if (handle == null || !this.storageManager.exists(handle)) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            response.setContentType("application/json");
            throw new HussarException(MigrationExceptionEnum.ARCHIVE_NOT_FOUND_EXCEPTION.getCode(), MigrationExceptionEnum.ARCHIVE_NOT_FOUND_EXCEPTION.getMessage());
        }
        try {
            logger.info("archive download of dump task {} starts", (Object)dumpId);
            String filename = this.storageManager.filename(handle);
            response.setStatus(HttpStatus.OK.value());
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(filename, StandardCharsets.UTF_8.name()));
            ServletOutputStream output = response.getOutputStream();
            this.storageManager.download(handle, (OutputStream)output);
        }
        catch (Exception ex) {
            logger.error("archive download failed", (Throwable)ex);
            throw new HussarException(MigrationExceptionEnum.ARCHIVE_DOWNLOAD_EXCEPTION.getCode(), MigrationExceptionEnum.ARCHIVE_DOWNLOAD_EXCEPTION.getMessage());
        }
    }

    private void removeAssociatedLog(Long dumpId, String description, String encodedLog) {
        if (encodedLog != null) {
            logger.info("remove {} log of migration dump task {}", (Object)description, (Object)dumpId);
            boolean success = this.logManager.free(encodedLog);
            if (!success) {
                logger.warn("cannot remove associated log {} of migration dump task {}", (Object)encodedLog, (Object)dumpId);
            }
        }
    }

    public ApiResponse<MigrationDumpRecordVo> query(Long dumpId) {
        MigrationDumpRecordVo record = this.dumpRecordManager.query(dumpId);
        if (record != null) {
            SysUsers user = this.hussarBaseUserBoService.getUserById(Long.valueOf(Long.parseLong(record.getCreatorName())));
            record.setCreatorName(user.getUserName());
            return ApiResponse.success((Object)record);
        }
        return ApiResponse.fail((int)MigrationExceptionEnum.TASK_NOT_FOUND_EXCEPTION.getCode(), (String)MigrationExceptionEnum.TASK_NOT_FOUND_EXCEPTION.getMessage());
    }

    public ApiResponse<Page<MigrationDumpRecordVo>> list(PageInfo page, MigrationDumpListDto queryDumpParams) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        List status = queryDumpParams.getStatus();
        List codes = Optional.ofNullable(status).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        queryParams.put("status", codes);
        queryParams.put("startTime", queryDumpParams.getStartTime());
        queryParams.put("endTime", queryDumpParams.getEndTime());
        Page<MigrationDumpRecordVo> recordVoPage = this.dumpRecordManager.list((Page<MigrationDumpRecordVo>)HussarPageUtils.convert((PageInfo)page), queryParams);
        List recordVos = recordVoPage.getRecords();
        for (MigrationDumpRecordVo recordVo : recordVos) {
            if (!ToolUtil.isNotEmpty((Object)recordVo.getCreatorName())) continue;
            SysUsers user = this.hussarBaseUserBoService.getUserById(Long.valueOf(Long.parseLong(recordVo.getCreatorName())));
            recordVo.setCreatorName(user.getUserName());
        }
        Page result = new Page();
        result.setTotal(recordVoPage.getTotal());
        result.setRecords(recordVos);
        return ApiResponse.success((Object)result);
    }

    public ApiResponse<Boolean> remove(Long dumpId) {
        MigrationDumpModel record = (MigrationDumpModel)((Object)this.dumpRecordManager.getById(dumpId));
        if (record != null && MigrationDumpStatus.isPendingOrRunning((Integer)record.getDumpStatus())) {
            logger.error("attempt to remove running migration dump task {}", (Object)dumpId);
            return ApiResponse.fail((int)MigrationExceptionEnum.TASK_NOT_REMOVABLE_WHEN_RUNNING.getCode(), (String)MigrationExceptionEnum.TASK_NOT_REMOVABLE_WHEN_RUNNING.getMessage());
        }
        boolean removed = this.dumpRecordManager.removeById(dumpId);
        if (record != null && record.getDumpFile() != null && this.storageManager.exists(record.getDumpFile())) {
            try {
                logger.info("remove archive of migration dump task {}", (Object)dumpId);
                this.storageManager.remove(record.getDumpFile());
            }
            catch (Exception ex) {
                logger.warn("cannot remove associated file {} of migration dump task {}", (Object)record.getDumpFile(), (Object)dumpId);
            }
        }
        if (record != null) {
            this.removeAssociatedLog(dumpId, "dump parameters", record.getDumpParameters());
            this.removeAssociatedLog(dumpId, "dump result", record.getDumpResult());
        }
        return ApiResponse.success((Object)removed);
    }

    private final class DumpItemContext
    extends AbstractMigrationWritableContext
    implements MigrationDumpContext {
        private final Long dumpId;

        public DumpItemContext(Long dumpId, MigrationArchiveManifest manifest, MigrationArchiveItem item, File workspace) {
            super(manifest, item, workspace);
            this.dumpId = dumpId;
        }

        public Long getDumpId() {
            return this.dumpId;
        }

        public MigrationDumpRecordVo getDumpRecord() {
            return HussarBaseMigrationDumpServiceImpl.this.dumpRecordManager.query(this.dumpId);
        }
    }
}

