/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.migration.plugin;

import com.jxdinfo.hussar.migration.exceptions.MigrationException;
import com.jxdinfo.hussar.migration.plugin.MigrationPlugin;
import com.jxdinfo.hussar.migration.plugin.MigrationPluginMetadata;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public class MigrationPluginHolder
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger logger = LoggerFactory.getLogger(MigrationPluginHolder.class);
    private static final ConcurrentHashMap<String, MigrationPlugin> services = new ConcurrentHashMap();

    public static void register(MigrationPlugin provider) {
        String type = Optional.ofNullable(provider).map(MigrationPlugin::metadata).map(MigrationPluginMetadata::getServiceType).orElse(null);
        if (type == null) {
            throw new NullPointerException();
        }
        logger.debug("\u6ce8\u518c\u5bfc\u5165\u5bfc\u51fa\u670d\u52a1: {} => {}", (Object)type, (Object)provider.getClass().getName());
        MigrationPlugin previous = services.putIfAbsent(type, provider);
        if (previous != null && provider != previous) {
            throw new IllegalStateException("conflicted migration service provider for " + type + ": " + provider.getClass().getName() + " != " + previous.getClass().getName());
        }
    }

    public static MigrationPlugin unregister(String type) {
        logger.debug("\u5378\u8f7d\u5bfc\u5165\u5bfc\u51fa\u670d\u52a1: {}", (Object)type);
        return services.remove(type);
    }

    public static MigrationPlugin replace(MigrationPlugin provider) {
        String type = Optional.ofNullable(provider).map(MigrationPlugin::metadata).map(MigrationPluginMetadata::getServiceType).orElse(null);
        if (type == null) {
            throw new NullPointerException();
        }
        logger.debug("\u66ff\u6362\u5bfc\u5165\u5bfc\u51fa\u670d\u52a1: {} => {}", (Object)type, (Object)provider.getClass().getName());
        return services.put(type, provider);
    }

    public static MigrationPlugin lookup(String type) throws MigrationException {
        MigrationPlugin provider = services.get(type);
        if (provider == null) {
            throw new MigrationException("migration service type not registered: " + type);
        }
        return provider;
    }

    public static List<String> types() {
        return Collections.list(services.keys());
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        for (MigrationPlugin bean : applicationContext.getBeansOfType(MigrationPlugin.class).values()) {
            MigrationPluginHolder.register(bean);
        }
        logger.info("\u5e73\u53f0\u8fc1\u5165\u8fc1\u51fa\u63d2\u4ef6\u6ce8\u518c\u5b8c\u6210: " + String.join((CharSequence)", ", MigrationPluginHolder.types()));
    }
}

