/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.migration.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.migration.dto.MigrationLoadDto;
import com.jxdinfo.hussar.migration.dto.MigrationLoadListDto;
import com.jxdinfo.hussar.migration.dto.MigrationPreloadDto;
import com.jxdinfo.hussar.migration.service.HussarBaseMigrationLoadService;
import com.jxdinfo.hussar.migration.vo.MigrationDetailVo;
import com.jxdinfo.hussar.migration.vo.MigrationLoadRecordVo;
import com.jxdinfo.hussar.migration.vo.MigrationLoadReportVo;
import com.jxdinfo.hussar.migration.vo.MigrationPreloadReportVo;
import com.jxdinfo.hussar.migration.vo.MigrationUploadVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u6570\u636e\u8fc1\u79fb\u5bfc\u5165\u7ba1\u7406"})
@RestController(value="com.jxdinfo.hussar.migration.controller.hussarBaseMigrationLoadController")
@RequestMapping(value={"/hussarBase/migration/load"})
public class HussarBaseMigrationLoadController {
    @Autowired
    private HussarBaseMigrationLoadService loadService;

    @ApiOperation(value="\u4e0a\u4f20\u5bfc\u5165\u5305\u5e76\u521b\u5efa\u5bfc\u5165\u4efb\u52a1", notes="\u4e0a\u4f20\u5bfc\u5165\u5305\u5e76\u521b\u5efa\u5bfc\u5165\u4efb\u52a1\uff0c\u540c\u6b65\u6267\u884c\u4e0a\u4f20\u53ca\u89e3\u6790\u64cd\u4f5c\u5e76\u8fd4\u56de\u5bfc\u5165\u4efb\u52a1 ID \u4ee5\u53ca\u5bfc\u5165\u5305\u662f\u5426\u91cd\u590d\u5bfc\u5165")
    @AuditLog(eventDesc="\u4e0a\u4f20\u5bfc\u5165\u5305\u5e76\u521b\u5efa\u5bfc\u5165\u4efb\u52a1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"hussarBase:migration:load:upload"})
    @PostMapping(value={"upload"})
    public ApiResponse<MigrationUploadVo> upload(@ApiParam(value="\u4e0a\u4f20\u7684\u5bfc\u5165\u5305\u6587\u4ef6") @RequestPart MultipartFile archive) {
        return this.loadService.upload(archive);
    }

    @ApiOperation(value="\u5f00\u59cb\u6267\u884c\u5bfc\u5165\u524d\u7684\u6570\u636e\u6821\u9a8c", notes="\u89e6\u53d1\u6570\u636e\u6821\u9a8c\uff0c\u5f02\u6b65\u6267\u884c\u6570\u636e\u6821\u9a8c\u5e76\u63d0\u524d\u8fd4\u56de\uff0c\u5f00\u59cb\u6821\u9a8c\u524d\u4efb\u52a1\u5fc5\u987b\u5904\u4e8e\u6821\u9a8c\u5c31\u7eea\u72b6\u6001")
    @AuditLog(eventDesc="\u5f00\u59cb\u6267\u884c\u5bfc\u5165\u524d\u7684\u6570\u636e\u6821\u9a8c", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"hussarBase:migration:load:preloadStart"})
    @PostMapping(value={"preloadStart"})
    public ApiResponse<Boolean> preloadStart(@ApiParam(value="\u6821\u9a8c\u53c2\u6570\u5b9e\u4f53") @RequestBody MigrationPreloadDto migrationPreloadDto) {
        return this.loadService.preload(migrationPreloadDto);
    }

    @ApiOperation(value="\u67e5\u8be2\u5bfc\u5165\u4e4b\u524d\u6821\u9a8c\u9636\u6bb5\u7684\u6267\u884c\u7ed3\u679c", notes="\u6839\u636e\u4efb\u52a1 ID \u67e5\u8be2\u6821\u9a8c\u9636\u6bb5\u7684\u6267\u884c\u7ed3\u679c")
    @AuditLog(eventDesc="\u67e5\u8be2\u5bfc\u5165\u4e4b\u524d\u6821\u9a8c\u9636\u6bb5\u7684\u6267\u884c\u7ed3\u679c", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"hussarBase:migration:load:preloadReport"})
    @GetMapping(value={"preloadReport"})
    public ApiResponse<MigrationPreloadReportVo> preloadReport(@ApiParam(value="\u5bfc\u5165\u4efb\u52a1 ID") @RequestParam Long loadId) {
        return this.loadService.preloadReport(loadId);
    }

    @ApiOperation(value="\u5f00\u59cb\u6267\u884c\u5bfc\u5165", notes="\u89e6\u53d1\u5bfc\u5165\u6267\u884c\uff0c\u5f02\u6b65\u6267\u884c\u5bfc\u5165\u5e76\u63d0\u524d\u8fd4\u56de\uff0c\u5f00\u59cb\u6821\u9a8c\u524d\u4efb\u52a1\u5fc5\u987b\u5904\u4e8e\u5bfc\u5165\u5c31\u7eea\u72b6\u6001")
    @AuditLog(eventDesc="\u5f00\u59cb\u6267\u884c\u5bfc\u5165", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"hussarBase:migration:load:loadStart"})
    @PostMapping(value={"loadStart"})
    public ApiResponse<Boolean> loadStart(@ApiParam(value="\u5bfc\u5165\u53c2\u6570\u5b9e\u4f53") @RequestBody MigrationLoadDto migrationLoadDto) {
        return this.loadService.load(migrationLoadDto);
    }

    @ApiOperation(value="\u67e5\u8be2\u5bfc\u5165\u9636\u6bb5\u7684\u6267\u884c\u7ed3\u679c", notes="\u6839\u636e\u4efb\u52a1 ID \u67e5\u8be2\u5bfc\u5165\u9636\u6bb5\u7684\u6267\u884c\u7ed3\u679c")
    @AuditLog(eventDesc="\u67e5\u8be2\u5bfc\u5165\u9636\u6bb5\u7684\u6267\u884c\u7ed3\u679c", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"hussarBase:migration:load:loadReport"})
    @GetMapping(value={"loadReport"})
    public ApiResponse<MigrationLoadReportVo> loadReport(@ApiParam(value="\u5bfc\u5165\u4efb\u52a1 ID") @RequestParam Long loadId) {
        return this.loadService.loadReport(loadId);
    }

    @ApiOperation(value="\u67e5\u8be2\u5bfc\u5165\u5305\u5185\u5bb9\u8be6\u60c5", notes="\u6839\u636e\u4efb\u52a1 ID \u67e5\u8be2\u4e0a\u4f20\u7684\u5bfc\u5165\u5305\u5185\u5bb9\u8be6\u60c5")
    @AuditLog(eventDesc="\u67e5\u8be2\u5bfc\u5165\u5305\u5185\u5bb9\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"hussarBase:migration:load:detail"})
    @GetMapping(value={"detail"})
    public ApiResponse<MigrationDetailVo> detail(@ApiParam(value="\u5bfc\u5165\u4efb\u52a1 ID") @RequestParam Long loadId) {
        return this.loadService.detail(loadId);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u6761\u5bfc\u5165\u8bb0\u5f55\u7684\u6700\u65b0\u72b6\u6001", notes="\u6839\u636e\u4efb\u52a1 ID \u67e5\u8be2\u5bfc\u5165\u8bb0\u5f55\u5b9e\u4f53\u5bf9\u8c61")
    @CheckPermission(value={"hussarBase:migration:load:query"})
    @GetMapping(value={"query"})
    public ApiResponse<MigrationLoadRecordVo> query(@ApiParam(value="\u5bfc\u5165\u4efb\u52a1 ID") @RequestParam Long loadId) {
        return this.loadService.query(loadId);
    }

    @ApiOperation(value="\u67e5\u8be2\u5bfc\u5165\u8bb0\u5f55\u5217\u8868", notes="\u5206\u9875\u67e5\u8be2\u5bfc\u5165\u8bb0\u5f55\uff0c\u53ef\u6839\u636e\u72b6\u6001\u7801\u5217\u8868\u8fdb\u884c\u7b5b\u9009\uff0c\u7ed3\u679c\u6309\u521b\u5efa\u65f6\u95f4\u5012\u5e8f\u6392\u5217")
    @AuditLog(eventDesc="\u67e5\u8be2\u5bfc\u5165\u8bb0\u5f55\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"hussarBase:migration:load:list"})
    @GetMapping(value={"list"})
    public ApiResponse<Page<MigrationLoadRecordVo>> list(@ApiParam(value="\u5206\u9875\u53c2\u6570") PageInfo page, @ApiParam(value="\u67e5\u8be2\u5bfc\u5165\u8bb0\u5f55\u5217\u8868Dto") MigrationLoadListDto queryLoadParams) {
        return this.loadService.list(page, queryLoadParams);
    }

    @ApiOperation(value="\u5220\u9664\u5bfc\u5165\u4efb\u52a1\u53ca\u5173\u8054\u7684\u6570\u636e\u5305", notes="\u5220\u9664\u5bfc\u5165\u4efb\u52a1\u53ca\u5173\u8054\u7684\u6570\u636e\u5305\uff0c\u6b63\u5728\u961f\u5217\u6216\u6267\u884c\u4e2d\u7684\u4efb\u52a1\u65e0\u6cd5\u5220\u9664")
    @AuditLog(eventDesc="\u5220\u9664\u5bfc\u5165\u4efb\u52a1\u53ca\u5173\u8054\u7684\u6570\u636e\u5305", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @CheckPermission(value={"hussarBase:migration:load:remove"})
    @PostMapping(value={"remove"})
    public ApiResponse<Boolean> remove(@ApiParam(value="\u5bfc\u5165\u4efb\u52a1 ID") @RequestBody Long loadId) {
        return this.loadService.remove(loadId);
    }
}

