/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.migration.plugin.context;

import com.jxdinfo.hussar.migration.exceptions.MigrationException;
import com.jxdinfo.hussar.migration.manifest.MigrationArchiveItem;
import com.jxdinfo.hussar.migration.manifest.MigrationArchiveManifest;
import com.jxdinfo.hussar.migration.plugin.context.MigrationReadonlyContext;
import com.jxdinfo.hussar.migration.utils.MigrationContextUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;

public abstract class AbstractMigrationReadonlyContext
implements MigrationReadonlyContext {
    protected final MigrationArchiveManifest manifest;
    protected final MigrationArchiveItem item;
    protected final File workspace;

    public AbstractMigrationReadonlyContext(MigrationArchiveManifest manifest, MigrationArchiveItem item, File workspace) {
        this.manifest = manifest;
        this.item = item;
        this.workspace = workspace;
    }

    public String getUuid() {
        return this.item.getUuid();
    }

    public Long getVersion() {
        return this.item.getVersion();
    }

    public String getDescription() {
        return this.item.getDescription();
    }

    public Object getAttribute(String key) {
        return Optional.ofNullable(this.item.getAttributes()).map(attrs -> attrs.get(key)).orElse(null);
    }

    public Collection<String> getAttributeList() {
        return Optional.ofNullable(this.item.getAttributes()).map(Map::keySet).orElse(Collections.emptySet());
    }

    public boolean isPayloadExists(String name) {
        File file = new File(this.workspace, name);
        return file.isFile();
    }

    public byte[] getPayloadAsByteArray(String name) {
        File file = new File(this.workspace, name);
        if (file.isFile()) {
            try {
                return FileUtils.readFileToByteArray((File)file);
            }
            catch (IOException ex) {
                throw new MigrationException((Throwable)ex);
            }
        }
        return null;
    }

    public List<String> getPayloadList() {
        return MigrationContextUtils.getPayloadList(this.workspace);
    }

    public Long getArchiveVersion() {
        return this.manifest.getVersion();
    }

    public String getArchiveUuid() {
        return this.manifest.getUuid();
    }

    public boolean isArchiveFull() {
        return this.manifest.isFull();
    }

    public boolean isArchiveUnified() {
        return this.manifest.isUnified();
    }

    public String getArchiveDescription() {
        return this.manifest.getDescription();
    }

    public String getArchiveTag(String tag) {
        return Optional.ofNullable(this.manifest.getTags()).map(tags -> (String)tags.get(tag)).orElse(null);
    }

    public Collection<String> getArchiveTagList() {
        return Optional.ofNullable(this.manifest.getTags()).map(Map::keySet).orElse(Collections.emptySet());
    }
}

