/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.migration.plugin.context;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public interface MigrationReadonlyContext {
    public String getUuid();

    public Long getVersion();

    public String getDescription();

    public Object getAttribute(String var1);

    public Collection<String> getAttributeList();

    public boolean isPayloadExists(String var1);

    public byte[] getPayloadAsByteArray(String var1);

    default public String getPayloadAsString(String name) {
        return this.getPayloadAsString(name, null);
    }

    default public String getPayloadAsString(String name, Charset charset) {
        return new String(this.getPayloadAsByteArray(name), charset != null ? charset : StandardCharsets.UTF_8);
    }

    default public <T> T getPayloadAsJson(String name, Class<T> clazz) {
        byte[] data = this.getPayloadAsByteArray(name);
        return (T)(data != null ? IdempotentJsonUtils.parse((byte[])data, clazz) : null);
    }

    default public <T> T getPayloadAsJson(String name, TypeReference<T> typeReference) {
        byte[] data = this.getPayloadAsByteArray(name);
        return (T)(data != null ? IdempotentJsonUtils.parse((byte[])data, typeReference) : null);
    }

    public Collection<String> getPayloadList();

    public Long getArchiveVersion();

    public String getArchiveUuid();

    public boolean isArchiveFull();

    public boolean isArchiveUnified();

    public String getArchiveDescription();

    public String getArchiveTag(String var1);

    public Collection<String> getArchiveTagList();
}

