/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.micro.app.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.micro.app.dao.MicroApplicationMapper;
import com.jxdinfo.hussar.micro.app.dto.AddConfDto;
import com.jxdinfo.hussar.micro.app.model.MicroApplicationConf;
import com.jxdinfo.hussar.micro.app.service.MicroApplicationConfService;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MicroApplicationServiceImpl
extends HussarServiceImpl<MicroApplicationMapper, MicroApplicationConf>
implements MicroApplicationConfService {
    @Resource
    private MicroApplicationConfService microApplicationConfService;
    private static final String MA_STATUS_OPEN = "1";
    private static final String MA_STATUS_CLOSE = "0";
    @Resource
    private MicroApplicationMapper microApplicationMapper;
    @Resource
    private ISysApplicationBoService sysApplicationBoService;

    public Long addConf(AddConfDto addConfDto) {
        boolean existRule;
        boolean existName;
        AssertUtil.isNotNull((Object)addConfDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String name = addConfDto.getName();
        if (!name.matches("^[a-zA-Z][a-zA-Z0-9-_]*$")) {
            throw new BaseException("\u540d\u79f0\u53ef\u4ee5\u4e3a\u82f1\u6587\u6570\u5b57\u4e0b\u5212\u7ebf\u4e2d\u5212\u7ebf\uff0c\u4e14\u5fc5\u987b\u4ee5\u82f1\u6587\u5f00\u5934!");
        }
        boolean bl = existName = this.microApplicationConfService.count((Wrapper)new LambdaUpdateWrapper().eq(MicroApplicationConf::getName, (Object)name)) > 0L;
        if (existName) {
            throw new BaseException("\u5fae\u5e94\u7528\u540d\u4e0d\u80fd\u91cd\u590d\uff01");
        }
        boolean bl2 = existRule = this.microApplicationConfService.count((Wrapper)new LambdaQueryWrapper().eq(MicroApplicationConf::getActiveRule, (Object)addConfDto.getActiveRule())) > 0L;
        if (existRule) {
            throw new BaseException("\u5339\u914d\u8def\u7531\u4e0d\u80fd\u91cd\u590d\uff01");
        }
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        AssertUtil.isNotNull((Object)securityUser, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f\uff01");
        MicroApplicationConf microApplicationConf = new MicroApplicationConf();
        microApplicationConf.setName(addConfDto.getName());
        microApplicationConf.setAppId(addConfDto.getAppId());
        microApplicationConf.setEntry(addConfDto.getEntry());
        microApplicationConf.setContainer(addConfDto.getContainer());
        microApplicationConf.setActiveRule(addConfDto.getActiveRule());
        microApplicationConf.setPreload(addConfDto.getPreLoad());
        microApplicationConf.setNeedVfg(addConfDto.getNeedVfg());
        microApplicationConf.setStatus(MA_STATUS_OPEN);
        microApplicationConf.setCreator(securityUser.getId());
        microApplicationConf.setCreateTime(LocalDateTime.now());
        this.microApplicationConfService.save((Object)microApplicationConf);
        this.sysApplicationBoService.saveAppOperation(addConfDto.getAppId());
        return microApplicationConf.getId();
    }

    public void editConf(AddConfDto addConfDto) {
        AssertUtil.isNotNull((Object)addConfDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String activeRule = addConfDto.getActiveRule();
        String alreadyExitRule = ((MicroApplicationConf)this.microApplicationConfService.getOne((Wrapper)new LambdaQueryWrapper().eq(MicroApplicationConf::getAppId, (Object)addConfDto.getAppId()))).getActiveRule();
        if (!alreadyExitRule.equals(activeRule)) {
            boolean existRule;
            boolean bl = existRule = this.microApplicationConfService.count((Wrapper)new LambdaQueryWrapper().eq(MicroApplicationConf::getActiveRule, (Object)activeRule)) > 0L;
            if (existRule) {
                throw new BaseException("\u5339\u914d\u8def\u7531\u4e0d\u80fd\u91cd\u590d\uff01");
            }
        }
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        AssertUtil.isNotNull((Object)securityUser, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f\uff01");
        MicroApplicationConf microApplicationConf = new MicroApplicationConf();
        microApplicationConf.setAppId(addConfDto.getAppId());
        microApplicationConf.setEntry(addConfDto.getEntry());
        microApplicationConf.setContainer(addConfDto.getContainer());
        microApplicationConf.setActiveRule(addConfDto.getActiveRule());
        microApplicationConf.setPreload(addConfDto.getPreLoad());
        microApplicationConf.setNeedVfg(addConfDto.getNeedVfg());
        microApplicationConf.setLastEditor(securityUser.getId());
        microApplicationConf.setLastTime(LocalDateTime.now());
        this.microApplicationConfService.update((Object)microApplicationConf, (Wrapper)new LambdaQueryWrapper().eq(MicroApplicationConf::getAppId, (Object)addConfDto.getAppId()));
        this.sysApplicationBoService.saveAppOperation(addConfDto.getAppId());
    }

    public List<MicroApplicationConf> getConfList() {
        return this.microApplicationMapper.getConfList();
    }

    public void deleteConf(Long appId) {
        AssertUtil.isNotNull((Object)appId, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.microApplicationConfService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(MicroApplicationConf::getStatus, (Object)MA_STATUS_CLOSE)).eq(MicroApplicationConf::getAppId, (Object)appId));
    }

    public MicroApplicationConf viewConf(Long appId) {
        AssertUtil.isNotNull((Object)appId, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.sysApplicationBoService.saveAppOperation(appId);
        return (MicroApplicationConf)this.microApplicationConfService.getOne((Wrapper)new LambdaUpdateWrapper().eq(MicroApplicationConf::getAppId, (Object)appId));
    }

    public void deleteConfForever(Long appId) {
        AssertUtil.isNotNull((Object)appId, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.microApplicationConfService.remove((Wrapper)new LambdaUpdateWrapper().eq(MicroApplicationConf::getAppId, (Object)appId));
    }

    public void addRecord(Long appId) {
        this.sysApplicationBoService.saveAppOperation(appId);
    }
}

