/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.sms.thrid.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.teaopenapi.models.Config;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.utils.IdUtil;
import com.jxdinfo.hussar.msg.job.enums.MsgJobEnum;
import com.jxdinfo.hussar.msg.job.service.MsgJobService;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordDto;
import com.jxdinfo.hussar.msg.sms.service.SmsSendRecordService;
import com.jxdinfo.hussar.msg.sms.third.service.SmsThirdSendService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AliyunSmsThirdSendServiceImpl
implements SmsThirdSendService {
    private static final Logger logger = LoggerFactory.getLogger(AliyunSmsThirdSendServiceImpl.class);
    @Autowired
    private SmsSendRecordService smsSendRecordService;
    @Autowired
    private MsgJobService msgJobService;

    public String getChannelTypeCode() {
        return "1";
    }

    public Client createClient(String accessKeyId, String accessKeySecret) throws Exception {
        Config config = new Config().setAccessKeyId(accessKeyId).setAccessKeySecret(accessKeySecret);
        config.endpoint = "dysmsapi.aliyuncs.com";
        return new Client(config);
    }

    public boolean sendSms(SmsSendRecordDto record) throws Exception {
        Client client = this.createClient(record.getAccessKeyId(), record.getAccessKeySecret());
        String phoneNumbers = record.getPhoneNumber();
        if (ToolUtil.isNotEmpty((Object)record.getContent()) && ToolUtil.isNotEmpty((Object)record.getParams())) {
            String[] content = new String[]{record.getContent()};
            JSONObject.parseObject((String)record.getParams()).forEach((k, v) -> {
                content[0] = content[0].replace("#{" + k + "}", String.valueOf(v));
            });
            record.setContent(content[0]);
        }
        boolean flag = true;
        if (record.getTim() != null && record.getTim().booleanValue()) {
            Date sendTime = record.getJobTime();
            Date now = new Date();
            String id = IdUtil.fastSimpleUuid();
            SmsSendRecordDto jobParams = new SmsSendRecordDto();
            jobParams.setMsgId(id);
            jobParams.setPhoneNumber(phoneNumbers);
            jobParams.setSignName(record.getSignName());
            jobParams.setTemplateCode(record.getTemplateCode());
            jobParams.setParams(record.getParams());
            jobParams.setChannelType(record.getChannelType());
            jobParams.setAccessKeyId(record.getAccessKeyId());
            jobParams.setAccessKeySecret(record.getAccessKeySecret());
            this.msgJobService.saveMsgJob(record.getJobTime(), JSONObject.toJSONString((Object)jobParams), MsgJobEnum.MSG_SMS);
            record.setSendTime(sendTime);
            record.setParams(record.getParams());
            record.setPhoneNumber(phoneNumbers);
            record.setErrMsg("");
            record.setStatus(SendStatusEnum.SENDING.getCode());
            record.setBizId("");
            record.setCreateTime(now);
            record.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.smsSendRecordService.save(record);
        } else {
            String params;
            Date now = new Date();
            if (HussarUtils.isNotEmpty((Object)record.getParams())) {
                Map map = (Map)JSON.parseObject((String)record.getParams(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                for (Map.Entry entry : map.entrySet()) {
                    if (((String)entry.getValue()).length() <= 35) continue;
                    logger.warn("{} \u77ed\u4fe1\u53c2\u6570\u957f\u5ea6\u8d85\u8fc735\uff0c\u5df2\u622a\u53d6\u524d35\u4e2a\u5b57\u7b26\uff0c\u622a\u53d6\u524d\uff1a{}\uff0c\u622a\u53d6\u540e\uff1a{}", new Object[]{entry.getKey(), entry.getValue(), ((String)entry.getValue()).substring(0, 35)});
                    entry.setValue(((String)entry.getValue()).substring(0, 35));
                }
                params = JSON.toJSONString((Object)map);
            } else {
                params = record.getParams();
            }
            SendSmsRequest sendSmsRequest = new SendSmsRequest().setPhoneNumbers(phoneNumbers).setSignName(record.getSignName()).setTemplateCode(record.getTemplateCode()).setTemplateParam(params);
            SendSmsResponse res = new SendSmsResponse();
            try {
                res = client.sendSms(sendSmsRequest);
            }
            catch (Exception exception) {
                record.setErrMsg(exception.getMessage());
                record.setStatus(SendStatusEnum.FAIL.getCode());
                flag = false;
                logger.error("\u53d1\u9001\u77ed\u4fe1\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)exception);
            }
            if (flag) {
                record.setErrMsg(res.getBody().getMessage());
                record.setStatus("OK".equals(res.getBody().getCode()) ? SendStatusEnum.SUCCESS.getCode() : SendStatusEnum.FAIL.getCode());
                record.setBizId(res.getBody().getBizId());
                if (!"OK".equals(res.getBody().getCode())) {
                    logger.error("\u53d1\u9001\u77ed\u4fe1\u63a5\u53e3\u5f02\u5e38\uff1a" + res.getBody().getMessage());
                }
            }
            record.setPhoneNumber(phoneNumbers);
            record.setSendTime(now);
            record.setCreateTime(now);
            record.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.smsSendRecordService.save(record);
        }
        return flag;
    }

    public boolean jobSend(SmsSendRecordDto dto) throws Exception {
        Client client = this.createClient(dto.getAccessKeyId(), dto.getAccessKeySecret());
        SmsSendRecordDto msgSmsSendRecord = this.smsSendRecordService.findById(dto.getMsgId());
        if (HussarUtils.isEmpty((Object)msgSmsSendRecord)) {
            logger.error("\u5b9a\u65f6\u63a8\u9001\u77ed\u4fe1\uff0c\u6d88\u606f\u8bb0\u5f55\u67e5\u8be2\u4e0d\u5b58\u5728\uff0c\u6d88\u606fid:{}", (Object)dto.getMsgId());
        }
        String[] phoneNumbersList = msgSmsSendRecord.getPhoneNumber().split(",");
        Map map = (Map)JSON.parseObject((String)msgSmsSendRecord.getParams(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        for (Map.Entry entry : map.entrySet()) {
            if (((String)entry.getValue()).length() <= 35) continue;
            entry.setValue(((String)entry.getValue()).substring(0, 35));
        }
        String params = JSON.toJSONString((Object)map);
        SendSmsRequest sendSmsRequest = new SendSmsRequest().setPhoneNumbers(phoneNumbersList[0]).setSignName(msgSmsSendRecord.getSignName()).setTemplateCode(msgSmsSendRecord.getTemplateCode()).setTemplateParam(params);
        try {
            SendSmsResponse res = client.sendSms(sendSmsRequest);
            msgSmsSendRecord.setErrMsg(res.getBody().getMessage());
            msgSmsSendRecord.setStatus("OK".equals(res.getBody().getCode()) ? SendStatusEnum.SUCCESS.getCode() : SendStatusEnum.FAIL.getCode());
        }
        catch (Exception e) {
            msgSmsSendRecord.setErrMsg(e.getMessage());
            msgSmsSendRecord.setStatus(SendStatusEnum.FAIL.getCode());
            logger.error("\u53d1\u9001\u77ed\u4fe1\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
        }
        msgSmsSendRecord.setSendTime(new Date());
        this.smsSendRecordService.save(msgSmsSendRecord);
        return true;
    }
}

