/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.common.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.common.utils.BizCodeUtils;
import com.jxdinfo.hussar.msg.mp.dao.MsgMpTemplateMapper;
import com.jxdinfo.hussar.msg.mp.dto.MpChannelQueryVo;
import com.jxdinfo.hussar.msg.mp.dto.MpTemplateCreateDto;
import com.jxdinfo.hussar.msg.mp.dto.MpTemplatePageDto;
import com.jxdinfo.hussar.msg.mp.dto.MpTemplateQueryVo;
import com.jxdinfo.hussar.msg.mp.dto.MpTemplateUpdateDto;
import com.jxdinfo.hussar.msg.mp.model.MsgMpTemplate;
import com.jxdinfo.hussar.msg.mp.service.MpChannelService;
import com.jxdinfo.hussar.msg.mp.service.MpTemplateService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class MpTemplateServiceImpl
extends HussarServiceImpl<MsgMpTemplateMapper, MsgMpTemplate>
implements MpTemplateService {
    private static final String PATTERN_CONTENT = "\\#\\{(.*?)\\}";
    @Autowired
    private MsgMpTemplateMapper msgMpTemplateMapper;
    @Autowired
    private MpChannelService mpChannelService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public IPage<MsgMpTemplate> listPage(Page page, MpTemplatePageDto pageDto) {
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getChannelName())) {
            pageDto.setChannelName(SqlQueryUtil.transferSpecialChar((String)pageDto.getChannelName().trim()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getChannelNo())) {
            pageDto.setChannelNo(SqlQueryUtil.transferSpecialChar((String)pageDto.getChannelNo().trim()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getTemplateName())) {
            pageDto.setTemplateName(SqlQueryUtil.transferSpecialChar((String)pageDto.getTemplateName().trim()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getTemplateNo())) {
            pageDto.setTemplateNo(SqlQueryUtil.transferSpecialChar((String)pageDto.getTemplateNo().trim()));
        }
        IPage<MsgMpTemplate> pageList = this.msgMpTemplateMapper.queryPage(page, pageDto);
        return pageList;
    }

    public MpTemplateQueryVo findById(long id) {
        MsgMpTemplate entity = (MsgMpTemplate)super.getById((Serializable)Long.valueOf(id));
        return this.entity2QueryVo(entity);
    }

    public boolean save(MpTemplateCreateDto createDto) {
        MpChannelQueryVo msgMpChannel = this.mpChannelService.findById(createDto.getChannelId());
        if (HussarUtils.isEmpty((Object)msgMpChannel)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.mp.channel.not.found"));
        }
        MsgMpTemplate entity = new MsgMpTemplate();
        BeanUtils.copyProperties((Object)createDto, (Object)entity);
        entity.setTemplateNo(BizCodeUtils.generalBizCode((BizCodeEnum)BizCodeEnum.MP_TEMPLATE));
        if (HussarUtils.equals((Object)"1", (Object)this.checkTemplateUnique(entity))) {
            throw new HussarException(entity.getTemplateName() + " : " + TranslateUtil.getTranslateName((String)"msg.api.template.name.duplicated"));
        }
        return super.save((BaseEntity)entity);
    }

    public boolean updateById(MpTemplateUpdateDto updateDto) {
        MpChannelQueryVo msgMpChannel = this.mpChannelService.findById(updateDto.getChannelId());
        if (HussarUtils.isEmpty((Object)msgMpChannel)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.mp.channel.not.found"));
        }
        MsgMpTemplate entity = new MsgMpTemplate();
        BeanUtils.copyProperties((Object)updateDto, (Object)entity);
        if (HussarUtils.equals((Object)"1", (Object)this.checkTemplateUnique(entity))) {
            throw new HussarException(entity.getTemplateName() + " : " + TranslateUtil.getTranslateName((String)"msg.api.template.name.duplicated"));
        }
        MsgMpTemplate msgMpTemplate = (MsgMpTemplate)super.getById((Serializable)updateDto.getId());
        if (!HussarUtils.equals((Object)msgMpTemplate.getStatus(), (Object)updateDto.getStatus()) && this.appSceneConfigService.isExistSceneInBatch(new ArrayList<String>(Collections.singletonList(msgMpTemplate.getTemplateNo())))) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.del.corr.startup.fail"));
        }
        return super.updateById((BaseEntity)entity);
    }

    public boolean delete(Long id) {
        MsgMpTemplate msgMpTemplate = (MsgMpTemplate)((MsgMpTemplateMapper)this.baseMapper).selectById(id);
        if (HussarUtils.isEmpty((Object)msgMpTemplate)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.mp.template.not.found"));
        }
        if (this.appSceneConfigService.isExistScene(msgMpTemplate.getTemplateNo())) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.scene.del.corr"));
        }
        MpChannelQueryVo msgMpChannel = this.mpChannelService.findById(msgMpTemplate.getChannelId());
        if (HussarUtils.isEmpty((Object)msgMpChannel)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.mp.channel.not.found"));
        }
        return super.removeById((Serializable)id);
    }

    public boolean deleteTemplateByIds(Long[] ids) {
        if (this.appSceneConfigService.isExistSceneInBatch(super.listByIds(Arrays.asList(ids)).stream().map(MsgMpTemplate::getTemplateNo).collect(Collectors.toList()))) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.scene.del.corr"));
        }
        return super.removeByIds(Arrays.asList(ids));
    }

    public List<MpTemplateQueryVo> getTemplateListByChannelId(Long channelId) {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgMpTemplate::getChannelId, (Object)channelId);
        qw.lambda().eq(MsgMpTemplate::getStatus, (Object)OpenStatusEnum.ENABLE.getCode());
        qw.lambda().orderByDesc(HussarBaseEntity::getCreateTime);
        List list = this.msgMpTemplateMapper.selectList((Wrapper)qw);
        List<MpTemplateQueryVo> result = list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
        for (MpTemplateQueryVo mpTemplateQueryVo : result) {
            mpTemplateQueryVo.setContents(this.getContents(mpTemplateQueryVo.getContent()));
        }
        return result;
    }

    private MpTemplateQueryVo entity2QueryVo(MsgMpTemplate entity) {
        MpTemplateQueryVo vo = new MpTemplateQueryVo();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        vo.setContents(this.getContents(entity.getContent()));
        return vo;
    }

    private List<String> getContents(String content) {
        LinkedList<String> contents = new LinkedList<String>();
        if (HussarUtils.isNotEmpty((Object)content)) {
            Pattern pattern = Pattern.compile(PATTERN_CONTENT);
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                String group = matcher.group(1).replaceAll("\\#\\{", "").replaceAll("\\}", "");
                contents.add(group);
            }
        }
        return contents;
    }

    private String checkTemplateUnique(MsgMpTemplate entity) {
        Long id = HussarUtils.isEmpty((Object)entity.getId()) ? -1L : entity.getId();
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgMpTemplate::getTemplateName, (Object)entity.getTemplateName());
        MsgMpTemplate info = (MsgMpTemplate)this.getOne((Wrapper)qw, false);
        if (HussarUtils.isNotEmpty((Object)info) && !HussarUtils.equals((Object)info.getId(), (Object)id)) {
            return "1";
        }
        return "0";
    }
}

