/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.dingtalk.third.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiMessageCorpconversationAsyncsendV2Response;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.properties.UnifiedMessageProperties;
import com.jxdinfo.hussar.msg.common.utils.IdUtil;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkParamDto;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkSendRecordDto;
import com.jxdinfo.hussar.msg.dingtalk.service.DingTalkSendRecordService;
import com.jxdinfo.hussar.msg.dingtalk.third.service.DingTalkThirdService;
import com.jxdinfo.hussar.msg.dingtalk.vo.DingTalkSendRecordVo;
import com.jxdinfo.hussar.msg.job.enums.MsgJobEnum;
import com.jxdinfo.hussar.msg.job.service.MsgJobService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HussarTokenDs
public class DingTalkThirdServiceImpl
implements DingTalkThirdService {
    @Autowired
    private UnifiedMessageProperties unifiedMessageProperties;
    @Autowired
    private MsgJobService msgJobService;
    @Autowired
    private DingTalkSendRecordService dingTalkSendRecordService;
    private static final Logger logger = LoggerFactory.getLogger(DingTalkThirdServiceImpl.class);

    public boolean sendDingTalkTimMsg(DingTalkSendRecordDto dingTalkSendRecordDto) {
        dingTalkSendRecordDto.setId(null);
        if (null != dingTalkSendRecordDto.getTim() && dingTalkSendRecordDto.getTim().booleanValue()) {
            String msgId = IdUtil.fastSimpleUuid();
            dingTalkSendRecordDto.setMsgId(msgId);
            this.msgJobService.saveMsgJob(dingTalkSendRecordDto.getJobTime(), JSONObject.toJSONString((Object)dingTalkSendRecordDto), MsgJobEnum.MSG_DINGTALK);
            Date now = new Date();
            dingTalkSendRecordDto.setCreateTime(now);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            dingTalkSendRecordDto.setCreateDate(dateFormat.format(now));
            dingTalkSendRecordDto.setSendTime(dingTalkSendRecordDto.getJobTime());
            this.dingTalkSendRecordService.saveRecord(dingTalkSendRecordDto);
            return true;
        }
        return this.sendDingTalkMsg(dingTalkSendRecordDto);
    }

    public boolean jobSendMsg(DingTalkSendRecordDto dingTalkSendRecordDto) {
        this.sendDingTalkMsg(dingTalkSendRecordDto);
        DingTalkSendRecordVo dingTalkSendRecordVo = this.dingTalkSendRecordService.findById(dingTalkSendRecordDto.getId());
        if (HussarUtils.isNotEmpty((Object)dingTalkSendRecordVo.getId())) {
            dingTalkSendRecordVo.setStatus(dingTalkSendRecordDto.getStatus());
            dingTalkSendRecordVo.setErrMsg(dingTalkSendRecordDto.getErrMsg());
            this.dingTalkSendRecordService.saveRecord((DingTalkSendRecordDto)HussarUtils.copy((Object)dingTalkSendRecordVo, DingTalkSendRecordDto.class));
        }
        return true;
    }

    private boolean sendDingTalkMsg(DingTalkSendRecordDto dingTalkSendRecordDto) {
        boolean flag = true;
        Integer status = SendStatusEnum.SUCCESS.getCode();
        dingTalkSendRecordDto.setErrMsg(SendStatusEnum.SUCCESS.getName());
        DingTalkParamDto paramDto = new DingTalkParamDto();
        HussarUtils.copy((Object)dingTalkSendRecordDto, (Object)paramDto);
        paramDto.setAppSecret(dingTalkSendRecordDto.getDingAppSecret());
        paramDto.setUserList(dingTalkSendRecordDto.getToUser());
        paramDto.setAgentId(Long.valueOf(Long.parseLong(dingTalkSendRecordDto.getAgentId())));
        try {
            OapiMessageCorpconversationAsyncsendV2Response rsp = this.sendDingTalkThirdMsg(paramDto);
            if (rsp.getErrcode() != 0L) {
                status = SendStatusEnum.FAIL.getCode();
                flag = false;
            }
            dingTalkSendRecordDto.setErrMsg(rsp.getErrmsg());
        }
        catch (Exception e) {
            logger.error("\u9489\u9489\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
            status = SendStatusEnum.FAIL.getCode();
            dingTalkSendRecordDto.setErrMsg(e.getMessage());
            flag = false;
        }
        dingTalkSendRecordDto.setStatus(status);
        if (HussarUtils.isEmpty((Object)dingTalkSendRecordDto.getMsgId())) {
            String msgId = IdUtil.fastSimpleUuid();
            Date now = new Date();
            dingTalkSendRecordDto.setMsgId(msgId);
            dingTalkSendRecordDto.setCreateTime(now);
            Date sendTime = new Date();
            dingTalkSendRecordDto.setSendTime(sendTime);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            dingTalkSendRecordDto.setCreateDate(dateFormat.format(now));
            this.dingTalkSendRecordService.saveRecord(dingTalkSendRecordDto);
        }
        return flag;
    }

    private OapiMessageCorpconversationAsyncsendV2Response sendDingTalkThirdMsg(DingTalkParamDto paramDto) {
        String token = this.getToken(paramDto);
        String msgUrl = this.unifiedMessageProperties.getDingTalkMsgUrl();
        if (HussarUtils.isEmpty((Object)msgUrl)) {
            throw new RuntimeException("hussar.message.ding-talk-msg-url " + TranslateUtil.getTranslateName((String)"msg.api.conf.item.nonexistent"));
        }
        OapiMessageCorpconversationAsyncsendV2Response rsp = new OapiMessageCorpconversationAsyncsendV2Response();
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient(msgUrl);
            OapiMessageCorpconversationAsyncsendV2Request req = new OapiMessageCorpconversationAsyncsendV2Request();
            req.setAgentId(paramDto.getAgentId());
            req.setUseridList(paramDto.getUserList());
            OapiMessageCorpconversationAsyncsendV2Request.Msg msg = new OapiMessageCorpconversationAsyncsendV2Request.Msg();
            this.buildMessage(paramDto, msg);
            req.setMsg(msg);
            rsp = (OapiMessageCorpconversationAsyncsendV2Response)client.execute((TaobaoRequest)req, token);
        }
        catch (ApiException e) {
            logger.error("\u8c03\u7528\u9489\u9489\u53d1\u9001\u5de5\u4f5c\u901a\u77e5\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38:" + (Object)((Object)e));
        }
        return rsp;
    }

    private void buildMessage(DingTalkParamDto paramDto, OapiMessageCorpconversationAsyncsendV2Request.Msg msg) {
        OapiMessageCorpconversationAsyncsendV2Request.ActionCard actionCard;
        if (HussarUtils.isEmpty((Object)paramDto.getMessageType()) || "text".equals(paramDto.getMessageType())) {
            OapiMessageCorpconversationAsyncsendV2Request.Text text = new OapiMessageCorpconversationAsyncsendV2Request.Text();
            text.setContent(paramDto.getContent());
            msg.setMsgtype("text");
            msg.setText(text);
        }
        if ("markdown".equals(paramDto.getMessageType())) {
            OapiMessageCorpconversationAsyncsendV2Request.Markdown markdown = new OapiMessageCorpconversationAsyncsendV2Request.Markdown();
            markdown.setText(paramDto.getContent());
            markdown.setTitle(paramDto.getTitle());
            msg.setMsgtype("markdown");
            msg.setMarkdown(markdown);
        }
        if ("action_card_single".equals(paramDto.getMessageType())) {
            actionCard = new OapiMessageCorpconversationAsyncsendV2Request.ActionCard();
            actionCard.setTitle(paramDto.getTitle());
            actionCard.setMarkdown(paramDto.getContent());
            actionCard.setSingleTitle(paramDto.getSingleTitle());
            actionCard.setSingleUrl(paramDto.getSingleUrl());
            msg.setMsgtype("action_card");
            msg.setActionCard(actionCard);
        }
        if ("action_card_btn".equals(paramDto.getMessageType())) {
            actionCard = new OapiMessageCorpconversationAsyncsendV2Request.ActionCard();
            actionCard.setTitle(paramDto.getTitle());
            actionCard.setMarkdown(paramDto.getContent());
            actionCard.setBtnOrientation(paramDto.getBtnOrientation());
            actionCard.setBtnJsonList(JSON.parseArray((String)paramDto.getBtnJsonList(), OapiMessageCorpconversationAsyncsendV2Request.BtnJsonList.class));
            msg.setMsgtype("action_card");
            msg.setActionCard(actionCard);
        }
    }

    private String getToken(DingTalkParamDto paramDto) {
        String token = "";
        String tokenUrl = this.unifiedMessageProperties.getDingTalkTokenUrl();
        if (HussarUtils.isEmpty((Object)tokenUrl)) {
            throw new RuntimeException("hussar.message.ding-talk-token-url " + TranslateUtil.getTranslateName((String)"msg.api.conf.item.nonexistent"));
        }
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient(tokenUrl);
            OapiGettokenRequest req = new OapiGettokenRequest();
            req.setAppkey(paramDto.getAppKey());
            req.setAppsecret(paramDto.getAppSecret());
            req.setHttpMethod("GET");
            OapiGettokenResponse rsp = (OapiGettokenResponse)client.execute((TaobaoRequest)req);
            token = rsp.getAccessToken();
        }
        catch (ApiException e) {
            logger.error("\u8c03\u7528\u9489\u9489\u83b7\u53d6token\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38:" + (Object)((Object)e));
        }
        return token;
    }
}

