/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.dingtalk.service.impl;

import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.AppEnum;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.common.model.SendRecordTenant;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkSendDto;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkSendRecordDto;
import com.jxdinfo.hussar.msg.dingtalk.model.DingTalkChannel;
import com.jxdinfo.hussar.msg.dingtalk.model.MsgDingTalkTemplate;
import com.jxdinfo.hussar.msg.dingtalk.service.DingTalkChannelService;
import com.jxdinfo.hussar.msg.dingtalk.service.DingTalkSendService;
import com.jxdinfo.hussar.msg.dingtalk.service.MsgDingTalkSendAsyncService;
import com.jxdinfo.hussar.msg.dingtalk.service.MsgDingTalkTemplateService;
import com.jxdinfo.hussar.msg.dingtalk.third.service.DingTalkThirdService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DingTalkSendServiceImpl
implements DingTalkSendService {
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private DingTalkChannelService dingTalkChannelService;
    @Autowired(required=false)
    private DingTalkThirdService dingTalkThirdService;
    @Autowired
    private MsgDingTalkSendAsyncService dingTalkSendAsyncService;
    @Autowired
    private MsgDingTalkTemplateService msgDingTalkTemplateService;

    public boolean send(DingTalkSendDto dto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(dto.getAppId(), dto.getAppSecret());
        ConfigJsonData configData = this.appSceneConfigService.getConfigData(dto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.DINGTALK.getCode());
        dto.setChannelNo(configData.getChannelNo());
        DingTalkChannel channel = this.dingTalkChannelService.selectbyChannelNo(dto.getChannelNo());
        if (null == channel) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.channel.info.nonexistent"));
        }
        DingTalkSendRecordDto record = new DingTalkSendRecordDto();
        record.setChannelId(channel.getId().toString());
        record.setChannelNo(channel.getChannelNo());
        record.setChannelName(channel.getChannelName());
        record.setAppKey(channel.getAppKey());
        record.setDingAppSecret(channel.getAppSecret());
        record.setDingAppName(channel.getAppName());
        record.setAgentId(channel.getAgentId());
        record.setCorpName(channel.getCorpName());
        record.setToUser(dto.getToUser());
        record.setContent(dto.getData());
        record.setTim(dto.getTim());
        record.setJobTime(dto.getJobTime());
        record.setAppId(dto.getAppId());
        record.setAppName(appAccess.getAppName());
        record.setAppSecret(dto.getAppSecret());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        record.setSceneCode(dto.getSceneCode());
        record.setSceneName(configData.getSceneName());
        TenantCodeUtils.fillTenantCode((SendRecordTenant)record);
        return this.dingTalkSendAsyncService.sendDingTalkAsyncMsg(record);
    }

    public boolean testSendMsg(DingTalkSendDto dto) {
        if (HussarUtils.isEmpty((Object)dto)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.params.empty"));
        }
        DingTalkChannel channel = this.dingTalkChannelService.selectbyChannelNo(dto.getChannelNo());
        if (HussarUtils.isEmpty((Object)channel)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.channel.info.nonexistent"));
        }
        DingTalkSendRecordDto dingTalkSendRecordDto = new DingTalkSendRecordDto();
        dingTalkSendRecordDto.setChannelId(channel.getId().toString());
        dingTalkSendRecordDto.setChannelNo(channel.getChannelNo());
        dingTalkSendRecordDto.setChannelName(channel.getChannelName());
        dingTalkSendRecordDto.setAgentId(channel.getAgentId());
        dingTalkSendRecordDto.setDingAppName(channel.getAppName());
        dingTalkSendRecordDto.setCorpName(channel.getCorpName());
        dingTalkSendRecordDto.setAppKey(channel.getAppKey());
        dingTalkSendRecordDto.setDingAppSecret(channel.getAppSecret());
        dingTalkSendRecordDto.setToUser(dto.getToUser());
        dingTalkSendRecordDto.setContent(dto.getData());
        dingTalkSendRecordDto.setStatus(SendStatusEnum.SENDING.getCode());
        dingTalkSendRecordDto.setTim(dto.getTim());
        dingTalkSendRecordDto.setJobTime(dto.getJobTime());
        dingTalkSendRecordDto.setTenantCode(dto.getTenantCode());
        Long templateId = dto.getTemplateId();
        if (HussarUtils.isNotEmpty((Object)templateId)) {
            Map dingTalkParams = dto.getDingTalkParams();
            MsgDingTalkTemplate msgDingTalkTemplate = (MsgDingTalkTemplate)this.msgDingTalkTemplateService.getById((Serializable)templateId);
            HussarUtils.copy((Object)msgDingTalkTemplate, (Object)dingTalkSendRecordDto);
            dingTalkSendRecordDto.setDingTalkParams(dingTalkParams);
            dingTalkSendRecordDto.setTitle(TemplateUtils.replaceParams((String)dingTalkSendRecordDto.getTitle(), (Map)dingTalkParams));
            dingTalkSendRecordDto.setBtnJsonList(TemplateUtils.replaceParams((String)dingTalkSendRecordDto.getBtnJsonList(), (Map)dingTalkParams));
            dingTalkSendRecordDto.setContent(TemplateUtils.replaceParams((String)dingTalkSendRecordDto.getContent(), (Map)dingTalkParams));
            dingTalkSendRecordDto.setSingleTitle(TemplateUtils.replaceParams((String)dingTalkSendRecordDto.getSingleTitle(), (Map)dingTalkParams));
            dingTalkSendRecordDto.setSingleUrl(TemplateUtils.replaceParams((String)dingTalkSendRecordDto.getSingleUrl(), (Map)dingTalkParams));
        }
        dingTalkSendRecordDto.setAppId(AppEnum.TEST.getAppId());
        dingTalkSendRecordDto.setAppName(AppEnum.TEST.getAppName());
        dingTalkSendRecordDto.setAppSecret(AppEnum.TEST.getAppSecret());
        dingTalkSendRecordDto.setSceneCode(AppEnum.TEST.getSceneCode());
        dingTalkSendRecordDto.setSceneName(AppEnum.TEST.getSceneName());
        return this.dingTalkThirdService.sendDingTalkTimMsg(dingTalkSendRecordDto);
    }
}

