/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.contact.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.authorization.organ.vo.OrganExcelCheckResult;
import com.jxdinfo.hussar.excel.model.ExcelCheckResult;
import com.jxdinfo.hussar.excel.model.ExcelImportMsg;
import com.jxdinfo.hussar.excel.service.IHussarBaseCustomExcelService;
import com.jxdinfo.hussar.excel.validate.HussarBaseExcelValidateHelper;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.msg.common.enums.TipConstantsEnum;
import com.jxdinfo.hussar.msg.contact.dto.MsgContactExcelCopyCheck;
import com.jxdinfo.hussar.msg.contact.model.MsgContact;
import com.jxdinfo.hussar.msg.contact.model.MsgContactExcel;
import com.jxdinfo.hussar.msg.contact.model.MsgContactInfo;
import com.jxdinfo.hussar.msg.contact.model.MsgSupportedSendType;
import com.jxdinfo.hussar.msg.contact.model.MsgTag;
import com.jxdinfo.hussar.msg.contact.service.MsgContactInfoService;
import com.jxdinfo.hussar.msg.contact.service.MsgContactService;
import com.jxdinfo.hussar.msg.contact.service.MsgSupportedSendTypeService;
import com.jxdinfo.hussar.msg.contact.service.MsgTagService;
import com.jxdinfo.hussar.msg.contact.utils.MsgFormatCheckResult;
import com.jxdinfo.hussar.msg.contact.utils.MsgFormatCheckUtil;
import com.jxdinfo.hussar.msg.contact.vo.MsgSupportedSendTypeVo;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.msg.contact.service.impl.MsgContactCustomExcelServiceImpl")
public class MsgContactCustomExcelServiceImpl
implements IHussarBaseCustomExcelService<MsgContactExcel> {
    @Autowired
    private MsgContactInfoService msgContactInfoService;
    @Autowired
    private MsgContactService msgContactService;
    @Autowired
    private MsgSupportedSendTypeService msgSupportedSendTypeService;
    @Autowired
    private MsgTagService msgTagService;
    @Autowired
    private ISysDicRefService sysDicRefService;

    public ExcelCheckResult check(List<MsgContactExcel> datas, Long taskId, List<Object> otherParams) throws Exception {
        ArrayList<MsgContactExcel> rootDataList = new ArrayList<MsgContactExcel>(datas);
        ArrayList<MsgContactExcel> successDataList = new ArrayList<MsgContactExcel>();
        ArrayList<ExcelImportMsg<MsgContactExcel>> newDataList = new ArrayList<ExcelImportMsg<MsgContactExcel>>();
        ArrayList<ExcelImportMsg<MsgContactExcel>> updateDataList = new ArrayList<ExcelImportMsg<MsgContactExcel>>();
        ArrayList<ExcelImportMsg<MsgContactExcel>> existDataList = new ArrayList<ExcelImportMsg<MsgContactExcel>>();
        ArrayList<ExcelImportMsg<MsgContactExcel>> errorDataList = new ArrayList<ExcelImportMsg<MsgContactExcel>>();
        OrganExcelCheckResult contactExcelCheckResult = new OrganExcelCheckResult();
        this.contactCheck(rootDataList, successDataList, newDataList, updateDataList, existDataList, errorDataList);
        if (HussarUtils.isNotEmpty(errorDataList)) {
            contactExcelCheckResult.setRootNum(datas.size());
            contactExcelCheckResult.setErrorNum(errorDataList.size());
            ExcelCheckResult excelCheckResult = new ExcelCheckResult(rootDataList, successDataList, errorDataList, newDataList, updateDataList, existDataList);
            excelCheckResult.setCheckMsg((Object)contactExcelCheckResult);
            return excelCheckResult;
        }
        contactExcelCheckResult.setRootNum(datas.size());
        contactExcelCheckResult.setErrorNum(errorDataList.size());
        contactExcelCheckResult.setNewNum(newDataList.size());
        contactExcelCheckResult.setUpdateNum(updateDataList.size());
        contactExcelCheckResult.setExistNum(existDataList.size());
        ExcelCheckResult excelCheckResult = new ExcelCheckResult(rootDataList, successDataList, errorDataList, newDataList, updateDataList, existDataList);
        excelCheckResult.setCheckMsg((Object)contactExcelCheckResult);
        return excelCheckResult;
    }

    private void contactCheck(List<MsgContactExcel> rootDataList, List<MsgContactExcel> successDataList, List<ExcelImportMsg<MsgContactExcel>> newDataList, List<ExcelImportMsg<MsgContactExcel>> updateDataList, List<ExcelImportMsg<MsgContactExcel>> existDataList, List<ExcelImportMsg<MsgContactExcel>> errorDataList) {
        List msgContactTypeList = this.sysDicRefService.getDicListByType("msg_contact_type");
        TranslateUtil.translate((List)msgContactTypeList, DicVo::getLabelLangKey, DicVo::setLabel);
        List<String> contactTypeList = msgContactTypeList.stream().map(DicVo::getValue).collect(Collectors.toList());
        Map<String, String> contactTypeMap = msgContactTypeList.stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue));
        List sendTypeList = this.msgSupportedSendTypeService.list((Wrapper)new LambdaQueryWrapper().eq(MsgSupportedSendType::getNeedFrontDisplay, (Object)1));
        if (TranslateUtil.getIsEnable()) {
            for (MsgSupportedSendType sendType : sendTypeList) {
                if (!HussarUtils.isNotEmpty((Object)TranslateUtil.getTranslateName((String)sendType.getSendTypeName()))) continue;
                sendType.setSendTypeName(TranslateUtil.getTranslateName((String)sendType.getSendTypeName()));
            }
        }
        List<String> sendTypeCodeList = sendTypeList.stream().map(MsgSupportedSendType::getSendTypeCode).collect(Collectors.toList());
        Map<String, String> sendTypeMap = sendTypeList.stream().collect(Collectors.toMap(MsgSupportedSendType::getSendTypeName, MsgSupportedSendType::getSendTypeCode));
        List<String> tagList = this.msgTagService.list().stream().map(MsgTag::getTagName).collect(Collectors.toList());
        tagList.add("default");
        HashSet<String> checkTagRepeatSet = new HashSet<String>();
        List msgContactInfos = this.msgContactInfoService.list();
        Map<String, MsgContactInfo> existContactInfoMap = msgContactInfos.stream().collect(Collectors.toMap(this::combineReceiverKey, Function.identity()));
        for (int i = 0; i < rootDataList.size(); ++i) {
            MsgContactExcel msgContactExcel = rootDataList.get(i);
            MsgContactExcelCopyCheck msgContactExcelCopyCheck = (MsgContactExcelCopyCheck)HussarUtils.copy((Object)msgContactExcel, MsgContactExcelCopyCheck.class);
            msgContactExcelCopyCheck.setContactType(contactTypeMap.get(msgContactExcel.getContactType()) != null ? contactTypeMap.get(msgContactExcel.getContactType()) : msgContactExcel.getContactType());
            msgContactExcelCopyCheck.setSendType(sendTypeMap.get(msgContactExcel.getSendType()) != null ? sendTypeMap.get(msgContactExcel.getSendType()) : msgContactExcel.getSendType());
            HashMap<Integer, Map<Integer, String>> cellErrColMap = new HashMap<Integer, Map<Integer, String>>();
            HashMap<Integer, Map<Integer, String>> cellUpdateColMap = new HashMap<Integer, Map<Integer, String>>();
            HashMap<Integer, Map<Integer, String>> cellNewColMap = new HashMap<Integer, Map<Integer, String>>();
            HashMap<Integer, Map<Integer, String>> cellExitColMap = new HashMap<Integer, Map<Integer, String>>();
            this.checkFormat(i, cellErrColMap, contactTypeList, sendTypeCodeList, tagList, checkTagRepeatSet, msgContactExcelCopyCheck);
            this.checkContactInfoForExit(i, cellNewColMap, cellErrColMap, cellExitColMap, cellUpdateColMap, existContactInfoMap, msgContactExcelCopyCheck);
            if (cellErrColMap.size() == 0) {
                successDataList.add(msgContactExcel);
            }
            if (HussarUtils.isNotEmpty(cellErrColMap)) {
                errorDataList.add((ExcelImportMsg<MsgContactExcel>)new ExcelImportMsg((Object)msgContactExcel, cellErrColMap));
            }
            if (HussarUtils.isNotEmpty(cellExitColMap)) {
                existDataList.add((ExcelImportMsg<MsgContactExcel>)new ExcelImportMsg((Object)msgContactExcel, cellExitColMap));
            }
            if (HussarUtils.isNotEmpty(cellUpdateColMap)) {
                updateDataList.add((ExcelImportMsg<MsgContactExcel>)new ExcelImportMsg((Object)msgContactExcel, cellUpdateColMap));
            }
            if (!HussarUtils.isNotEmpty(cellNewColMap)) continue;
            newDataList.add((ExcelImportMsg<MsgContactExcel>)new ExcelImportMsg((Object)msgContactExcel, cellNewColMap));
        }
    }

    private void checkFormat(int i, Map<Integer, Map<Integer, String>> cellErrColMap, List<String> contactTypeList, List<String> sentTypeCodeList, List<String> tagList, Set<String> checkTagRepeatSet, MsgContactExcelCopyCheck msgContactExcelCopyCheck) {
        String tagCheck;
        MsgFormatCheckResult checkTagName;
        MsgFormatCheckResult checkReceiveAddress;
        MsgFormatCheckResult checkSendType;
        MsgFormatCheckResult checkContactName;
        MsgFormatCheckResult checkContactType;
        MsgFormatCheckResult checkContactId = MsgFormatCheckUtil.checkContactId(msgContactExcelCopyCheck.getContactId());
        if (!checkContactId.isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)checkContactId.getMsg(), cellErrColMap);
        }
        if (!(checkContactType = MsgFormatCheckUtil.checkContactType(msgContactExcelCopyCheck.getContactType(), contactTypeList)).isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)1, (String)checkContactType.getMsg(), cellErrColMap);
        }
        if (!(checkContactName = MsgFormatCheckUtil.checkContactName(msgContactExcelCopyCheck.getContactName(), false)).isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)checkContactName.getMsg(), cellErrColMap);
        }
        if (!(checkSendType = MsgFormatCheckUtil.checkSendType(msgContactExcelCopyCheck.getSendType(), sentTypeCodeList)).isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)checkSendType.getMsg(), cellErrColMap);
        }
        if (!(checkReceiveAddress = MsgFormatCheckUtil.checkReceiveAddress(msgContactExcelCopyCheck.getReceiveAddress(), msgContactExcelCopyCheck.getSendType())).isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)5, (String)checkReceiveAddress.getMsg(), cellErrColMap);
        }
        if (!(checkTagName = MsgFormatCheckUtil.checkTagName(msgContactExcelCopyCheck.getTagName(), tagList)).isSuccess()) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)checkTagName.getMsg(), cellErrColMap);
        }
        if (checkContactId.isSuccess() && checkContactType.isSuccess() && checkSendType.isSuccess() && checkTagName.isSuccess() && !checkTagRepeatSet.add(tagCheck = String.format("%s_%s_%s_%s", msgContactExcelCopyCheck.getContactId(), msgContactExcelCopyCheck.getContactType(), msgContactExcelCopyCheck.getSendType(), msgContactExcelCopyCheck.getTagName()))) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_TAGS_EXIST.getMessage()), cellErrColMap);
        }
    }

    private String combineReceiverKey(MsgContactInfo info) {
        return String.format("%s_%s_%s_%s", info.getContactId(), info.getContactType(), info.getSendType(), info.getTagName());
    }

    private String combineReceiverKey(MsgContactExcelCopyCheck info) {
        return String.format("%s_%s_%s_%s", info.getContactId(), info.getContactType(), info.getSendType(), info.getTagName());
    }

    private String combineContactKey(String contactId, String contactType) {
        return String.format("%s_%s", contactId, contactType);
    }

    private void checkContactInfoForExit(int i, Map<Integer, Map<Integer, String>> cellNewColMap, Map<Integer, Map<Integer, String>> cellErrColMap, Map<Integer, Map<Integer, String>> cellExitColMap, Map<Integer, Map<Integer, String>> cellUpdateColMap, Map<String, MsgContactInfo> existContactInfoMap, MsgContactExcelCopyCheck msgContactExcelCopyCheck) {
        int[] indexArrAdd = new int[]{5};
        String contactInfoKey = this.combineReceiverKey(msgContactExcelCopyCheck);
        MsgContactInfo msgContactInfo = existContactInfoMap.get(contactInfoKey);
        if (HussarUtils.isNotEmpty((Object)msgContactInfo)) {
            String receiverAddress = msgContactInfo.getReceiveAddress();
            String contactName = msgContactInfo.getContactName();
            HussarBaseExcelValidateHelper.addMsgBatch((int)i, (String)"exit", cellExitColMap, (int[])indexArrAdd, MsgContactExcel.class);
            if (!receiverAddress.equals(msgContactExcelCopyCheck.getReceiveAddress())) {
                HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)5, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_UPDATE_ADDRESS.getMessage()), cellUpdateColMap);
            }
            if (!contactName.equals(msgContactExcelCopyCheck.getContactName())) {
                HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)2, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_UPDATE_NAME.getMessage()), cellUpdateColMap);
            }
        } else {
            HussarBaseExcelValidateHelper.addMsgBatch((int)i, (String)"add", cellNewColMap, (int[])indexArrAdd, MsgContactExcel.class);
        }
    }

    @HussarTransactional
    public void saveData(List<MsgContactExcel> datas, List<Object> otherParams) {
        List list = this.msgContactService.list();
        Set exitContactSet = list.stream().map(e -> this.combineContactKey(e.getContactId(), e.getContactType())).collect(Collectors.toSet());
        List msgSupportedSendTypeVos = (List)this.msgSupportedSendTypeService.getSendTypeStructure().getData();
        Map<String, String> channelNoMap = msgSupportedSendTypeVos.stream().filter(e -> HussarUtils.isNotEmpty((Object)e.getChannelNo())).collect(Collectors.toMap(MsgSupportedSendTypeVo::getSendTypeCode, MsgSupportedSendTypeVo::getChannelNo));
        List msgContactTypeList = this.sysDicRefService.getDicListByType("msg_contact_type");
        Map<String, String> contactTypeMap = msgContactTypeList.stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue));
        List sendTypeList = this.msgSupportedSendTypeService.list((Wrapper)new LambdaQueryWrapper().eq(MsgSupportedSendType::getNeedFrontDisplay, (Object)1));
        for (MsgSupportedSendType sendType : sendTypeList) {
            if (!HussarUtils.isNotEmpty((Object)TranslateUtil.getTranslateName((String)sendType.getSendTypeName()))) continue;
            sendType.setSendTypeName(TranslateUtil.getTranslateName((String)sendType.getSendTypeName()));
        }
        Map<String, String> sendTypeMap = sendTypeList.stream().collect(Collectors.toMap(MsgSupportedSendType::getSendTypeName, MsgSupportedSendType::getSendTypeCode));
        ArrayList<MsgContact> msgContactList = new ArrayList<MsgContact>();
        ArrayList<MsgContactInfo> msgContactInfoList = new ArrayList<MsgContactInfo>();
        for (MsgContactExcel msgContactExcel : datas) {
            msgContactExcel.setContactType(contactTypeMap.getOrDefault(msgContactExcel.getContactType(), msgContactExcel.getContactType()));
            msgContactExcel.setSendType(sendTypeMap.getOrDefault(msgContactExcel.getSendType(), msgContactExcel.getSendType()));
            if (exitContactSet.add(this.combineContactKey(msgContactExcel.getContactId(), msgContactExcel.getContactType()))) {
                MsgContact msgContact = new MsgContact();
                BeanUtil.copy((Object)msgContactExcel, (Object)msgContact);
                msgContact.assembleIdAndType();
                msgContactList.add(msgContact);
            }
            MsgContactInfo msgContactInfo = new MsgContactInfo();
            BeanUtil.copy((Object)msgContactExcel, (Object)msgContactInfo);
            msgContactInfo.setChannelNo(channelNoMap.get(msgContactExcel.getSendType()));
            msgContactInfo.assembleIdAndType();
            msgContactInfoList.add(msgContactInfo);
        }
        this.msgContactService.saveBatch(msgContactList);
        this.msgContactInfoService.saveBatch(msgContactInfoList);
    }

    @HussarTransactional
    public void updateData(List<MsgContactExcel> datas, List<Object> otherParams) {
        List msgContactTypeList = this.sysDicRefService.getDicListByType("msg_contact_type");
        Map<String, String> contactTypeMap = msgContactTypeList.stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue));
        List sendTypeList = this.msgSupportedSendTypeService.list((Wrapper)new LambdaQueryWrapper().eq(MsgSupportedSendType::getNeedFrontDisplay, (Object)1));
        Map<String, String> sendTypeMap = sendTypeList.stream().collect(Collectors.toMap(MsgSupportedSendType::getSendTypeName, MsgSupportedSendType::getSendTypeCode));
        for (MsgContactExcel msgContactExcel : datas) {
            msgContactExcel.setContactType(contactTypeMap.getOrDefault(msgContactExcel.getContactType(), msgContactExcel.getContactType()));
            msgContactExcel.setSendType(sendTypeMap.getOrDefault(msgContactExcel.getSendType(), msgContactExcel.getSendType()));
            LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(MsgContactInfo::getContactIdAndType, (Object)this.combineContactKey(msgContactExcel.getContactId(), msgContactExcel.getContactType()))).eq(MsgContactInfo::getSendType, (Object)msgContactExcel.getSendType())).eq(MsgContactInfo::getTagName, (Object)msgContactExcel.getTagName())).set(MsgContactInfo::getReceiveAddress, (Object)msgContactExcel.getReceiveAddress())).set(MsgContactInfo::getContactName, (Object)msgContactExcel.getContactName());
            this.msgContactService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(MsgContact::getContactIdAndType, (Object)this.combineContactKey(msgContactExcel.getContactId(), msgContactExcel.getContactType()))).set(MsgContact::getContactName, (Object)msgContactExcel.getContactName()));
            this.msgContactInfoService.update((Wrapper)updateWrapper);
        }
    }
}

