/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.upgrade.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.msg.common.model.MsgUserService;
import com.jxdinfo.hussar.msg.common.properties.UnifiedMessageProperties;
import com.jxdinfo.hussar.msg.common.service.MsgUserServiceService;
import com.jxdinfo.hussar.msg.contact.dto.MsgContactUpdateRestApiDto;
import com.jxdinfo.hussar.msg.contact.dto.RegistrationInfo;
import com.jxdinfo.hussar.msg.contact.model.MsgSupportedSendType;
import com.jxdinfo.hussar.msg.contact.service.MsgContactService;
import com.jxdinfo.hussar.msg.contact.service.MsgSupportedSendTypeService;
import com.jxdinfo.hussar.msg.contact.vo.MsgContactRestApiVo;
import com.jxdinfo.hussar.msg.contact.vo.MsgRestApiDateVo;
import com.jxdinfo.hussar.msg.mp.model.MsgMpChannel;
import com.jxdinfo.hussar.msg.mp.service.MpChannelService;
import com.jxdinfo.hussar.msg.upgrade.service.MsgContactUpgradeService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MsgContactUpgradeServiceImpl
implements MsgContactUpgradeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MsgContactUpgradeServiceImpl.class);
    private static final Map<Integer, String> MAP = new HashMap<Integer, String>();
    @Autowired
    private MsgUserServiceService msgUserServiceService;
    @Autowired
    private MsgContactService msgContactService;
    @Autowired
    private UnifiedMessageProperties unifiedMessageProperties;
    @Autowired
    private MsgSupportedSendTypeService supportedSendTypeService;
    @Autowired
    private MpChannelService mpChannelService;
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;

    public void dataMigration(String channelNo) {
        MAP.clear();
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> this.extracted(channelNo));
    }

    @HussarTransactional
    private void extracted(String channelNo) {
        MsgContactRestApiVo msgContactRestApiVo;
        try {
            List msgUserServices = this.msgUserServiceService.list();
            this.addMsgSupportedSendTypeMpInfo(channelNo);
            ArrayList<MsgContactUpdateRestApiDto> updateRestApiDtos = new ArrayList<MsgContactUpdateRestApiDto>();
            if (HussarUtils.isNotEmpty((Object)msgUserServices)) {
                Map<String, List<MsgUserService>> msgUserServiceMaps = msgUserServices.stream().collect(Collectors.groupingBy(MsgUserService::getUserId));
                for (Map.Entry<String, List<MsgUserService>> msgUserServiceMap : msgUserServiceMaps.entrySet()) {
                    MsgContactUpdateRestApiDto updateRestApiDto = new MsgContactUpdateRestApiDto();
                    HashMap modify = new HashMap();
                    updateRestApiDto.setContactId(msgUserServiceMap.getKey());
                    updateRestApiDto.setContactType("user");
                    updateRestApiDto.setUpgrade(true);
                    for (MsgUserService msgUserService : msgUserServiceMap.getValue()) {
                        ArrayList<RegistrationInfo> registrationInfos = new ArrayList<RegistrationInfo>();
                        RegistrationInfo registrationInfo = new RegistrationInfo();
                        registrationInfo.setTagName("default");
                        registrationInfo.setReceiveAddress(msgUserService.getOtherUserId());
                        String messageType = msgUserService.getMessageType();
                        if ("wx_account".equals(messageType)) {
                            if (HussarUtils.isEmpty((Object)channelNo)) {
                                LOGGER.error("\u901a\u9053\u6807\u8bc6\u4e3a\u7a7a\uff0c\u5c06\u4e0d\u540c\u6b65\u5fae\u4fe1\u516c\u4f17\u53f7\u8054\u7cfb\u65b9\u5f0f");
                                continue;
                            }
                            messageType = messageType + ":" + channelNo;
                            registrationInfo.setChannelNo(channelNo);
                        }
                        registrationInfos.add(registrationInfo);
                        modify.put(messageType, registrationInfos);
                    }
                    updateRestApiDto.setModify(modify);
                    updateRestApiDtos.add(updateRestApiDto);
                }
            }
            msgContactRestApiVo = (MsgContactRestApiVo)this.msgContactService.updateMsgContactRestApi(updateRestApiDtos).getData();
        }
        catch (Exception e) {
            MAP.put(2, "\u6570\u636e\u8fc1\u79fb\u5931\u8d25\uff1a" + e.getMessage());
            throw e;
        }
        List fail = msgContactRestApiVo.getFail();
        if (HussarUtils.isNotEmpty((Object)fail)) {
            String contactIds = Arrays.toString(fail.stream().map(MsgRestApiDateVo::getContactId).toArray());
            MAP.put(2, "\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff1a\r\n" + contactIds);
            LOGGER.error("\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff1a\r\n{}", (Object)contactIds);
            throw new BaseException(TranslateUtil.getTranslateName((String)"msg.api.data.migration.fail"));
        }
        MAP.put(1, "\u6570\u636e\u8fc1\u79fb\u6210\u529f");
        LOGGER.info("\u6570\u636e\u8fc1\u79fb\u6210\u529f");
    }

    public ApiResponse<Boolean> isDataMigration() {
        return ApiResponse.success((Object)this.unifiedMessageProperties.isDataMigration());
    }

    public ApiResponse<Map<Integer, String>> dataMigrationStatus() {
        return ApiResponse.success(MAP);
    }

    private void addMsgSupportedSendTypeMpInfo(String channelNo) {
        MsgMpChannel msgMpChannel;
        if (HussarUtils.isNotEmpty((Object)channelNo) && HussarUtils.isNotEmpty((Object)(msgMpChannel = this.mpChannelService.getChannelInfo(channelNo)))) {
            List channelNos = this.mpChannelService.list().stream().map(MsgMpChannel::getChannelNo).collect(Collectors.toList());
            this.supportedSendTypeService.remove((Wrapper)new LambdaQueryWrapper().in(MsgSupportedSendType::getChannelNo, channelNos));
            for (String channel : channelNos) {
                this.supportedSendTypeService.saveSupportedSendType("wx_account", channel, msgMpChannel.getChannelName());
            }
        }
    }
}

