/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.station.impl;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.station.dto.StationSendMsgDto;
import com.jxdinfo.hussar.msg.station.dto.StationSendRecordDto;
import com.jxdinfo.hussar.msg.station.service.IMsgStationSendService;
import com.jxdinfo.hussar.msg.station.service.IStationSendRecordService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.text.ParseException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.msg.station.impl.msgStationSendServiceImpl")
public class MsgStationSendServiceImpl
implements IMsgStationSendService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MsgStationSendServiceImpl.class);
    @Autowired
    private IStationSendRecordService sendRecordService;
    private static final String MANUAL_TESTING = "manual testing";

    public void sendMsg(StationSendMsgDto stationSendMsgDto) {
        String msgTitle = stationSendMsgDto.getMsgTitle();
        String msgContent = stationSendMsgDto.getMsgContent();
        String stationType = stationSendMsgDto.getStationType();
        String msgWebUrl = stationSendMsgDto.getMsgWebUrl();
        String msgMobileUrl = stationSendMsgDto.getMsgMobileUrl();
        List receiverUserIds = stationSendMsgDto.getReceiverUserIds();
        Boolean tim = stationSendMsgDto.getTim();
        String jobTime = stationSendMsgDto.getJobTime();
        String appId = "test";
        String appSecret = "test";
        String sceneCode = "test";
        String tenantCode = stationSendMsgDto.getTenantCode();
        String templateNo = "test";
        String templateName = TranslateUtil.getTranslateName((String)MANUAL_TESTING);
        String appName = TranslateUtil.getTranslateName((String)MANUAL_TESTING);
        String sceneName = TranslateUtil.getTranslateName((String)MANUAL_TESTING);
        StationSendRecordDto record = new StationSendRecordDto();
        record.setAppId(appId);
        record.setAppSecret(appSecret);
        record.setSceneCode(sceneCode);
        record.setTim(tim);
        record.setStationType(stationType);
        if (StringUtils.isNotBlank((CharSequence)tenantCode)) {
            record.setTenantCode(tenantCode);
        } else {
            String tenantCodeTemp = HussarContextHolder.getHussarTenant().getTenantCode();
            record.setTenantCode(StringUtils.isNotBlank((CharSequence)tenantCodeTemp) ? tenantCodeTemp : "0");
        }
        record.setUserSendId(BaseSecurityUtil.getUser().getId());
        record.setReceiverUserIds(receiverUserIds);
        record.setMsgTitle(msgTitle);
        record.setMsgContent(msgContent);
        record.setMsgMobileUrl(msgMobileUrl);
        record.setMsgWebUrl(msgWebUrl);
        record.setStatus(SendStatusEnum.SENDING.getCode());
        record.setStationType(stationSendMsgDto.getStationType());
        record.setTemplateName(templateName);
        record.setTemplateNo(templateNo);
        record.setAppName(appName);
        record.setSceneName(sceneName);
        if (StringUtils.isNotBlank((CharSequence)jobTime)) {
            try {
                record.setJobTime(DateUtils.parseDate((String)jobTime, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
            }
            catch (ParseException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        this.sendRecordService.save(record);
    }
}

