/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.cp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.common.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.common.utils.BizCodeUtils;
import com.jxdinfo.hussar.msg.cp.dao.MsgCpChannelMapper;
import com.jxdinfo.hussar.msg.cp.dto.CpChannelCreateDto;
import com.jxdinfo.hussar.msg.cp.dto.CpChannelPageDto;
import com.jxdinfo.hussar.msg.cp.dto.CpChannelUpdateDto;
import com.jxdinfo.hussar.msg.cp.model.MsgCpChannel;
import com.jxdinfo.hussar.msg.cp.service.CpChannelService;
import com.jxdinfo.hussar.msg.cp.vo.CpChannelQueryVo;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class CpChannelServiceImpl
extends HussarServiceImpl<MsgCpChannelMapper, MsgCpChannel>
implements CpChannelService {
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private IHussarValidateService validateService;

    public IPage<MsgCpChannel> listPage(Page page, CpChannelPageDto pageDto) {
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getChannelName())) {
            pageDto.setChannelName(SqlQueryUtil.transferSpecialChar((String)pageDto.getChannelName().trim()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getChannelNo())) {
            pageDto.setChannelNo(SqlQueryUtil.transferSpecialChar((String)pageDto.getChannelNo().trim()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getCorpName())) {
            pageDto.setCorpName(SqlQueryUtil.transferSpecialChar((String)pageDto.getCorpName().trim()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getAgentName())) {
            pageDto.setAgentName(SqlQueryUtil.transferSpecialChar((String)pageDto.getAgentName().trim()));
        }
        IPage<MsgCpChannel> pageList = ((MsgCpChannelMapper)this.baseMapper).queryPage(page, pageDto);
        return pageList;
    }

    @HussarTransactional
    public boolean save(CpChannelCreateDto createDto) {
        if (!StringUtils.isNumeric((CharSequence)createDto.getAgentId())) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.numerical.channel.id"));
        }
        MsgCpChannel entity = new MsgCpChannel();
        BeanUtils.copyProperties((Object)createDto, (Object)entity);
        String validate = this.validateService.validate((Object)createDto);
        if (validate != null && !"".equals(validate)) {
            throw new HussarException(validate);
        }
        Long id = IdWorker.getId((Object)entity);
        entity.setId(id);
        entity.setChannelNo(BizCodeUtils.generalBizCode((BizCodeEnum)BizCodeEnum.CP_CHANNEL));
        if (HussarUtils.equals((Object)"1", (Object)this.checkChannelUnique(entity))) {
            throw new HussarException(entity.getChannelName() + " : " + TranslateUtil.getTranslateName((String)"msg.api.duplicated.channel.name"));
        }
        super.save((BaseEntity)entity);
        return true;
    }

    @HussarTransactional
    public boolean update(CpChannelUpdateDto updateDto) {
        if (!StringUtils.isNumeric((CharSequence)updateDto.getAgentId())) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.numerical.channel.id"));
        }
        MsgCpChannel entity = new MsgCpChannel();
        BeanUtils.copyProperties((Object)updateDto, (Object)entity);
        String validate = this.validateService.validate((Object)updateDto);
        if (validate != null && !"".equals(validate)) {
            throw new HussarException(validate);
        }
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgCpChannel::getId, (Object)updateDto.getId());
        MsgCpChannel info = (MsgCpChannel)((MsgCpChannelMapper)this.baseMapper).selectOne((Wrapper)qw);
        if (HussarUtils.isEmpty((Object)info)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.nonexistent.channel"));
        }
        if (HussarUtils.equals((Object)"1", (Object)this.checkChannelUnique(entity))) {
            throw new HussarException(entity.getChannelName() + " : " + TranslateUtil.getTranslateName((String)"msg.api.duplicated.channel.name"));
        }
        if (!HussarUtils.equals((Object)info.getStatus(), (Object)updateDto.getStatus()) && this.appSceneConfigService.isExistSceneInBatch(new ArrayList<String>(Collections.singletonList(info.getChannelNo())))) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.del.corr.startup.fail"));
        }
        super.updateById((BaseEntity)entity);
        return true;
    }

    @HussarTransactional
    public boolean delete(Long id) {
        MsgCpChannel msgCpChannel = (MsgCpChannel)((MsgCpChannelMapper)this.baseMapper).selectById(id);
        if (this.appSceneConfigService.isExistScene(msgCpChannel.getChannelNo())) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.scene.del.corr"));
        }
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgCpChannel::getId, (Object)id);
        MsgCpChannel info = (MsgCpChannel)((MsgCpChannelMapper)this.baseMapper).selectOne((Wrapper)qw);
        if (HussarUtils.isEmpty((Object)info)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.delete.nonexistent.channel"));
        }
        super.removeById((Serializable)id);
        return true;
    }

    @HussarTransactional
    public boolean deleteChannelByIds(Long[] ids) {
        List channelNos = super.listByIds(Arrays.asList(ids)).stream().map(MsgCpChannel::getChannelNo).collect(Collectors.toList());
        if (this.appSceneConfigService.isExistSceneInBatch(channelNos)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.scene.del.corr"));
        }
        super.removeByIds(Arrays.asList(ids));
        return true;
    }

    private CpChannelQueryVo entity2QueryVo(MsgCpChannel entity) {
        CpChannelQueryVo vo = new CpChannelQueryVo();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        return vo;
    }

    public List<CpChannelQueryVo> getChannelList() {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgCpChannel::getStatus, (Object)OpenStatusEnum.ENABLE.getCode());
        qw.lambda().orderByDesc(HussarBaseEntity::getCreateTime);
        List list = ((MsgCpChannelMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
    }

    public MsgCpChannel selectChannel(Long id, String channelNo) {
        MsgCpChannel channel;
        QueryWrapper qw = new QueryWrapper();
        if (id != null) {
            qw.lambda().eq(MsgCpChannel::getId, (Object)id);
        }
        if ((channel = (MsgCpChannel)((MsgCpChannelMapper)this.baseMapper).selectOne((Wrapper)qw)) == null) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.nonexistent.channel.corr"));
        }
        if (channel.getStatus() == null || !channel.getStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.not.enabled.channel"));
        }
        return channel;
    }

    public Map<String, String> getChannelNoAndName(List<String> channelNos) {
        if (HussarUtils.isEmpty(channelNos)) {
            return new HashMap<String, String>();
        }
        Map<String, String> channelNoAndName = super.list((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{MsgCpChannel::getChannelNo, MsgCpChannel::getChannelName}).in(MsgCpChannel::getChannelNo, channelNos)).stream().collect(Collectors.toMap(MsgCpChannel::getChannelNo, MsgCpChannel::getChannelName));
        channelNoAndName.put("null", TranslateUtil.getTranslateName((String)"msg.api.channel.empty"));
        return channelNoAndName;
    }

    private String checkChannelUnique(MsgCpChannel entity) {
        Long id = HussarUtils.isEmpty((Object)entity.getId()) ? -1L : entity.getId();
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgCpChannel::getChannelName, (Object)entity.getChannelName());
        MsgCpChannel info = (MsgCpChannel)this.getOne((Wrapper)qw, false);
        if (HussarUtils.isNotEmpty((Object)info) && !HussarUtils.equals((Object)info.getId(), (Object)id)) {
            return "1";
        }
        return "0";
    }
}

