/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.contact.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.msg.app.model.AppSceneConfig;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.contact.dao.MsgTagMapper;
import com.jxdinfo.hussar.msg.contact.model.MsgContactInfo;
import com.jxdinfo.hussar.msg.contact.model.MsgTag;
import com.jxdinfo.hussar.msg.contact.service.MsgContactInfoService;
import com.jxdinfo.hussar.msg.contact.service.MsgTagService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MsgTagServiceImpl
extends HussarServiceImpl<MsgTagMapper, MsgTag>
implements MsgTagService {
    private static final List<String> TAG_KEY = Collections.unmodifiableList(Arrays.asList("default", "\u9ed8\u8ba4", "NULL", "null", "\u65e0", "\u7a7a"));
    private static final String DEFAULT_TAG_KEY = "default";
    private static Logger logger = LoggerFactory.getLogger(MsgTagServiceImpl.class);
    @Resource
    private MsgTagMapper msgTagMapper;
    @Resource
    private MsgContactInfoService msgContactInfoService;
    @Resource
    private AppSceneConfigService appSceneConfigService;

    public ApiResponse<List<String>> tagList(Long size, Long current) {
        Page page = new Page(current.longValue(), size.longValue());
        List records = ((Page)this.msgTagMapper.selectPage((IPage)page, null)).getRecords();
        List tagNameList = records.stream().map(MsgTag::getTagName).collect(Collectors.toList());
        return ApiResponse.success(tagNameList);
    }

    public Page<MsgTag> tagPage(Long size, Long current, String tagName) {
        Page page = new Page(current == null ? 1L : current, size == null ? 10L : size);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)tagName)) {
            wrapper.like(MsgTag::getTagName, (Object)tagName);
        }
        return (Page)this.msgTagMapper.selectPage((IPage)page, (Wrapper)wrapper);
    }

    @HussarTransactional
    public ApiResponse<Boolean> saveTag(String tagName) {
        if (TAG_KEY.contains(tagName)) {
            return ApiResponse.fail((String)("\u6807\u7b7e\u540d\u4e0d\u80fd\u4f7f\u7528\u5982\u4e0b\u5173\u952e\u5b57: " + String.join((CharSequence)",", TAG_KEY)));
        }
        if (HussarUtils.isEmpty((Object)tagName)) {
            tagName = DEFAULT_TAG_KEY;
        }
        this.msgTagMapper.insert(new MsgTag(null, tagName));
        return ApiResponse.success();
    }

    @HussarTransactional
    public ApiResponse deleteTag(String tag) {
        List list = this.appSceneConfigService.getAppSceneConfigBytag(tag.trim());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (HussarUtils.isNotEmpty((Object)list) && list.size() > 0) {
            List collection = list.stream().map(AppSceneConfig::getSceneName).distinct().collect(Collectors.toList());
            String nameByJoin = String.join((CharSequence)",", collection);
            String message = null;
            if (collection.size() > 2) {
                int secondCommaIndex = nameByJoin.indexOf(",", nameByJoin.indexOf(",") + 1);
                message = String.format("%s\u7b49%s\u4e2a\u573a\u666f\u6b63\u5173\u8054\u6b64\u573a\u666f\uff0c\u65e0\u6cd5\u5220\u9664", nameByJoin.substring(0, secondCommaIndex), collection.size());
            } else {
                message = String.format("%s\u573a\u666f\u6b63\u5173\u8054\u6b64\u573a\u666f\uff0c\u65e0\u6cd5\u5220\u9664", nameByJoin);
            }
            map.put("deleteStatus", 2);
            return ApiResponse.fail((int)10000, map, (String)message);
        }
        List msgContactInfoList = this.msgContactInfoService.getMsgContactInfoList(tag);
        if (HussarUtils.isNotEmpty((Object)msgContactInfoList) && msgContactInfoList.size() > 0) {
            List taNameList = msgContactInfoList.stream().map(MsgContactInfo::getContactName).distinct().collect(Collectors.toList());
            String tagnameString = String.join((CharSequence)", ", taNameList);
            String message = null;
            if (taNameList.size() > 3) {
                String join = String.join((CharSequence)", ", taNameList.subList(0, 3));
                message = String.format("%s\u7b49%s\u4f4d\u8054\u7cfb\u4eba\u6b63\u4f7f\u7528\u6b64\u6807\u7b7e\uff0c\u65e0\u6cd5\u5220\u9664", join, taNameList.size());
            } else if (taNameList.size() == 3) {
                message = String.format("%s\u4e09\u4f4d\u8054\u7cfb\u4eba\u6b63\u4f7f\u7528\u6b64\u6807\u7b7e\uff0c\u65e0\u6cd5\u5220\u9664", tagnameString, taNameList.size());
            } else if (taNameList.size() == 2) {
                message = String.format("%s\u4e24\u4f4d\u8054\u7cfb\u4eba\u6b63\u4f7f\u7528\u6b64\u6807\u7b7e\uff0c\u65e0\u6cd5\u5220\u9664", tagnameString, taNameList.size());
            } else if (taNameList.size() == 1) {
                message = String.format("\u8054\u7cfb\u4eba%s\u6b63\u4f7f\u7528\u6b64\u6807\u7b7e\uff0c\u65e0\u6cd5\u5220\u9664", tagnameString, taNameList.size());
            }
            map.put("deleteStatus", 2);
            return ApiResponse.fail((int)10000, map, (String)message);
        }
        int delete = this.msgTagMapper.delete((Wrapper)new LambdaQueryWrapper().eq(MsgTag::getTagName, (Object)tag));
        map.put("deleteStatus", 1);
        return delete > 0 ? ApiResponse.success(map, (String)"success") : ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25");
    }

    @HussarTransactional
    public ApiResponse<Boolean> removeTagAndContract(String tag) {
        this.msgContactInfoService.updateContactByTag(tag);
        this.msgTagMapper.delete((Wrapper)new LambdaQueryWrapper().eq(MsgTag::getTagName, (Object)tag));
        return ApiResponse.success((Object)true);
    }
}

