/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.apppush.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.apppush.dao.AppPushChannelMapper;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushChannelCreateDto;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushChannelPageDto;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushChannelUpdateDto;
import com.jxdinfo.hussar.msg.apppush.model.AppPushChannel;
import com.jxdinfo.hussar.msg.apppush.service.AppPushChannelService;
import com.jxdinfo.hussar.msg.apppush.vo.AppPushChannelQueryVo;
import com.jxdinfo.hussar.msg.common.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.common.utils.BizCodeUtils;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class AppPushChannelServiceImpl
extends HussarServiceImpl<AppPushChannelMapper, AppPushChannel>
implements AppPushChannelService {
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public IPage<AppPushChannel> listPage(Page page, AppPushChannelPageDto pageDto) {
        pageDto.setChannelNo(SqlQueryUtil.transferSpecialChar((String)pageDto.getChannelNo()));
        pageDto.setChannelName(SqlQueryUtil.transferSpecialChar((String)pageDto.getChannelName()));
        IPage<AppPushChannel> pageList = ((AppPushChannelMapper)this.baseMapper).queryPage(page, pageDto);
        return pageList;
    }

    public AppPushChannelQueryVo findById(long id) {
        AppPushChannel entity = (AppPushChannel)super.getById((Serializable)Long.valueOf(id));
        return this.entity2QueryVo(entity);
    }

    @HussarTransactional
    public boolean save(AppPushChannelCreateDto createDto) {
        AppPushChannel entity = new AppPushChannel();
        BeanUtils.copyProperties((Object)createDto, (Object)entity);
        entity.setChannelNo(BizCodeUtils.generalBizCode((BizCodeEnum)BizCodeEnum.APP_PUSH_CHANNEL));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AppPushChannel::getChannelName, (Object)entity.getChannelName());
        long count = ((AppPushChannelMapper)this.baseMapper).selectCount((Wrapper)queryWrapper);
        if (count > 0L) {
            throw new HussarException(entity.getChannelName() + " : " + TranslateUtil.getTranslateName((String)"msg.api.duplicated.channel.name"));
        }
        super.save((BaseEntity)entity);
        return true;
    }

    @HussarTransactional
    public boolean updateById(AppPushChannelUpdateDto updateDto) {
        AppPushChannel entity = new AppPushChannel();
        BeanUtils.copyProperties((Object)updateDto, (Object)entity);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AppPushChannel::getChannelName, (Object)entity.getChannelName());
        queryWrapper.lambda().ne(AppPushChannel::getId, (Object)entity.getId());
        long count = ((AppPushChannelMapper)this.baseMapper).selectCount((Wrapper)queryWrapper);
        if (count > 0L) {
            throw new HussarException(entity.getChannelName() + " : " + TranslateUtil.getTranslateName((String)"msg.api.duplicated.channel.name"));
        }
        AppPushChannel appPushChannel = (AppPushChannel)super.getById((Serializable)updateDto.getId());
        if (!HussarUtils.equals((Object)appPushChannel.getStatus(), (Object)updateDto.getStatus()) && this.appSceneConfigService.isExistSceneInBatch(new ArrayList<String>(Collections.singletonList(appPushChannel.getChannelNo())))) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.del.corr.startup.fail"));
        }
        super.updateById((BaseEntity)entity);
        return true;
    }

    @HussarTransactional
    public boolean delete(Long id) {
        String channelNo = ((AppPushChannel)super.getById((Serializable)id)).getChannelNo();
        if (this.appSceneConfigService.isExistScene(channelNo)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.scene.del.corr"));
        }
        super.removeById((Serializable)id);
        return true;
    }

    @HussarTransactional
    public boolean deleteChannelByIds(Long[] ids) {
        List channelNos = super.listByIds(Arrays.asList(ids)).stream().map(AppPushChannel::getChannelNo).collect(Collectors.toList());
        if (this.appSceneConfigService.isExistSceneInBatch(channelNos)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.scene.del.corr"));
        }
        super.removeByIds(Arrays.asList(ids));
        return true;
    }

    public List<AppPushChannelQueryVo> getChannelList() {
        QueryWrapper qw = new QueryWrapper();
        List list = ((AppPushChannelMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
    }

    public Map<String, String> getChannelNoAndName(List<String> channelNos) {
        if (HussarUtils.isEmpty(channelNos)) {
            return new HashMap<String, String>();
        }
        Map<String, String> channelNoAndName = super.list((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{AppPushChannel::getChannelNo, AppPushChannel::getChannelName}).in(AppPushChannel::getChannelNo, channelNos)).stream().collect(Collectors.toMap(AppPushChannel::getChannelNo, AppPushChannel::getChannelName));
        channelNoAndName.put("null", TranslateUtil.getTranslateName((String)"msg.api.channel.empty"));
        return channelNoAndName;
    }

    private AppPushChannelQueryVo entity2QueryVo(AppPushChannel entity) {
        AppPushChannelQueryVo vo = new AppPushChannelQueryVo();
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)vo);
        }
        return vo;
    }
}

