/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.send.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.msg.common.enums.QueueEnum;
import com.jxdinfo.hussar.msg.mq.service.RocketMqElementService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendAsyncService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MsgUnitySendAsyncServiceImpl
implements MsgUnitySendAsyncService {
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private RocketMqElementService rocketMqElementService;

    public boolean sendUnityAsyncMsg(MsgUnitySendDto msgUnitySendDto) {
        List sendTypes = msgUnitySendDto.getSendTypes();
        String message = JSON.toJSONString((Object)msgUnitySendDto);
        for (String sendType : sendTypes) {
            QueueEnum queueEnumByType = QueueEnum.getQueueEnumByType((String)sendType);
            if (HussarUtils.isNotEmpty((Object)queueEnumByType)) {
                this.rocketMQTemplate.convertAndSend((Object)this.rocketMqElementService.getTopic(sendType, msgUnitySendDto.getTenantCode()), (Object)message);
                continue;
            }
            this.rocketMQTemplate.convertAndSend((Object)("msg_" + sendType), (Object)message);
        }
        return true;
    }
}

