/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mp.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.mp.dto.MpSendRecordDto;
import com.jxdinfo.hussar.msg.mp.third.service.MpSendMsgThirdService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.Optional;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="msg_mp", consumerGroup="msg_mp_group")
public class MpRocketMqReceiver
implements RocketMQListener<String> {
    private static final Logger logger = LoggerFactory.getLogger(MpRocketMqReceiver.class);
    @Autowired
    private MpSendMsgThirdService mpSendMsgThirdService;
    @Autowired
    private MsgUnitySendFrameService mpUnitySendServiceImpl;

    public void onMessage(String message) {
        try {
            logger.info("msg_mp message:{}", (Object)message);
            HussarContextHolder.setTenant((String)"1", (String)Optional.ofNullable(JSON.parseObject((String)message).get((Object)"tenantCode")).orElse("").toString());
            if ("MsgUnitySendDto".equals(Optional.ofNullable(JSON.parseObject((String)message).get((Object)"dtoName")).orElse("").toString())) {
                MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)message, MsgUnitySendDto.class);
                this.mpUnitySendServiceImpl.msgUnitySendBefore(msgUnitySendDto);
            } else {
                MpSendRecordDto info = (MpSendRecordDto)JSONObject.parseObject((String)message, MpSendRecordDto.class);
                this.mpSendMsgThirdService.sendMpTimMsg(info);
            }
        }
        catch (Exception e) {
            logger.error("\u516c\u4f17\u53f7\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

