/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.cp.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.cp.dto.CpSendRecordDto;
import com.jxdinfo.hussar.msg.cp.third.service.MsgCpSendThirdService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.Optional;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="msg_cp", consumerGroup="msg_cp_group")
public class CpRocketMqReceiver
implements RocketMQListener<String> {
    private static final Logger logger = LoggerFactory.getLogger(CpRocketMqReceiver.class);
    @Autowired
    private MsgCpSendThirdService cpSendThirdService;
    @Autowired
    private MsgUnitySendFrameService cpUnitySendServiceImpl;

    public void onMessage(String message) {
        try {
            logger.info("msg_cp message:{}", (Object)message);
            HussarContextHolder.setTenant((String)"1", (String)Optional.ofNullable(JSON.parseObject((String)message).get((Object)"tenantCode")).orElse("").toString());
            if ("MsgUnitySendDto".equals(Optional.ofNullable(JSON.parseObject((String)message).get((Object)"dtoName")).orElse("").toString())) {
                MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)message, MsgUnitySendDto.class);
                this.cpUnitySendServiceImpl.msgUnitySendBefore(msgUnitySendDto);
            } else {
                CpSendRecordDto info = (CpSendRecordDto)JSONObject.parseObject((String)message, CpSendRecordDto.class);
                this.cpSendThirdService.sendCpTimMsg(info);
            }
        }
        catch (Exception e) {
            logger.error("\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

