/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.sms.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordDto;
import com.jxdinfo.hussar.msg.sms.third.service.SmsPushService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.Optional;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="msg_sms", consumerGroup="msg_sms_group")
public class SmsRocketMqReceiver
implements RocketMQListener<String> {
    private static final Logger logger = LoggerFactory.getLogger(SmsRocketMqReceiver.class);
    @Autowired
    private SmsPushService smsPushService;
    @Autowired
    private MsgUnitySendFrameService smsUnitySendServiceImpl;

    public void onMessage(String message) {
        try {
            logger.info("msg_sms message:{}", (Object)message);
            HussarContextHolder.setTenant((String)"1", (String)Optional.ofNullable(JSON.parseObject((String)message).get((Object)"tenantCode")).orElse("").toString());
            if ("MsgUnitySendDto".equals(Optional.ofNullable(JSON.parseObject((String)message).get((Object)"dtoName")).orElse("").toString())) {
                MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)message, MsgUnitySendDto.class);
                this.smsUnitySendServiceImpl.msgUnitySendBefore(msgUnitySendDto);
            } else {
                SmsSendRecordDto record = (SmsSendRecordDto)JSONObject.parseObject((String)message, SmsSendRecordDto.class);
                boolean b = this.smsPushService.sendMsg(record);
                logger.info("msg_sms res:{}", (Object)b);
            }
        }
        catch (Exception e) {
            logger.error("\u77ed\u4fe1\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

