/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.mail.dto.MailSendRecordDto;
import com.jxdinfo.hussar.msg.mail.third.service.MailPushThirdService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.Optional;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="msg_mail", consumerGroup="msg_mail_group")
public class MailRocketMqReceiver
implements RocketMQListener<String> {
    private static final Logger logger = LoggerFactory.getLogger(MailRocketMqReceiver.class);
    @Autowired
    private MailPushThirdService mailPushThirdService;
    @Autowired
    private MsgUnitySendFrameService mailUnitySendServiceImpl;

    public void onMessage(String message) {
        try {
            logger.info("msg_mail message:{}", (Object)message);
            HussarContextHolder.setTenant((String)"1", (String)Optional.ofNullable(JSON.parseObject((String)message).get((Object)"tenantCode")).orElse("").toString());
            if ("MsgUnitySendDto".equals(Optional.ofNullable(JSON.parseObject((String)message).get((Object)"dtoName")).orElse("").toString())) {
                MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)message, MsgUnitySendDto.class);
                this.mailUnitySendServiceImpl.msgUnitySendBefore(msgUnitySendDto);
            } else {
                MailSendRecordDto record = (MailSendRecordDto)JSONObject.parseObject((String)message, MailSendRecordDto.class);
                if (record.getBath().booleanValue()) {
                    this.mailPushThirdService.bathSend(record);
                } else {
                    this.mailPushThirdService.send(record);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u90ae\u4ef6\u670d\u52a1\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

