/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.appim.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendRecordDto;
import com.jxdinfo.hussar.msg.appim.third.service.AppImPushThirdService;
import com.jxdinfo.hussar.msg.common.enums.AppImMsgTypeEnum;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.Optional;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="msg_appim", consumerGroup="msg_appim_group")
public class AppImRocketMqReceiver
implements RocketMQListener<String> {
    private static final Logger logger = LoggerFactory.getLogger(AppImRocketMqReceiver.class);
    @Autowired
    private AppImPushThirdService appImPushThirdService;
    @Autowired
    private MsgUnitySendFrameService appImUnitySendServiceImpl;

    public void onMessage(String message) {
        try {
            logger.info("msg app_im message:{}", (Object)message);
            HussarContextHolder.setTenant((String)"1", (String)Optional.ofNullable(JSON.parseObject((String)message).get((Object)"tenantCode")).orElse("").toString());
            if ("MsgUnitySendDto".equals(Optional.ofNullable(JSON.parseObject((String)message).get((Object)"dtoName")).orElse("").toString())) {
                MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)message, MsgUnitySendDto.class);
                this.appImUnitySendServiceImpl.msgUnitySendBefore(msgUnitySendDto);
            } else {
                AppImSendRecordDto record = (AppImSendRecordDto)JSONObject.parseObject((String)message, AppImSendRecordDto.class);
                switch (AppImMsgTypeEnum.getByCode((Integer)record.getType())) {
                    case TEXT: {
                        this.appImPushThirdService.sendTextTimMsg(record);
                        break;
                    }
                    case ARTICLE: {
                        this.appImPushThirdService.sendArticleTimMsg(record);
                        break;
                    }
                    case IMG: {
                        this.appImPushThirdService.sendImgTimMsg(record);
                        break;
                    }
                    case FILE: {
                        this.appImPushThirdService.sendFileTimMsg(record);
                        break;
                    }
                    default: {
                        logger.error("\u9519\u8bef\u7684app_im\u6d88\u606f\u7c7b\u578b");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("app_im\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

