/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.notice.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.notice.model.Notice;
import com.jxdinfo.hussar.msg.notice.third.service.NoticeSendThirdService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.Optional;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="msg_notice", consumerGroup="msg_notice_group")
public class NoticeRocketMqReceiver
implements RocketMQListener<String> {
    private static final Logger logger = LoggerFactory.getLogger(NoticeRocketMqReceiver.class);
    @Autowired
    private NoticeSendThirdService noticeSendThirdService;
    @Autowired
    private MsgUnitySendFrameService noticeUnitySendServiceImpl;

    public void onMessage(String message) {
        try {
            logger.info("msg_notice message:{}", (Object)message);
            HussarContextHolder.setTenant((String)"1", (String)Optional.ofNullable(JSON.parseObject((String)message).get((Object)"tenantCode")).orElse("").toString());
            if ("MsgUnitySendDto".equals(Optional.ofNullable(JSON.parseObject((String)message).get((Object)"dtoName")).orElse("").toString())) {
                MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)message, MsgUnitySendDto.class);
                this.noticeUnitySendServiceImpl.msgUnitySendBefore(msgUnitySendDto);
            } else {
                Notice notice = (Notice)JSONObject.parseObject((String)message, Notice.class);
                this.noticeSendThirdService.sendMsgTimNotice(notice);
            }
        }
        catch (Exception e) {
            logger.error("notice\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

