/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.dingtalk.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkSendRecordDto;
import com.jxdinfo.hussar.msg.dingtalk.third.service.DingTalkThirdService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.Optional;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="msg_dingtalk", consumerGroup="msg_dingtalk_group")
public class DingTalkRocketMqReceiver
implements RocketMQListener<String> {
    private static final Logger logger = LoggerFactory.getLogger(DingTalkRocketMqReceiver.class);
    @Autowired
    private DingTalkThirdService dingTalkThirdService;
    @Autowired
    private MsgUnitySendFrameService dingTalkUnitySendServiceImpl;

    public void onMessage(String message) {
        try {
            logger.info("msg_dingtalk message:{}", (Object)message);
            HussarContextHolder.setTenant((String)"1", (String)Optional.ofNullable(JSON.parseObject((String)message).get((Object)"tenantCode")).orElse("").toString());
            if ("MsgUnitySendDto".equals(Optional.ofNullable(JSON.parseObject((String)message).get((Object)"dtoName")).orElse("").toString())) {
                MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)message, MsgUnitySendDto.class);
                this.dingTalkUnitySendServiceImpl.msgUnitySendBefore(msgUnitySendDto);
            } else {
                DingTalkSendRecordDto info = (DingTalkSendRecordDto)JSONObject.parseObject((String)message, DingTalkSendRecordDto.class);
                this.dingTalkThirdService.sendDingTalkTimMsg(info);
            }
        }
        catch (Exception e) {
            logger.error("\u9489\u9489\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

