/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.apppush.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordDto;
import com.jxdinfo.hussar.msg.apppush.third.service.AppPushThirdService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.Optional;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="msg_app", consumerGroup="msg_app_group")
public class AppRocketMqReceiver
implements RocketMQListener<String> {
    private static final Logger logger = LoggerFactory.getLogger(AppRocketMqReceiver.class);
    @Autowired
    private AppPushThirdService appPushThirdService;
    @Autowired
    private MsgUnitySendFrameService appPushUnitySendServiceImpl;

    public void onMessage(String message) {
        try {
            logger.info("msg app_push message:{}", (Object)message);
            HussarContextHolder.setTenant((String)"1", (String)Optional.ofNullable(JSON.parseObject((String)message).get((Object)"tenantCode")).orElse("").toString());
            if ("MsgUnitySendDto".equals(Optional.ofNullable(JSON.parseObject((String)message).get((Object)"dtoName")).orElse("").toString())) {
                MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)message, MsgUnitySendDto.class);
                this.appPushUnitySendServiceImpl.msgUnitySendBefore(msgUnitySendDto);
            } else {
                AppPushSendRecordDto appPushSendRecord = (AppPushSendRecordDto)JSONObject.parseObject((String)message, AppPushSendRecordDto.class);
                boolean b = this.appPushThirdService.sendPushTimMsg(appPushSendRecord);
                logger.info("msg_apppush res:{}", (Object)b);
            }
        }
        catch (Exception e) {
            logger.error("app\u63a8\u9001\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

