/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.async.redis.factory;

import com.jxdinfo.hussar.msg.async.redis.condition.RedisCondition;
import com.jxdinfo.hussar.support.mq.HussarMQManager;
import com.jxdinfo.hussar.support.mq.producer.HussarMQProducer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={RedisCondition.class})
public class ProducerManager {
    private final Map<String, HussarMQProducer<String>> producers = new ConcurrentHashMap<String, HussarMQProducer<String>>();
    private final Map<String, String> topicMapping;
    private final HussarMQManager hussarMQManager;

    @Autowired
    public ProducerManager(HussarMQManager hussarMQManager, Map<String, String> topicMapping) {
        this.hussarMQManager = hussarMQManager;
        this.topicMapping = topicMapping;
    }

    public HussarMQProducer<String> getProducer(String type) {
        return this.producers.computeIfAbsent(type, k -> this.hussarMQManager.newProducer(this.topicMapping.get(k)).build());
    }
}

