/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mp.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.common.enums.QueueEnum;
import com.jxdinfo.hussar.msg.condition.RabbitCondition;
import com.jxdinfo.hussar.msg.mp.dto.MpSendRecordDto;
import com.jxdinfo.hussar.msg.mp.service.MsgMpSendAsyncService;
import com.jxdinfo.hussar.msg.mq.service.RabbitMqElementService;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={RabbitCondition.class})
public class MsgMpSendAsyncServiceImpl
implements MsgMpSendAsyncService {
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private RabbitMqElementService rabbitMqElementService;

    public boolean sendMpAsyncMsg(MpSendRecordDto mpSendRecordDto) {
        String s = JSONObject.toJSONString((Object)mpSendRecordDto);
        Message message = new Message(s.getBytes(), new MessageProperties());
        this.rabbitTemplate.convertAndSend(this.rabbitMqElementService.getExchangeName(QueueEnum.QUEUE_MSG_MP.getType(), mpSendRecordDto.getTenantCode()), this.rabbitMqElementService.getRoutingKeyName(QueueEnum.QUEUE_MSG_MP.getType(), mpSendRecordDto.getTenantCode()), (Object)message);
        return true;
    }
}

