/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.send.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.msg.condition.RabbitCondition;
import com.jxdinfo.hussar.msg.mq.service.RabbitMqElementService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendAsyncService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={RabbitCondition.class})
public class MsgUnitySendAsyncServiceImpl
implements MsgUnitySendAsyncService {
    private static final Logger log = LoggerFactory.getLogger(MsgUnitySendAsyncServiceImpl.class);
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private RabbitMqElementService rabbitMqElementService;

    public boolean sendUnityAsyncMsg(MsgUnitySendDto msgUnitySendDto) {
        List sendTypes = msgUnitySendDto.getSendTypes();
        String s = JSON.toJSONString((Object)msgUnitySendDto);
        Message message = new Message(s.getBytes(), new MessageProperties());
        String language = TranslateUtil.getDefaultLang();
        Map headers = message.getMessageProperties().getHeaders();
        headers.put("language", language);
        UserDetails loginUserDetails = HussarSecurityUtils.getLoginUserDetails();
        if (HussarUtils.isNotEmpty((Object)loginUserDetails)) {
            headers.put("login_id", loginUserDetails.getUserId());
        }
        for (String sendType : sendTypes) {
            headers.put("send_type", sendType);
            String exchangeName = this.rabbitMqElementService.getExchangeName(sendType, msgUnitySendDto.getTenantCode());
            String routingKeyName = this.rabbitMqElementService.getRoutingKeyName(sendType, msgUnitySendDto.getTenantCode());
            this.rabbitTemplate.convertAndSend(exchangeName, routingKeyName, (Object)message);
            log.info("\u6d88\u606f\u4e2d\u5fc3: {} \u6d88\u606f\u63a8\u9001rabbitMQ\u6210\u529f, exchange: {}, routingKey: {}", new Object[]{sendType, exchangeName, routingKeyName});
        }
        return true;
    }
}

