/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.push.contact.service.impl;

import com.jxdinfo.hussar.msg.contact.dto.MsgGetExtendReceiverResult;
import com.jxdinfo.hussar.msg.contact.service.MsgReceiverIdExtendProvider;
import com.jxdinfo.hussar.msg.push.contact.service.MsgRemoteGetReceiverService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MsgRemoteGetReceiverServiceImpl
implements MsgRemoteGetReceiverService {
    @Autowired(required=false)
    private List<MsgReceiverIdExtendProvider> providers;
    private final Map<String, MsgReceiverIdExtendProvider> map = new HashMap<String, MsgReceiverIdExtendProvider>();

    @PostConstruct
    public void init() {
        if (HussarUtils.isNotEmpty(this.providers)) {
            for (MsgReceiverIdExtendProvider msgReceiverIdExtendProvider : this.providers) {
                if (!HussarUtils.isNotEmpty((Object)msgReceiverIdExtendProvider.getSendTypes())) continue;
                msgReceiverIdExtendProvider.getSendTypes().forEach(sendType -> this.map.put((String)sendType, msgReceiverIdExtendProvider));
            }
        }
    }

    private MsgReceiverIdExtendProvider getMsgGetReceiverListener(String sendType) {
        MsgReceiverIdExtendProvider msgReceiverIdExtendProvider = this.map.get(sendType);
        if (msgReceiverIdExtendProvider != null && msgReceiverIdExtendProvider.support()) {
            return msgReceiverIdExtendProvider;
        }
        return null;
    }

    @Override
    public MsgGetExtendReceiverResult getReceiverAddress(MsgUnitySendDto msgUnitySendDto) {
        MsgGetExtendReceiverResult result = new MsgGetExtendReceiverResult();
        String sendType = (String)msgUnitySendDto.getSendTypes().get(0);
        MsgReceiverIdExtendProvider provider = this.getMsgGetReceiverListener(sendType);
        if (HussarUtils.isNotEmpty((Object)provider)) {
            result.setExitProvider(true);
            List receiverAddress = provider.getReceiverAddress(msgUnitySendDto);
            result.setReceiverAddress(receiverAddress);
        }
        return result;
    }
}

