/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.deploy.mq.service.impl;

import com.jxdinfo.hussar.msg.common.enums.TenantQueueEnum;
import com.jxdinfo.hussar.msg.deploy.mq.listener.DynamicMessageListener;
import com.jxdinfo.hussar.msg.deploy.mq.service.TenantRabbitMqService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantRabbitMqServiceImpl
implements TenantRabbitMqService {
    @Autowired
    private RabbitAdmin rabbitAdmin;
    @Autowired
    private SimpleMessageListenerContainer container;
    @Autowired
    private DynamicMessageListener messageListener;

    public void createTenantBindingAndListener(String tenantCode) {
        DirectExchange directExchange = this.tenantExchange(tenantCode);
        List<Queue> queues = this.tenantQueue(tenantCode);
        this.rabbitAdmin.declareExchange((Exchange)directExchange);
        for (Queue queue : queues) {
            this.rabbitAdmin.declareQueue(queue);
        }
        List<Binding> bindings = this.bindingExchangeQueue(tenantCode, directExchange, queues);
        for (Binding binding : bindings) {
            this.rabbitAdmin.declareBinding(binding);
        }
        this.createListener(queues);
    }

    public void initConsumerListener(String[] queueNames) {
        this.container.addQueueNames(queueNames);
        this.container.setMessageListener((MessageListener)this.messageListener);
        this.container.start();
    }

    public DirectExchange tenantExchange(String tenantCode) {
        return (DirectExchange)ExchangeBuilder.directExchange((String)(tenantCode + ".tenant.direct")).durable(true).build();
    }

    public List<Queue> tenantQueue(String tenantCode) {
        ArrayList<Queue> queues = new ArrayList<Queue>();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x-queue-type", "classic");
        for (TenantQueueEnum tenantQueueEnum : TenantQueueEnum.values()) {
            Queue queue = new Queue(tenantCode + tenantQueueEnum.getQueueName(), true, false, false, args);
            queues.add(queue);
        }
        return queues;
    }

    public List<Binding> bindingExchangeQueue(String tenantCode, DirectExchange directExchange, List<Queue> queues) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (Queue queue : queues) {
            String routeKey = TenantQueueEnum.getRouteKeyByQueueName((String)tenantCode, (String)queue.getName());
            Binding binding = BindingBuilder.bind((Queue)queue).to(directExchange).with(tenantCode + routeKey);
            bindings.add(binding);
        }
        return bindings;
    }

    public void createListener(List<Queue> queues) {
        String[] queueNames = queues.stream().map(Queue::getName).collect(Collectors.toList()).toArray(new String[queues.size()]);
        this.container.addQueueNames(queueNames);
        this.container.setMessageListener((MessageListener)this.messageListener);
        this.container.start();
    }
}

