/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.deploy.mq.listener;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendRecordDto;
import com.jxdinfo.hussar.msg.appim.third.service.AppImPushService;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordDto;
import com.jxdinfo.hussar.msg.apppush.service.AppPushSendRecordService;
import com.jxdinfo.hussar.msg.common.enums.AppImMsgTypeEnum;
import com.jxdinfo.hussar.msg.common.enums.TenantQueueEnum;
import com.jxdinfo.hussar.msg.cp.dto.CpSendRecordDto;
import com.jxdinfo.hussar.msg.cp.service.CpRabbitMqSendService;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkSendRecordDto;
import com.jxdinfo.hussar.msg.dingtalk.service.DingTalkRabbitMqSendService;
import com.jxdinfo.hussar.msg.mail.dto.MailSendRecordDto;
import com.jxdinfo.hussar.msg.mail.third.service.MailPushService;
import com.jxdinfo.hussar.msg.mp.dto.MpSendRecordDto;
import com.jxdinfo.hussar.msg.mp.service.MpSendRecordService;
import com.jxdinfo.hussar.msg.notice.model.Notice;
import com.jxdinfo.hussar.msg.notice.service.NoticeSendRecordService;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordDto;
import com.jxdinfo.hussar.msg.sms.third.service.SmsPushService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DynamicMessageListener
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(DynamicMessageListener.class);
    @Autowired
    private SmsPushService smsPushService;
    @Autowired
    private MailPushService mailPushService;
    @Autowired
    private MpSendRecordService mpSendRecordService;
    @Autowired
    private NoticeSendRecordService noticeSendRecordService;
    @Autowired
    private CpRabbitMqSendService cpRabbitMqSendService;
    @Autowired
    private DingTalkRabbitMqSendService dingTalkRabbitMqSendService;
    @Autowired
    private AppPushSendRecordService msgAppInfoService;
    @Autowired
    private AppImPushService appImPushService;

    public void onMessage(Message message) {
        String queue = message.getMessageProperties().getConsumerQueue();
        String[] separateQueue = queue.split("\\.");
        String msgType = separateQueue[separateQueue.length - 1];
        if (HussarUtils.equals((Object)TenantQueueEnum.QUEUE_MSG_SMS.getType(), (Object)msgType)) {
            this.sendSms(message);
        } else if (HussarUtils.equals((Object)TenantQueueEnum.QUEUE_MSG_MAIL.getType(), (Object)msgType)) {
            this.sendMail(message);
        } else if (HussarUtils.equals((Object)TenantQueueEnum.QUEUE_MSG_MP.getType(), (Object)msgType)) {
            this.sendMp(message);
        } else if (HussarUtils.equals((Object)TenantQueueEnum.QUEUE_MSG_CP.getType(), (Object)msgType)) {
            this.sendCp(message);
        } else if (HussarUtils.equals((Object)TenantQueueEnum.QUEUE_MSG_APPPUSH.getType(), (Object)msgType)) {
            this.sendAppPush(message);
        } else if (HussarUtils.equals((Object)TenantQueueEnum.QUEUE_MSG_APPIM.getType(), (Object)msgType)) {
            this.sendAppIm(message);
        } else if (HussarUtils.equals((Object)TenantQueueEnum.QUEUE_MSG_NOTICE.getType(), (Object)msgType)) {
            this.sendNotice(message);
        } else if (HussarUtils.equals((Object)TenantQueueEnum.QUEUE_MSG_DINGTALK.getType(), (Object)msgType)) {
            this.sendDingTalk(message);
        }
    }

    public void sendSms(Message message) {
        try {
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            String queue = message.getMessageProperties().getConsumerQueue();
            logger.info("queue:" + queue);
            logger.info("msg sms json:{}", (Object)json);
            SmsSendRecordDto record = (SmsSendRecordDto)JSONObject.parseObject((String)json, SmsSendRecordDto.class);
            boolean b = this.smsPushService.sendMsg(record);
            logger.info("msg sms res:{}", (Object)b);
        }
        catch (Exception e) {
            logger.error("\u77ed\u4fe1\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }

    public void sendMail(Message message) {
        try {
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            String queue = message.getMessageProperties().getConsumerQueue();
            logger.info("queue:" + queue);
            logger.info("msg_Mail json:{}", (Object)json);
            MailSendRecordDto record = (MailSendRecordDto)JSONObject.parseObject((String)json, MailSendRecordDto.class);
            if (record.getBath().booleanValue()) {
                this.mailPushService.bathSend(record);
            } else {
                this.mailPushService.send(record);
            }
        }
        catch (Exception e) {
            logger.error("\u90ae\u4ef6\u670d\u52a1\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }

    public void sendMp(Message message) {
        try {
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            String queue = message.getMessageProperties().getConsumerQueue();
            logger.info("queue:" + queue);
            logger.info("msg mp json:{}", (Object)json);
            MpSendRecordDto info = (MpSendRecordDto)JSONObject.parseObject((String)json, MpSendRecordDto.class);
            boolean bl = this.mpSendRecordService.sendMpMsg(info);
        }
        catch (Exception e) {
            logger.error("\u516c\u4f17\u53f7\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }

    public void sendCp(Message message) {
        try {
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            String queue = message.getMessageProperties().getConsumerQueue();
            logger.info("queue:" + queue);
            logger.info("msg cp json:{}", (Object)json);
            CpSendRecordDto info = (CpSendRecordDto)JSONObject.parseObject((String)json, CpSendRecordDto.class);
            boolean bl = this.cpRabbitMqSendService.sendCpMsg(info);
        }
        catch (Exception e) {
            logger.error("\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }

    public void sendAppPush(Message message) {
        try {
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            logger.info("msg apppush json:{}", (Object)json);
            AppPushSendRecordDto appPushSendRecord = (AppPushSendRecordDto)JSONObject.parseObject((String)json, AppPushSendRecordDto.class);
            boolean b = this.msgAppInfoService.sendPushMsg(appPushSendRecord);
            logger.info("msg apppush res:{}", (Object)b);
        }
        catch (Exception e) {
            logger.error("app\u63a8\u9001\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }

    public void sendAppIm(Message message) {
        try {
            logger.info(String.valueOf(message));
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            String queue = message.getMessageProperties().getConsumerQueue();
            logger.info("queue:" + queue);
            logger.info("msg app im json:{}", (Object)json);
            AppImSendRecordDto record = (AppImSendRecordDto)JSONObject.parseObject((String)json, AppImSendRecordDto.class);
            switch (AppImMsgTypeEnum.getByCode((Integer)record.getType())) {
                case TEXT: {
                    this.appImPushService.sendTextMsg(record);
                    break;
                }
                case ARTICLE: {
                    this.appImPushService.sendArticleMsg(record);
                    break;
                }
                case IMG: {
                    this.appImPushService.sendImgMsg(record);
                    break;
                }
                case FILE: {
                    this.appImPushService.sendFileMsg(record);
                    break;
                }
                default: {
                    logger.error("\u9519\u8bef\u7684app_im\u6d88\u606f\u7c7b\u578b");
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("app_im\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }

    public void sendNotice(Message message) {
        try {
            logger.info(String.valueOf(message));
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            String queue = message.getMessageProperties().getConsumerQueue();
            logger.info("queue:" + queue);
            logger.info("msg notice json:{}", (Object)json);
            Notice notice = (Notice)JSONObject.parseObject((String)json, Notice.class);
            this.noticeSendRecordService.sendMsgNotice(notice);
        }
        catch (Exception e) {
            logger.error("notice\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }

    public void sendDingTalk(Message message) {
        try {
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            String queue = message.getMessageProperties().getConsumerQueue();
            logger.info("queue:" + queue);
            logger.info("msg dingtalk json:{}", (Object)json);
            DingTalkSendRecordDto info = (DingTalkSendRecordDto)JSONObject.parseObject((String)json, DingTalkSendRecordDto.class);
            boolean bl = this.dingTalkRabbitMqSendService.sendDingTalkMsg(info);
        }
        catch (Exception e) {
            logger.error("\u9489\u9489\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

