/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.deploy.interceptor.impl;

import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.deploy.client.model.MsgClientApp;
import com.jxdinfo.hussar.msg.deploy.client.service.MsgClientAppService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class MsgInterceptor
implements HandlerInterceptor {
    @Autowired
    private MsgClientAppService msgClientAppService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private ISysTenantService sysTenantService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        SysTenant tenant = (SysTenant)this.sysTenantService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantCode, (Object)request.getHeader("Tcode")));
        if (HussarUtils.isEmpty((Object)tenant)) {
            throw new HussarException("\u65e0\u6b64\u79df\u6237\uff01");
        }
        DynamicDataSourceContextHolder.push((String)tenant.getConnName());
        try {
            Long appAccessId = this.getAppAccessIdByAppId(request.getHeader("appId"));
            boolean relation = this.judgmentClientAppRelation(request.getHeader("Client-Id"), appAccessId);
            if (relation) {
                boolean bl = true;
                return bl;
            }
            throw new HussarException("\u5ba2\u6237\u7aef\u672a\u5173\u8054\u6b64\u5e94\u7528\uff01");
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }

    private boolean judgmentClientAppRelation(String clientId, Long appAccessId) {
        MsgClientApp msgClientApp = (MsgClientApp)this.msgClientAppService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MsgClientApp::getClientId, (Object)clientId)).eq(MsgClientApp::getAppAccessId, (Object)appAccessId));
        return HussarUtils.isNotEmpty((Object)msgClientApp);
    }

    private Long getAppAccessIdByAppId(String appId) {
        AppAccess appAccess = (AppAccess)this.appAccessService.getOne((Wrapper)new LambdaQueryWrapper().eq(AppAccess::getAppId, (Object)appId));
        if (HussarUtils.isNotEmpty((Object)appAccess)) {
            return appAccess.getId();
        }
        throw new HussarException("\u8be5\u5e94\u7528\u4e0d\u5b58\u5728\uff01");
    }
}

