/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.deploy.client.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authentication.service.SysAuthClientModelService;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.client.model.SysClientModel;
import com.jxdinfo.hussar.iam.client.model.SysClientPermission;
import com.jxdinfo.hussar.iam.client.service.ISysClientModelService;
import com.jxdinfo.hussar.iam.client.service.ISysClientPermissionService;
import com.jxdinfo.hussar.msg.app.dto.AppAccessQueryVo;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.common.enums.MsgOpenInterfaceEnum;
import com.jxdinfo.hussar.msg.deploy.client.dao.MsgClientAppMapper;
import com.jxdinfo.hussar.msg.deploy.client.dto.MsgClientAppDto;
import com.jxdinfo.hussar.msg.deploy.client.model.MsgClientApp;
import com.jxdinfo.hussar.msg.deploy.client.service.MsgClientAppService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MsgClientAppServiceImpl
extends HussarServiceImpl<MsgClientAppMapper, MsgClientApp>
implements MsgClientAppService {
    @Autowired
    private ISysClientPermissionService sysClientPermissionService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private ISysResourcesService sysResourcesService;
    @Autowired
    private ISysClientModelService sysClientModelService;
    @Autowired
    private SysAuthClientModelService sysAuthClientModelService;

    @HussarTokenDs
    @HussarTransactional
    public boolean save(MsgClientAppDto msgClientAppDto) {
        if (HussarUtils.isEmpty((Object)msgClientAppDto.getClientId())) {
            throw new HussarException("\u5ba2\u6237\u7aefid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.remove((Wrapper)new LambdaQueryWrapper().eq(MsgClientApp::getClientId, (Object)msgClientAppDto.getClientId()));
        this.sysClientPermissionService.remove((Wrapper)new LambdaQueryWrapper().eq(SysClientPermission::getClientId, (Object)msgClientAppDto.getClientId()));
        ArrayList<MsgClientApp> msgClientApps = new ArrayList<MsgClientApp>();
        List appAccessIds = msgClientAppDto.getAppAccessId();
        ArrayList<SysClientPermission> sysClientPermissions = new ArrayList<SysClientPermission>();
        if (HussarUtils.isNotEmpty((Object)appAccessIds)) {
            for (Long appAccessId : appAccessIds) {
                MsgClientApp msgClientApp = new MsgClientApp();
                msgClientApp.setClientId(msgClientAppDto.getClientId());
                msgClientApp.setAppAccessId(appAccessId);
                msgClientApps.add(msgClientApp);
            }
            List serviceTypeLists = this.appAccessService.bathFindById(appAccessIds).stream().map(AppAccessQueryVo::getServiceType).distinct().collect(Collectors.toList());
            HashSet<String> serviceTypes = new HashSet<String>();
            for (String serviceTypeList : serviceTypeLists) {
                String[] serviceTypeStrs = serviceTypeList.split("[,\uff0c]");
                serviceTypes.addAll(Arrays.asList(serviceTypeStrs));
            }
            UserDetails loginUserDetails = HussarSecurityUtils.getLoginUserDetails();
            Long tenantId = loginUserDetails.getTenantId();
            ArrayList<String> paths = new ArrayList<String>();
            for (String serviceType : serviceTypes) {
                if (HussarUtils.equals((Object)serviceType, (Object)"mail")) {
                    paths.add(MsgOpenInterfaceEnum.MAIL_SINGLE.getValue());
                    paths.add(MsgOpenInterfaceEnum.MAIL_BATH.getValue());
                    continue;
                }
                if (HussarUtils.equals((Object)serviceType, (Object)"app_im")) {
                    paths.add(MsgOpenInterfaceEnum.APP_IM_TEXT.getValue());
                    paths.add(MsgOpenInterfaceEnum.APP_IM_ARTICLE.getValue());
                    paths.add(MsgOpenInterfaceEnum.APP_IM_IMG.getValue());
                    paths.add(MsgOpenInterfaceEnum.APP_IM_FILE.getValue());
                    continue;
                }
                paths.add(MsgOpenInterfaceEnum.getValueByKey((String)serviceType));
            }
            List resourceIds = this.sysResourcesService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getResTypeId, (Object)"res_open_interface")).in(SysResources::getUrlNames, paths)).stream().map(SysResources::getId).collect(Collectors.toList());
            for (Long resourceId : resourceIds) {
                SysClientPermission sysClientPermission = new SysClientPermission();
                sysClientPermission.setClientId(msgClientAppDto.getClientId());
                sysClientPermission.setPermissionId(resourceId);
                sysClientPermission.setScope("permission_list");
                sysClientPermission.setTenantId(tenantId);
                sysClientPermissions.add(sysClientPermission);
            }
        }
        this.saveBatch(msgClientApps);
        this.sysClientPermissionService.saveBatch(sysClientPermissions);
        this.updateClientPermission(sysClientPermissions, msgClientAppDto.getClientId());
        return true;
    }

    @HussarTokenDs
    public boolean judgmentClientAppRelation(String clientId, Long appAccessId) {
        MsgClientApp msgClientApp = (MsgClientApp)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MsgClientApp::getClientId, (Object)clientId)).eq(MsgClientApp::getAppAccessId, (Object)appAccessId));
        return HussarUtils.isNotEmpty((Object)msgClientApp);
    }

    @HussarTokenDs
    public List<AppAccessQueryVo> queryRelatedApp(String clientId) {
        List appIds = this.list((Wrapper)new LambdaQueryWrapper().eq(MsgClientApp::getClientId, (Object)clientId)).stream().map(MsgClientApp::getAppAccessId).collect(Collectors.toList());
        return this.appAccessService.bathFindById(appIds);
    }

    @HussarTransactional
    public boolean deleteClient(String clientId) {
        LambdaQueryWrapper sysClientModelLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysClientModel::getClientId, (Object)clientId);
        SysClientModel sysClientModel = (SysClientModel)this.sysClientModelService.getOne((Wrapper)sysClientModelLambdaQueryWrapper);
        if (this.sysClientModelService.remove((Wrapper)sysClientModelLambdaQueryWrapper)) {
            this.sysClientPermissionService.remove((Wrapper)new LambdaQueryWrapper().eq(SysClientPermission::getClientId, (Object)clientId));
            SysAuthClientModel authClientModel = (SysAuthClientModel)this.sysAuthClientModelService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAuthClientModel::getClientId, (Object)clientId));
            if (ToolUtil.isNotEmpty((Object)authClientModel)) {
                this.sysAuthClientModelService.deleteAuthClientModel(authClientModel.getId(), sysClientModel.getApplicationId());
            }
            this.remove((Wrapper)new LambdaQueryWrapper().eq(MsgClientApp::getClientId, (Object)clientId));
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            String tenantCode = ToolUtil.isNotEmpty((Object)securityUser) && ToolUtil.isNotEmpty((Object)securityUser.getTenantCode()) ? securityUser.getTenantCode() : "";
            HussarSecurityUtils.revokeClientToken((String)clientId, (String)tenantCode);
            HussarFixedCacheUtil.evict((String)"iam_sdk", (Object)"clientId_appId_map");
            return true;
        }
        throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
    }

    protected void updateClientPermission(List<SysClientPermission> clientPermissionList, String clientId) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        String tenantCode = HussarUtils.isNotEmpty((Object)securityUser) && HussarUtils.isNotEmpty((Object)securityUser.getTenantCode()) ? securityUser.getTenantCode() : "";
        HashMap permissionMap = new HashMap();
        Map<Long, String> resourceIdUrlMap = this.getResourceIdUrlMap(clientPermissionList);
        permissionMap.put(clientId, new ArrayList());
        List permissionList = (List)permissionMap.get(clientId);
        for (SysClientPermission clientPermission : clientPermissionList) {
            String permission = resourceIdUrlMap.get(clientPermission.getPermissionId());
            if (!HussarUtils.isNotEmpty((Object)permission)) continue;
            permissionList.add(permission);
        }
        HussarSecurityUtils.updateClientPermissions((String)clientId, (String)tenantCode, (List)((List)permissionMap.get(clientId)));
    }

    private Map<Long, String> getResourceIdUrlMap(List<SysClientPermission> clientPermissionList) {
        List permissionIdList = clientPermissionList.stream().map(SysClientPermission::getPermissionId).distinct().collect(Collectors.toList());
        HashMap<Long, String> resourceIdUrlMap = new HashMap<Long, String>();
        if (ToolUtil.isNotEmpty(permissionIdList)) {
            List resourcesList = this.sysResourcesService.listByIds(permissionIdList);
            for (SysResources resource : resourcesList) {
                if (!ToolUtil.isNotEmpty((Object)resource.getUrlNames())) continue;
                resourceIdUrlMap.put(resource.getId(), resource.getUrlNames());
            }
        }
        return resourceIdUrlMap;
    }
}

