/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.send.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.model.AppSceneConfig;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.contact.service.MsgContactInfoService;
import com.jxdinfo.hussar.msg.send.dto.MsgDoSendInfo;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.model.MsgSendRecord;
import com.jxdinfo.hussar.msg.send.service.MsgSendExecutor;
import com.jxdinfo.hussar.msg.send.service.MsgSendRecordService;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMsgSendExecutor
implements MsgSendExecutor {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected List<String> errorContactInfos;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private MsgContactInfoService msgContactInfoService;
    @Autowired
    private MsgSendRecordService msgSendRecordService;

    @Override
    public void sendMessage(MsgUnitySendDto msgUnitySendDto) {
        block2: {
            MsgSendRecord sendRecord = null;
            this.errorContactInfos = new ArrayList<String>();
            MsgDoSendInfo doSendInfo = new MsgDoSendInfo(msgUnitySendDto);
            try {
                sendRecord = this.constructSendRecord(doSendInfo);
                this.doSend(sendRecord, doSendInfo);
                this.saveRecord(sendRecord);
            }
            catch (Exception e) {
                this.logger.error("{} \u6d88\u606f\u53d1\u9001\u5931\u8d25", (Object)this.getSendType(), (Object)e);
                if (sendRecord == null) break block2;
                sendRecord.setStatus(SendStatusEnum.FAIL.getCode());
                sendRecord.setErrorMsg(e.getMessage());
                this.saveRecord(sendRecord);
            }
        }
    }

    public abstract void doSend(MsgSendRecord var1, MsgDoSendInfo var2);

    public MsgSendRecord constructSendRecord(MsgDoSendInfo doSendInfo) {
        List<String> receiveAddress;
        MsgUnitySendDto msgUnitySendDto = doSendInfo.getMsgUnitySendDto();
        MsgSendRecord msgSendRecord = new MsgSendRecord();
        String sendType = this.getSendType();
        msgSendRecord.setSendType(sendType);
        msgSendRecord.setBusinessId(msgUnitySendDto.getBusinessId());
        Object objectLoginId = msgUnitySendDto.getExtendParams("__loginId");
        Long loginId = HussarUtils.isNotEmpty((Object)objectLoginId) ? Long.valueOf(String.valueOf(objectLoginId)) : null;
        LocalDateTime now = LocalDateTime.now();
        msgSendRecord.setCreateTime(now);
        msgSendRecord.setCreateDate(DateUtil.format((TemporalAccessor)now, (String)"yyyy-MM-dd"));
        msgSendRecord.setCreator(loginId);
        AppSceneConfig appSceneConfig = (AppSceneConfig)((Object)this.appSceneConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(AppSceneConfig::getSceneCode, (Object)msgUnitySendDto.getSceneCode())));
        String sceneCode = appSceneConfig.getSceneCode();
        Long appAccessId = appSceneConfig.getAppPkId();
        msgSendRecord.setSceneName(appSceneConfig.getSceneName());
        msgSendRecord.setSceneCode(sceneCode);
        AppAccess appAccess = (AppAccess)((Object)this.appAccessService.getById(appAccessId));
        msgSendRecord.setAppId(appAccess.getAppId());
        msgSendRecord.setAppName(appAccess.getAppName());
        String sceneConfigJson = this.appSceneConfigService.getConfigJson(sceneCode, sendType);
        if (HussarUtils.isNotEmpty((Object)sceneConfigJson)) {
            Map sceneConfig = (Map)JSON.parseObject((String)sceneConfigJson, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            doSendInfo.setSceneConfig(sceneConfig);
            msgSendRecord.setTemplateNo((String)sceneConfig.get("templateNo"));
            doSendInfo.setTemplateParams(msgUnitySendDto.getTemplateParams());
            msgSendRecord.setChannelNo((String)sceneConfig.get("channelNo"));
        }
        if (HussarUtils.isEmpty(receiveAddress = this.msgContactInfoService.getReceiveAddress(msgUnitySendDto, sendType, appSceneConfig, this.errorContactInfos))) {
            throw new RuntimeException("\u65e0\u53ef\u7528\u8054\u7cfb\u5730\u5740\uff01" + (HussarUtils.isNotEmpty(this.errorContactInfos) ? "\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", this.errorContactInfos) : ""));
        }
        doSendInfo.setReceiver(Strings.join(receiveAddress, (char)','));
        msgSendRecord.setReceiver(Strings.join(receiveAddress, (char)','));
        Object extendParams = msgUnitySendDto.getExtendParams(sendType);
        if (extendParams instanceof Map) {
            doSendInfo.setExtendParams((Map<String, Object>)JSON.parseObject((String)JSON.toJSONString((Object)extendParams)));
        }
        return msgSendRecord;
    }

    private void saveRecord(MsgSendRecord sendRecord) {
        try {
            if (HussarUtils.isEmpty((Object)sendRecord.getStatus())) {
                if (HussarUtils.isNotEmpty((Object)sendRecord.getErrorMsg())) {
                    sendRecord.setStatus(SendStatusEnum.FAIL.getCode());
                } else {
                    sendRecord.setStatus(SendStatusEnum.SUCCESS.getCode());
                }
            }
            if (SendStatusEnum.SUCCESS.getCode().equals(sendRecord.getStatus()) && HussarUtils.isNotEmpty(this.errorContactInfos)) {
                sendRecord.setErrorMsg("\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", this.errorContactInfos));
            }
            this.msgSendRecordService.saveRecord(sendRecord);
        }
        catch (Exception ex) {
            this.logger.error("{} \u6d88\u606f\u4fdd\u5b58\u53d1\u9001\u8bb0\u5f55\u5931\u8d25", (Object)this.getSendType(), (Object)ex);
        }
    }
}

