/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.common.utils;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateUtils {
    public static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\#\\{(.*?)\\}");

    private TemplateUtils() {
    }

    public static String getTemplateParams(String model) {
        if (HussarUtils.isEmpty((Object)model)) {
            return null;
        }
        LinkedHashSet<String> set = TemplateUtils.getTemplateParmas(model);
        return String.join((CharSequence)",", set);
    }

    public static LinkedHashSet<String> getTemplateParmas(String model) {
        if (HussarUtils.isEmpty((Object)model)) {
            return new LinkedHashSet<String>();
        }
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(model);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        while (matcher.find()) {
            String key = matcher.group(1);
            set.add(key);
        }
        return set;
    }

    public static String replaceParams(String text, Map<String, Object> params) {
        if (HussarUtils.isNotEmpty((Object)text) && HussarUtils.isNotEmpty(params)) {
            for (String key : params.keySet()) {
                String replacement = Matcher.quoteReplacement(params.get(key) == null ? "" : params.get(key).toString());
                text = text.replaceAll("\\#\\{" + key + "}*\\}", replacement);
            }
        }
        return text;
    }

    public static Map<String, Object> getCurrentTemplateParams(Map<String, Object> allParams, String templateParams) {
        String[] templateParamsArray;
        if (HussarUtils.isEmpty(allParams) || HussarUtils.isEmpty((Object)templateParams)) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        for (String templateParam : templateParamsArray = templateParams.split(",")) {
            paramsMap.put(templateParam, allParams.get(templateParam));
        }
        return paramsMap;
    }
}

