/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.common.utils;

import com.jxdinfo.hussar.msg.mail.dto.MailSendRecordDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSendUtils {
    private static final Logger logger = LoggerFactory.getLogger(MailSendUtils.class);
    private static final String MAIL_REGX = "^[^\\s@]+@[^\\s@]+\\.[^\\s@]+$";
    private static final String FALSE = "false";
    private static final Integer NO_ENCRYPTION = 3;

    public static void messageSend(MailSendRecordDto mailSendRecordDto, List<AttachmentManagerModel> attachmentModels, String protocol) throws Exception {
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", protocol);
        props.setProperty("mail.smtp.host", mailSendRecordDto.getMailServerAddress());
        props.setProperty("mail.smtp.auth", "true");
        if (HussarUtils.isEmpty((Object)mailSendRecordDto.getSafeType()) || Objects.equals(mailSendRecordDto.getSafeType(), NO_ENCRYPTION)) {
            props.setProperty("mail.smtp.port", mailSendRecordDto.getMailPort());
            props.put("mail.smtp.ssl.enable", FALSE);
            props.put("mail.smtp.starttls.enable", FALSE);
        } else {
            props.setProperty("mail.smtp.port", mailSendRecordDto.getMailPort());
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.smtp.socketFactory.fallback", FALSE);
            props.setProperty("mail.smtp.socketFactory.port", mailSendRecordDto.getMailPort());
        }
        Session session = Session.getInstance((Properties)props);
        session.setDebug(true);
        MimeMessage message = MailSendUtils.createMimeMessage(session, mailSendRecordDto, attachmentModels);
        Transport transport = session.getTransport();
        transport.connect(mailSendRecordDto.getMailAddress(), mailSendRecordDto.getMailPassword());
        transport.sendMessage((Message)message, message.getAllRecipients());
        transport.close();
    }

    private static MimeMessage createMimeMessage(Session session, MailSendRecordDto mailSendRecordDto, List<AttachmentManagerModel> attachmentModels) throws Exception {
        String mailSubject;
        int i;
        String[] receiveMailNames;
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(mailSendRecordDto.getMailAddress(), mailSendRecordDto.getSenderName(), "UTF-8"));
        String[] receiveMails = mailSendRecordDto.getReciverMail().split(";");
        String receiverName = mailSendRecordDto.getReciverName();
        if (HussarUtils.isNotEmpty((Object)receiverName)) {
            receiveMailNames = receiverName.split(";");
            for (i = 0; i < receiveMails.length; ++i) {
                if (!receiveMails[i].matches(MAIL_REGX)) {
                    logger.error("\u90ae\u4ef6\u53d1\u9001 \u5b58\u5728\u4e0d\u5408\u6cd5\u90ae\u7bb1\uff1a{}", (Object)receiveMails[i]);
                    continue;
                }
                message.addRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(receiveMails[i], receiveMailNames[i], "UTF-8"));
            }
        } else {
            receiveMailNames = receiveMails;
            i = receiveMailNames.length;
            for (int j = 0; j < i; ++j) {
                String receiveMail = receiveMailNames[j];
                if (!receiveMail.matches(MAIL_REGX)) {
                    logger.error("\u90ae\u4ef6\u53d1\u9001 \u5b58\u5728\u4e0d\u5408\u6cd5\u90ae\u7bb1\uff1a{}", (Object)receiveMail);
                    continue;
                }
                message.addRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(receiveMail));
            }
        }
        if (HussarUtils.isEmpty((Object[])message.getAllRecipients())) {
            throw new RuntimeException(TranslateUtil.getTranslateName((String)"msg.api.illegal.email.address"));
        }
        if (!HussarUtils.isEmpty((Object)mailSendRecordDto.getCc())) {
            String[] ccs = mailSendRecordDto.getCc().split(";");
            for (i = 0; i < ccs.length; ++i) {
                message.addRecipient(MimeMessage.RecipientType.CC, (Address)new InternetAddress(ccs[i], ccs[i], "UTF-8"));
            }
        }
        if (HussarUtils.isEmpty((Object)(mailSubject = mailSendRecordDto.getMailSubject()))) {
            mailSubject = "\u65e0\u4e3b\u9898";
        }
        message.setSubject(mailSubject, "UTF-8");
        MimeMultipart mm = new MimeMultipart();
        MimeBodyPart text = new MimeBodyPart();
        text.setContent((Object)mailSendRecordDto.getMailContent(), "text/html;charset=UTF-8");
        mm.addBodyPart((BodyPart)text);
        if (HussarUtils.isNotEmpty(attachmentModels)) {
            for (AttachmentManagerModel attach : attachmentModels) {
                Long id = attach.getId();
                String fileName = attach.getAttachmentName();
                String suffix = fileName.substring(fileName.lastIndexOf("."));
                String path = attach.getAttachmentDir() + id + suffix;
                MimeBodyPart attachment = new MimeBodyPart();
                DataHandler dh2 = new DataHandler((DataSource)new FileDataSource(path));
                attachment.setDataHandler(dh2);
                attachment.setFileName(MimeUtility.encodeText((String)fileName));
                mm.addBodyPart((BodyPart)attachment);
            }
        }
        mm.setSubType("mixed");
        message.setContent((Multipart)mm);
        message.setSentDate(new Date());
        message.saveChanges();
        return message;
    }
}

