/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.third.service;

import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.msg.mail.third.service.MailProtocolSendService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MailProtocolSendFactory {
    @Autowired
    private List<MailProtocolSendService> mailProtocolSendServices;
    private static final Map<Integer, MailProtocolSendService> mailProtocolSendServiceMap = new HashMap<Integer, MailProtocolSendService>();

    @PostConstruct
    public void init() {
        if (HussarUtils.isNotEmpty(this.mailProtocolSendServices)) {
            for (MailProtocolSendService mailProtocolSendService : this.mailProtocolSendServices) {
                mailProtocolSendServiceMap.put(mailProtocolSendService.getProtocolCode(), mailProtocolSendService);
            }
        }
    }

    public static MailProtocolSendService getMailProtocolSendService(int protocolCode) {
        MailProtocolSendService mailProtocolSendService = mailProtocolSendServiceMap.get(protocolCode);
        if (HussarUtils.isEmpty((Object)mailProtocolSendService)) {
            ISysDicRefService sysDicRefService = (ISysDicRefService)SpringContextUtil.getBean(ISysDicRefService.class);
            String protocolName = "";
            if (sysDicRefService != null) {
                LinkedHashMap smsChannelType = sysDicRefService.getDictMapByType("sms_channel_type");
                protocolName = String.valueOf(smsChannelType.get(String.valueOf(protocolCode)));
            }
            throw new HussarException("[" + protocolName + "]" + TranslateUtil.getTranslateName((String)"msg.api.protocol.unimplemented"));
        }
        return mailProtocolSendService;
    }
}

