/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.common.enums;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;

public enum TenantQueueEnum {
    QUEUE_MSG_SMS(".tenant.msg.sms", ".tenant.msg.sms", "sms"),
    QUEUE_MSG_MP(".tenant.msg.mp", ".tenant.msg.mp", "wx_account"),
    QUEUE_MSG_APPIM(".tenant.msg.appim", ".tenant.msg.appim", "app_im"),
    QUEUE_MSG_MAIL(".tenant.msg.mail", ".tenant.msg.mail", "mail"),
    QUEUE_MSG_APPPUSH(".tenant.msg.app", ".tenant.msg.app", "app_push"),
    QUEUE_MSG_NOTICE(".tenant.msg.notice", ".tenant.msg.notice", "notice"),
    QUEUE_MSG_CP(".tenant.msg.cp", ".tenant.msg.cp", "cp"),
    QUEUE_MSG_DINGTALK(".tenant.msg.dingtalk", ".tenant.msg.dingtalk", "dingTalk");

    private final String queueName;
    private final String routeKey;
    private final String type;

    private TenantQueueEnum(String queueName, String routeKey, String type) {
        this.queueName = queueName;
        this.routeKey = routeKey;
        this.type = type;
    }

    public static String getRouteKeyByQueueName(String tenantCode, String queueName) {
        String routeKey = "";
        for (TenantQueueEnum tenantQueueEnum : TenantQueueEnum.values()) {
            if (!HussarUtils.equals((Object)(tenantCode + tenantQueueEnum.getQueueName()), (Object)queueName)) continue;
            routeKey = tenantQueueEnum.getRouteKey();
            break;
        }
        return routeKey;
    }

    public static TenantQueueEnum getTenantQueueEnumByType(String type) {
        for (TenantQueueEnum tenantQueueEnum : TenantQueueEnum.values()) {
            if (!HussarUtils.equals((Object)tenantQueueEnum.type, (Object)type)) continue;
            return tenantQueueEnum;
        }
        return null;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getRouteKey() {
        return this.routeKey;
    }

    public String getType() {
        return this.type;
    }
}

