/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.factory;

import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MsgUnitySendFactory
implements InitializingBean {
    @Autowired
    private List<MsgUnitySendFrameService> msgUnitySendFrameServices;
    private static final Map<String, MsgUnitySendFrameService> SEND_MAP = new HashMap<String, MsgUnitySendFrameService>();

    public static void setSendBeansToMap(String sendType, MsgUnitySendFrameService msgUnitySendFrameService) {
        SEND_MAP.put(sendType, msgUnitySendFrameService);
    }

    public static MsgUnitySendFrameService getMsgUnitySendService(String sendType) {
        MsgUnitySendFrameService msgUnitySendFrameService = SEND_MAP.get(sendType);
        if (HussarUtils.isEmpty((Object)msgUnitySendFrameService)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"msg.api.sending.implement.nonexistent"));
        }
        return msgUnitySendFrameService;
    }

    public void afterPropertiesSet() throws Exception {
        for (MsgUnitySendFrameService msgUnitySendFrameService : this.msgUnitySendFrameServices) {
            String sendType = msgUnitySendFrameService.getMsgSendType();
            if (!HussarUtils.isNotEmpty((Object)sendType)) continue;
            MsgUnitySendFactory.setSendBeansToMap(sendType, msgUnitySendFrameService);
        }
    }
}

