/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.common.utils;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContactInfoEncryptUtils {
    private static final String REG_STR = "\\[(.*?)\\]|([^,]+)";

    private ContactInfoEncryptUtils() {
    }

    public static String receiveAddressEncrypt(String receiveAddress) {
        if (HussarUtils.isEmpty((Object)receiveAddress)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Pattern pattern = Pattern.compile(REG_STR);
        Matcher matcher = pattern.matcher(receiveAddress);
        while (matcher.find()) {
            String group = matcher.group();
            if (HussarUtils.isNotEmpty((Object)result)) {
                result.append(", ");
            }
            if (group.startsWith("[")) {
                result.append("[");
                String[] array = group.substring(1, group.length() - 1).split(", ");
                for (int i = 0; i < array.length; ++i) {
                    if (i > 0) {
                        result.append(", ");
                    }
                    result.append(ContactInfoEncryptUtils.receiveAddressEncrypt(array[i].trim()));
                }
                result.append("]");
                continue;
            }
            String receive = group.trim();
            if (receive.length() <= 6) {
                result.append(receive, 0, Math.min(receive.length(), 3)).append("***");
                continue;
            }
            String prefix = receive.substring(0, 3);
            String suffix = receive.substring(receive.length() - 3);
            result.append(prefix).append("***").append(suffix);
        }
        return result.toString();
    }

    public static String addressEncrypt(String receiveAddress) {
        if (HussarUtils.isEmpty((Object)receiveAddress)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Matcher matcher = Pattern.compile(REG_STR).matcher(receiveAddress);
        while (matcher.find()) {
            ContactInfoEncryptUtils.processMatchedGroup(matcher.group(), result);
        }
        return result.toString();
    }

    private static void processMatchedGroup(String group, StringBuilder result) {
        if (result.length() > 0) {
            result.append(", ");
        }
        if (group.startsWith("[")) {
            ContactInfoEncryptUtils.processArrayGroup(group, result);
        } else {
            result.append(ContactInfoEncryptUtils.encryptSingle(group.trim()));
        }
    }

    private static void processArrayGroup(String group, StringBuilder result) {
        result.append("[");
        String[] array = group.substring(1, group.length() - 1).split(", ");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(ContactInfoEncryptUtils.receiveAddressEncrypt(array[i].trim()));
        }
        result.append("]");
    }

    private static String encryptSingle(String receive) {
        if (receive.length() <= 6) {
            return receive.substring(0, Math.min(receive.length(), 3)) + "***";
        }
        return receive.substring(0, 3) + "***" + receive.substring(receive.length() - 3);
    }
}

