/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.common.utils;

import com.jxdinfo.hussar.msg.common.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.common.utils.IdUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class BizCodeUtils {
    public static String generalBizCode(BizCodeEnum bizCodeEnum) {
        return BizCodeUtils.generalBizCode(bizCodeEnum, null);
    }

    public static String generalBizCode(String prefix, String dateFormat, int incrLen, int randomLen) {
        return BizCodeUtils.generalBizCode(prefix, dateFormat, incrLen, randomLen, null);
    }

    private static String generalBizCode(String prefix, String dateFormat, int incrLen, int randomLen, String uniqueCode) {
        StringBuilder bizCode = new StringBuilder(prefix);
        String dateStr = "";
        if (HussarUtils.isNotEmpty((Object)dateFormat)) {
            dateStr = DateTimeFormatter.ofPattern(dateFormat).format(LocalDateTime.now());
        }
        bizCode.append(dateStr);
        if (incrLen > 0) {
            bizCode.append(IdUtil.generateShortUuid(incrLen));
        }
        if (randomLen > 0) {
            bizCode.append(IdUtil.randomNumbers(randomLen));
        }
        if (HussarUtils.isNotEmpty((Object)uniqueCode)) {
            bizCode.append(uniqueCode);
        }
        return bizCode.toString();
    }

    public static String generalBizCode(BizCodeEnum bizCodeEnum, String uniqueCode) {
        StringBuilder bizCode = new StringBuilder(bizCodeEnum.getPrefix());
        String dateFormat = bizCodeEnum.getDateFormat();
        int incrLen = bizCodeEnum.getIncrLen();
        int randomLen = bizCodeEnum.getRandomLen();
        String dateStr = "";
        if (HussarUtils.isNotEmpty((Object)dateFormat)) {
            dateStr = DateTimeFormatter.ofPattern(dateFormat).format(LocalDateTime.now());
        }
        bizCode.append(dateStr);
        if (incrLen > 0) {
            bizCode.append(IdUtil.generateShortUuid(incrLen));
        }
        if (randomLen > 0) {
            bizCode.append(IdUtil.randomNumbers(randomLen));
        }
        if (HussarUtils.isNotEmpty((Object)uniqueCode)) {
            bizCode.append(uniqueCode);
        }
        return bizCode.toString();
    }
}

