/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.log.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.log.enums.TipConstantsEnum;
import com.jxdinfo.hussar.log.service.ILogDownloadService;
import com.jxdinfo.hussar.log.utils.Log4jUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class LogDownloadServiceImpl
implements ILogDownloadService {
    private static final Logger logger = LoggerFactory.getLogger(LogDownloadServiceImpl.class);
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Resource
    private IProtectionStatusConfigBoService protectionStatusConfigBoService;
    @Resource
    private ISysDicRefService sysDicRefService;
    private static final String LOG_FILE_PATH = "log_file_path";
    private static final String FILE_PATH = "filePath";
    private static final String SECURITY_LEVEL = "security_level";

    private String getLogPath() {
        String path = "";
        if (this.hussarTenantProperties.isEnabled()) {
            String tenantCode = HussarContextHolder.getHussarTenant().getTenantCode();
            return Log4jUtil.getTenantLogPath(tenantCode);
        }
        return Log4jUtil.getLogPath();
    }

    public ApiResponse<List<JSTreeModel>> getLogTree() {
        String pathId;
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        String path = this.getLogPath();
        if (ToolUtil.isEmpty((Object)path)) {
            throw new BaseException("\u65e5\u5fd7\u914d\u7f6e\u6587\u4ef6\u4e0d\u6b63\u786e\uff01");
        }
        HashMap<String, String> filePath = (HashMap<String, String>)HussarCacheUtil.get((String)LOG_FILE_PATH, (Object)FILE_PATH);
        if (ToolUtil.isEmpty((Object)filePath)) {
            pathId = UUID.randomUUID().toString();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(pathId, path);
            HussarCacheUtil.put((String)LOG_FILE_PATH, (Object)FILE_PATH, map);
            filePath = map;
        } else if (!filePath.containsValue(path)) {
            pathId = UUID.randomUUID().toString();
            filePath.put(pathId, path);
            HussarCacheUtil.put((String)LOG_FILE_PATH, (Object)FILE_PATH, (Object)filePath);
        }
        File file = new File(path);
        String rootName = file.getName();
        this.getLogDirectory(file, result);
        JSTreeModel root = new JSTreeModel();
        root.setCode(rootName);
        root.setText("\u65e5\u5fd7\u76ee\u5f55");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setType("root");
        root.setPath(LogDownloadServiceImpl.getKey(filePath, path));
        result.add(root);
        return ApiResponse.success((Object)TreeModelUtils.merge(result));
    }

    public ApiResponse<Map<String, Object>> getLogTable(String pathId) {
        Map filePath = (Map)HussarCacheUtil.get((String)LOG_FILE_PATH, (Object)FILE_PATH);
        String directory = (String)filePath.get(pathId);
        Page page = new Page();
        List<Map<String, Object>> list = this.getFiles(directory);
        page.setRecords(list);
        page.setTotal((long)list.size());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", page.getRecords());
        map.put("count", page.getTotal());
        return ApiResponse.success(map);
    }

    public void fileDownload(String fileId, HttpServletResponse response) {
        Map pathMap = (Map)HussarCacheUtil.get((String)LOG_FILE_PATH, (Object)FILE_PATH);
        String filePath = (String)pathMap.get(fileId);
        File file = new File(filePath);
        String fileName = "";
        try (FileInputStream fis = new FileInputStream(file);
             ServletOutputStream os = response.getOutputStream();){
            fileName = URLEncoder.encode(file.getName(), "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            IOUtils.copy((InputStream)fis, (OutputStream)os, (int)4096);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void fileDownloadWithSecurity(String fileId, String securityLevel, HttpServletResponse response) {
        Map pathMap = (Map)HussarCacheUtil.get((String)LOG_FILE_PATH, (Object)FILE_PATH);
        String filePath = (String)pathMap.get(fileId);
        File file = new File(filePath);
        String fileName = "";
        if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue() && HussarUtils.isNotEmpty((Object)securityLevel)) {
            String securityLabel = this.sysDicRefService.getDictLabelTranslate(SECURITY_LEVEL, securityLevel);
            if (HussarUtils.isEmpty((Object)securityLabel)) {
                securityLabel = TranslateUtil.getTranslateName((String)TipConstantsEnum.TRANSLATE_DICT_CONSTANT_PUBLIC.getMessage());
            }
            fileName = "\uff08" + securityLabel + "\uff09" + "-" + fileName;
        }
        try (FileInputStream fis = new FileInputStream(file);
             ServletOutputStream os = response.getOutputStream();){
            fileName = URLEncoder.encode(fileName + file.getName(), "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            IOUtils.copy((InputStream)fis, (OutputStream)os, (int)4096);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private List<JSTreeModel> getLogDirectory(File file, List<JSTreeModel> resultFiles) {
        File[] files = file.listFiles();
        if (ToolUtil.isEmpty((Object)files)) {
            return resultFiles;
        }
        Map pathMap = (Map)HussarCacheUtil.get((String)LOG_FILE_PATH, (Object)FILE_PATH);
        for (File f : files) {
            String filePath = f.getAbsolutePath();
            String pathId = UUID.randomUUID().toString();
            if (!pathMap.containsValue(filePath)) {
                if (f.isFile()) {
                    if (filePath.endsWith(".log")) {
                        pathMap.put(pathId, filePath);
                    }
                } else {
                    pathMap.put(pathId, filePath);
                }
            }
            if (!f.isDirectory()) continue;
            JSTreeModel node = new JSTreeModel();
            node.setCode(f.getName());
            node.setText(f.getName());
            node.setParentTypeCode(f.getParentFile().getName());
            node.setType("directory");
            node.setPath(LogDownloadServiceImpl.getKey(pathMap, filePath));
            resultFiles.add(node);
            HussarCacheUtil.put((String)LOG_FILE_PATH, (Object)FILE_PATH, (Object)pathMap);
            this.getLogDirectory(f, resultFiles);
        }
        HussarCacheUtil.put((String)LOG_FILE_PATH, (Object)FILE_PATH, (Object)pathMap);
        return resultFiles;
    }

    public ApiResponse<List<JSTreeModel>> getLogTree_new() {
        String pathId;
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        String path = this.getLogPath();
        if (ToolUtil.isEmpty((Object)path)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.LOG_CONFIG_INCORRECT.getMessage()));
        }
        HashMap<String, String> filePath = (HashMap<String, String>)HussarCacheUtil.get((String)LOG_FILE_PATH, (Object)FILE_PATH);
        if (ToolUtil.isEmpty((Object)filePath)) {
            pathId = UUID.randomUUID().toString();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(pathId, path);
            HussarCacheUtil.put((String)LOG_FILE_PATH, (Object)FILE_PATH, map);
            filePath = map;
        } else if (!filePath.containsValue(path)) {
            pathId = UUID.randomUUID().toString();
            filePath.put(pathId, path);
            HussarCacheUtil.put((String)LOG_FILE_PATH, (Object)FILE_PATH, (Object)filePath);
        }
        File file = new File(path);
        String rootName = file.getName();
        JSTreeModel root = new JSTreeModel();
        result.add(root);
        root.setId(Constants.ROOT_NODE_ID);
        root.setCode(rootName);
        root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.LOG_DIRECTORY.getMessage()));
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setType("root");
        root.setPath(LogDownloadServiceImpl.getKey(filePath, path));
        this.getLogDirectory_new(root);
        return ApiResponse.success(result);
    }

    private JSTreeModel getLogDirectory_new(JSTreeModel resultFiles) {
        LinkedList<JSTreeModel> queue = new LinkedList<JSTreeModel>();
        queue.offer(resultFiles);
        while (!queue.isEmpty()) {
            JSTreeModel poll = (JSTreeModel)queue.poll();
            Map pathMap = (Map)HussarCacheUtil.get((String)LOG_FILE_PATH, (Object)FILE_PATH);
            String path = (String)pathMap.get(poll.getPath());
            File file = new File(path);
            File[] files = file.listFiles();
            if (!ToolUtil.isNotEmpty((Object)files)) continue;
            ArrayList<JSTreeModel> list = new ArrayList<JSTreeModel>();
            poll.setChildrenList(list);
            for (File temp : files) {
                String filePath = temp.getAbsolutePath();
                String pathId = UUID.randomUUID().toString();
                if (!pathMap.containsValue(filePath)) {
                    pathMap.put(pathId, filePath);
                }
                if (!temp.isDirectory()) continue;
                JSTreeModel node = new JSTreeModel();
                node.setId(Long.valueOf(IdWorker.getId((Object)node)));
                node.setCode(temp.getName());
                node.setText(temp.getName());
                node.setParentTypeCode(temp.getParentFile().getName());
                node.setType("directory");
                node.setPath(LogDownloadServiceImpl.getKey(pathMap, filePath));
                list.add(node);
                queue.offer(node);
            }
            HussarCacheUtil.put((String)LOG_FILE_PATH, (Object)FILE_PATH, (Object)pathMap);
        }
        return resultFiles;
    }

    private List<Map<String, Object>> getFiles(String directory) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        File file = new File(directory);
        File[] files = file.listFiles();
        if (ToolUtil.isEmpty((Object)files)) {
            return result;
        }
        for (File f : files) {
            if (!f.isFile() || !file.getPath().equals(f.getParent())) continue;
            String filePath = f.getAbsolutePath();
            Map pathMap = (Map)HussarCacheUtil.get((String)LOG_FILE_PATH, (Object)FILE_PATH);
            if (!pathMap.containsValue(filePath)) {
                String uuid = UUID.randomUUID().toString();
                pathMap.put(uuid, filePath);
                HussarCacheUtil.put((String)LOG_FILE_PATH, (Object)FILE_PATH, (Object)pathMap);
            }
            HashMap<String, Object> node = new HashMap<String, Object>(3);
            if (f.length() <= 0L) continue;
            node.put("fileId", LogDownloadServiceImpl.getKey(pathMap, filePath));
            node.put("fileName", f.getName());
            node.put("fileSize", f.length() / 1024L);
            node.put("fileLastEditTime", this.formatDate(f.lastModified()));
            result.add(node);
        }
        return result;
    }

    private String formatDate(long timestamp) {
        Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        date.setTime(timestamp);
        return DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
    }

    private static String getKey(Map<String, String> map, String value) {
        String key = null;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            key = entry.getKey();
        }
        return key;
    }
}

