/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.lang.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.lang.dao.SysLangQuoteMapper;
import com.jxdinfo.hussar.lang.dto.LangQuoteDto;
import com.jxdinfo.hussar.lang.model.SysLangQuote;
import com.jxdinfo.hussar.lang.service.ISysLangQuoteService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.lang.service.impl.SysLangQuoteImpl")
public class SysLangQuoteImpl
extends HussarServiceImpl<SysLangQuoteMapper, SysLangQuote>
implements ISysLangQuoteService {
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<List<SysLangQuote>> operateQuote(LangQuoteDto quoteDto) {
        List deleteList = quoteDto.getDeleteList();
        this.removeByIds(deleteList);
        List langQuotes = quoteDto.getSaveOrUpdateList();
        List addList = langQuotes.stream().filter(langQuote -> HussarUtils.isEmpty((Object)langQuote.getQuoteId())).collect(Collectors.toList());
        List updateList = langQuotes.stream().filter(langQuote -> HussarUtils.isNotEmpty((Object)langQuote.getQuoteId())).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(addList)) {
            this.saveBatch(addList);
        }
        if (HussarUtils.isNotEmpty(updateList)) {
            this.updateBatchById(updateList);
        }
        return ApiResponse.success((Object)langQuotes);
    }

    public ApiResponse<List<SysLangQuote>> getList(Long appId, Long formId, String quoteModule) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)appId)) {
            queryWrapper.eq(SysLangQuote::getAppId, (Object)appId);
        }
        if (HussarUtils.isNotEmpty((Object)formId)) {
            queryWrapper.eq(SysLangQuote::getFormId, (Object)formId);
        }
        if (HussarUtils.isNotEmpty((Object)quoteModule)) {
            queryWrapper.eq(SysLangQuote::getQuoteModule, (Object)Integer.parseInt(quoteModule));
        }
        List sysLangQuotes = ((SysLangQuoteMapper)this.getBaseMapper()).selectList((Wrapper)queryWrapper);
        return ApiResponse.success((Object)sysLangQuotes);
    }
}

