/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.lang.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.lang.dao.SysMultiLangMapper;
import com.jxdinfo.hussar.lang.dao.SysMultiLangMgtMapper;
import com.jxdinfo.hussar.lang.dto.SysMultiLangMgtDto;
import com.jxdinfo.hussar.lang.enums.LangEnum;
import com.jxdinfo.hussar.lang.handle.WordHandle;
import com.jxdinfo.hussar.lang.model.SysLangTask;
import com.jxdinfo.hussar.lang.model.SysMultiLang;
import com.jxdinfo.hussar.lang.model.SysMultiLangMgt;
import com.jxdinfo.hussar.lang.service.ISysLangTaskService;
import com.jxdinfo.hussar.lang.service.ISysMultiLangMgtService;
import com.jxdinfo.hussar.lang.service.ISysMultiLangService;
import com.jxdinfo.hussar.lang.vo.LangImportVo;
import com.jxdinfo.hussar.lang.vo.SysMultiLangVo;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Component
public class LangAsync {
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private ISysLangTaskService sysLangTaskService;
    @Resource
    private ISysMultiLangService sysMultiLangService;
    @Resource
    private SysMultiLangMapper sysMultiLangMapper;
    @Resource
    private ISysMultiLangMgtService sysMultiLangMgtService;
    @Resource
    private SysMultiLangMgtMapper sysMultiLangMgtMapper;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    private static Logger LOGGER = LoggerFactory.getLogger(LangAsync.class);
    public static final String CUSTOM_WORKBOOK_NAME = "\u7528\u6237\u81ea\u5b9a\u4e49";
    public static final String SYSTEM_WORKBOOK_NAME = "\u7cfb\u7edf\u5185\u7f6e";
    public static final String BUSINESS_WORKBOOK_NAME = "\u4e1a\u52a1\u8bed\u8a00\u5305";
    public static final String LANG_KEY = "langKey";
    public static final String LANG_TEXT = "langText";
    public static final String FIRST_CELL_VALUE = "i18n Key";
    public static final int DEFAULT_WIDTH = 8500;
    public static final int EXPORT_SUCCESS = 1;
    public static final int EXPORT_FAIL = -1;
    public static final String CUSTOM_LANG = "custom";
    public static final String SYSTEM_LANG = "system";
    public static final String BUSINESS_LANG = "business";
    private static final int SHOW = 1;
    @Resource
    private HussarConfig hussarConfig;

    public void getLangs(List<String> langs) {
        List list;
        String suffix = "master";
        if (HussarUtils.isNotEmpty((Object)this.creatorCachePrefix())) {
            suffix = this.creatorCachePrefix();
        }
        if (HussarUtils.isEmpty((Object)(list = (List)HussarCacheUtil.get((String)"lang_list", (Object)(":" + suffix + ":" + "lang_list"))))) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(SysMultiLang::getIsShow, (Object)1)).orderByAsc(SysMultiLang::getSort);
            list = this.sysMultiLangMapper.selectList((Wrapper)wrapper);
            HussarCacheUtil.put((String)"lang_list", (Object)(":" + suffix + ":" + "lang_list"), (Object)list);
        }
        list.forEach(sysMultiLang -> {
            String langCode = sysMultiLang.getLangCode();
            if (HussarUtils.isNotEmpty((Object)langCode) && LangEnum.checkLangValue((String)langCode)) {
                langs.add(sysMultiLang.getLangCode());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#dataSourceKey")
    public void langExport(SysLangTask task, String dataSourceKey) {
        String tcode = HussarContextHolder.getHussarTenant().getTenantCode();
        String connName = HussarContextHolder.getConnName();
        JSONObject customLang = new JSONObject();
        JSONObject systemLang = new JSONObject();
        JSONObject businessLang = new JSONObject();
        try {
            this.formatData(connName, customLang, CUSTOM_LANG);
            this.formatData(connName, systemLang, SYSTEM_LANG);
            this.formatData(connName, businessLang, BUSINESS_LANG);
            XSSFWorkbook workbook = new XSSFWorkbook();
            this.opSheet((Workbook)workbook, customLang, CUSTOM_WORKBOOK_NAME);
            this.opSheet((Workbook)workbook, systemLang, SYSTEM_WORKBOOK_NAME);
            this.opSheet((Workbook)workbook, businessLang, BUSINESS_WORKBOOK_NAME);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String currentDate = sdf.format(new Date());
            AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
            this.attachmentManagerService.save((Object)attachmentManagerModelVo);
            Long fileId = attachmentManagerModelVo.getId();
            String fileName = "\u591a\u8bed\u8a00\u7ffb\u8bd1\u8868-" + currentDate + ".xlsx";
            String outPath = this.hussarConfig.getFileUploadPath().replace("\\", "/");
            File folder = new File(outPath);
            if (!folder.isDirectory()) {
                folder.mkdirs();
            }
            String path = outPath + fileId + ".xlsx";
            FileOutputStream fileOutputStream = new FileOutputStream(path);
            workbook.write((OutputStream)fileOutputStream);
            fileOutputStream.close();
            workbook.close();
            long fileSize = Files.size(Paths.get(path, new String[0]));
            attachmentManagerModelVo.setAttachmentName(fileName);
            attachmentManagerModelVo.setAttachmentDir(outPath);
            attachmentManagerModelVo.setAttachmentType(WordHandle.getSuffix(attachmentManagerModelVo.getAttachmentName()).replace(".", ""));
            attachmentManagerModelVo.setBytes(String.valueOf(fileSize));
            this.attachmentManagerService.updateById((Object)attachmentManagerModelVo);
            task.setTaskStatus(1);
            task.setFileId(fileId);
        }
        catch (Exception e) {
            task.setTaskStatus(-1);
            LOGGER.error("\u8bed\u8a00\u5305\u5bfc\u51fa\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\uff1a", (Throwable)e);
        }
        finally {
            this.sysLangTaskService.updateById((Object)task);
        }
    }

    @HussarDs(value="#connName")
    private void formatData(String connName, JSONObject langJson, String type) {
        ArrayList<String> strings = new ArrayList<String>();
        this.getLangs(strings);
        List<String> allKey = this.sysMultiLangMgtMapper.getAllKey(type);
        for (int i = 0; i < strings.size(); ++i) {
            JSONArray array = new JSONArray();
            for (int j = 0; j < allKey.size(); ++j) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(LANG_KEY, (Object)allKey.get(j));
                Map langMap = (Map)this.sysMultiLangMgtService.getTextByLangKey(allKey.get(j)).getData();
                if (!langMap.containsKey(LANG_TEXT) || HussarUtils.isEmpty(langMap.get(LANG_TEXT)) || HussarUtils.isEmpty(((Map)langMap.get(LANG_TEXT)).get(strings.get(i)))) {
                    jsonObject.put(LANG_TEXT, (Object)"");
                } else {
                    jsonObject.put(LANG_TEXT, (Object)((String)((Map)langMap.get(LANG_TEXT)).get(strings.get(i))));
                }
                array.add((Object)jsonObject);
            }
            langJson.put((String)strings.get(i), (Object)array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#dataSourceKey")
    @HussarTransactional
    public void langImport(Long appId, Long fileId, SysLangTask sysLangTask, String dataSourceKey) {
        String outPath = this.hussarConfig.getFileUploadPath().replace("\\", "/");
        File folder = new File(outPath);
        if (!folder.isDirectory()) {
            folder.mkdirs();
        }
        String path = outPath + fileId + ".xlsx";
        ArrayList<SysMultiLangMgt> addList = new ArrayList<SysMultiLangMgt>();
        HashSet<String> langs = new HashSet<String>();
        ArrayList<SysMultiLangMgt> updateList = new ArrayList<SysMultiLangMgt>();
        ArrayList<String> langKeys = new ArrayList<String>();
        InputStream stream = null;
        int errorNum = 0;
        try {
            stream = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
            XSSFWorkbook workbook = new XSSFWorkbook(stream);
            Iterator sheetIterator = workbook.sheetIterator();
            LOGGER.info("------------\u5f00\u59cb\u89e3\u6790\u591a\u8bed\u8a00\u5305------------");
            errorNum = this.opImportSheet(sheetIterator, langs, appId, addList, langKeys, updateList);
            LOGGER.info("------------\u591a\u8bed\u8a00\u5305\u89e3\u6790\u5b8c\u6bd5------------");
            LOGGER.info("------------\u5f00\u59cb\u6dfb\u52a0\u65b0\u589e\u8bed\u8a00------------");
            this.opImportLang(appId, langs);
            LOGGER.info("------------\u65b0\u589e\u8bed\u8a00\u6dfb\u52a0\u5b8c\u6bd5------------");
            LOGGER.info("------------\u5f00\u59cb\u66f4\u65b0\u591a\u8bed\u8a00\u5305------------");
            this.batchHandleImportData(addList, langKeys, updateList);
            LOGGER.info("------------\u591a\u8bed\u8a00\u5305\u66f4\u65b0\u5b8c\u6bd5------------");
            int addNum = addList.size();
            int updateNum = updateList.size();
            LOGGER.info("\u65b0\u589e\u8bed\u8a00\u5305\u6570\u91cf\uff1a" + addNum + "\uff0c\u66f4\u65b0\u8bed\u8a00\u5305\u6570\u91cf\uff1a" + updateNum);
            LOGGER.info("\u5bfc\u5165\u6570\u636e\uff1a{}\u6761", (Object)langKeys.size());
            LOGGER.info("\u5f02\u5e38\u6570\u636e\uff1a{}\u6761", (Object)errorNum);
            sysLangTask.setImportNum(langKeys.size());
            sysLangTask.setErrorNum(errorNum);
            sysLangTask.setTaskStatus(1);
        }
        catch (Exception e) {
            sysLangTask.setTaskStatus(-1);
            LOGGER.error("\u8bed\u8a00\u5305\u5bfc\u5165\u6587\u4ef6\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.sysLangTaskService.updateById((Object)sysLangTask);
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u8f93\u5165\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    public LangImportVo preLangImport(Long appId, MultipartFile file) {
        LangImportVo langImportVo = new LangImportVo();
        ArrayList<SysMultiLangMgt> addList = new ArrayList<SysMultiLangMgt>();
        HashSet<String> langs = new HashSet<String>();
        ArrayList<SysMultiLangMgt> updateList = new ArrayList<SysMultiLangMgt>();
        ArrayList<String> langKeys = new ArrayList<String>();
        InputStream stream = null;
        int errorNum = 0;
        try {
            stream = file.getInputStream();
            AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
            this.attachmentManagerService.save((Object)attachmentManagerModelVo);
            Long fileId = attachmentManagerModelVo.getId();
            String outPath = this.hussarConfig.getFileUploadPath().replace("\\", "/");
            File folder = new File(outPath);
            if (!folder.isDirectory()) {
                folder.mkdirs();
            }
            String path = outPath + fileId + ".xlsx";
            File dest = new File(path);
            file.transferTo(dest);
            attachmentManagerModelVo.setAttachmentName("\u591a\u8bed\u8a00\u5305\u5bfc\u5165-" + fileId + ".xlsx");
            attachmentManagerModelVo.setAttachmentDir(outPath);
            attachmentManagerModelVo.setAttachmentType(WordHandle.getSuffix(attachmentManagerModelVo.getAttachmentName()).replace(".", ""));
            attachmentManagerModelVo.setBytes(String.valueOf(Files.size(Paths.get(path, new String[0]))));
            this.attachmentManagerService.updateById((Object)attachmentManagerModelVo);
            XSSFWorkbook workbook = new XSSFWorkbook(stream);
            Iterator sheetIterator = workbook.sheetIterator();
            LOGGER.info("------------\u5f00\u59cb\u89e3\u6790\u591a\u8bed\u8a00\u5305------------");
            errorNum = this.opImportSheet(sheetIterator, langs, appId, addList, langKeys, updateList);
            LOGGER.info("------------\u591a\u8bed\u8a00\u5305\u89e3\u6790\u5b8c\u6bd5------------");
            langImportVo.setFileId(fileId);
            langImportVo.setErrorNum(errorNum);
            LangImportVo langImportVo2 = langImportVo;
            return langImportVo2;
        }
        catch (Exception e) {
            LOGGER.error("\u8bed\u8a00\u5305\u5bfc\u5165\u6587\u4ef6\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            throw new BaseException("\u8bed\u8a00\u5305\u5bfc\u5165\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u8f93\u5165\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    private void opSheet(Workbook workbook, JSONObject targetLang, String sheetName) {
        Object lang;
        Object object;
        Sheet sheet = workbook.createSheet(sheetName);
        sheet.createFreezePane(2, 1);
        CellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.SKY_BLUE.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Row row = sheet.createRow(0);
        Cell rowCell = row.createCell(0);
        rowCell.setCellValue(FIRST_CELL_VALUE);
        rowCell.setCellStyle(style);
        sheet.setColumnWidth(0, 8500);
        int cellIndex = 1;
        ArrayList<String> langs = new ArrayList<String>();
        ArrayList<String> langKeys = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>();
        this.getLangs(keys);
        for (String key : keys) {
            if (!key.equals(LangEnum.ZH_CN.getLangValue())) continue;
            langs.add(key);
        }
        for (String key : keys) {
            if (key.equals(LangEnum.ZH_CN.getLangValue())) continue;
            langs.add(key);
        }
        for (String lang2 : langs) {
            Cell cell = row.createCell(cellIndex);
            cell.setCellValue(LangEnum.getLabelByValue((String)lang2));
            cell.setCellStyle(style);
            sheet.setColumnWidth(cellIndex, 8500);
            ++cellIndex;
        }
        if (HussarUtils.isNotEmpty(langs) && (object = targetLang.get(lang = (String)langs.get(0))) instanceof JSONArray) {
            JSONArray arrayList = (JSONArray)object;
            for (Object object1 : arrayList) {
                if (!(object1 instanceof JSONObject)) continue;
                JSONObject linkedHashMap = (JSONObject)object1;
                String langKey = linkedHashMap.get((Object)LANG_KEY).toString();
                langKeys.add(langKey);
            }
        }
        for (String langKey : langKeys) {
            Row langKeyRow = sheet.createRow(langKeys.indexOf(langKey) + 1);
            Cell langKeyCell = langKeyRow.createCell(0);
            langKeyCell.setCellValue(langKey);
        }
        Iterator rowIterator = sheet.rowIterator();
        while (rowIterator.hasNext()) {
            Row row1 = (Row)rowIterator.next();
            String langKey = row1.getCell(0).getStringCellValue();
            if (langKey.equals(FIRST_CELL_VALUE)) continue;
            block6: for (int i = 0; i < langs.size(); ++i) {
                Cell cell = row1.createCell(i + 1);
                String stringCellValue = LangEnum.getValueByLabel((String)sheet.getRow(0).getCell(i + 1).getStringCellValue());
                Object object2 = targetLang.get((Object)stringCellValue);
                if (!(object2 instanceof JSONArray)) continue;
                JSONArray arrayList = (JSONArray)object2;
                for (Object object1 : arrayList) {
                    JSONObject linkedHashMap;
                    if (!(object1 instanceof JSONObject) || !(linkedHashMap = (JSONObject)object1).get((Object)LANG_KEY).equals(langKey)) continue;
                    cell.setCellValue(linkedHashMap.get((Object)LANG_TEXT).toString());
                    continue block6;
                }
            }
        }
    }

    private boolean judgeCellValue(Cell cell) {
        if (HussarUtils.isEmpty((Object)cell)) {
            return true;
        }
        cell.setCellType(CellType.STRING);
        return HussarUtils.isEmpty((Object)cell.getStringCellValue());
    }

    private int opImportSheet(Iterator<Sheet> sheetIterator, Set<String> langs, Long appId, List<SysMultiLangMgt> addList, List<String> langKeys, List<SysMultiLangMgt> updateList) {
        int errorNum = 0;
        while (sheetIterator.hasNext()) {
            String type;
            Sheet sheet = sheetIterator.next();
            String sheetName = sheet.getSheetName();
            if (CUSTOM_WORKBOOK_NAME.equals(sheetName)) {
                type = CUSTOM_LANG;
            } else if (SYSTEM_WORKBOOK_NAME.equals(sheetName)) {
                type = SYSTEM_LANG;
            } else if (BUSINESS_WORKBOOK_NAME.equals(sheetName)) {
                type = BUSINESS_LANG;
            } else {
                LOGGER.error("\u4e0d\u652f\u6301\u5bfc\u5165'{}', \u8bf7\u5bfc\u5165'\u7528\u6237\u81ea\u5b9a\u4e49'", (Object)sheetName);
                continue;
            }
            Iterator rowIterator = sheet.rowIterator();
            int rowIndex = 0;
            while (rowIterator.hasNext()) {
                ++rowIndex;
                Row row = (Row)rowIterator.next();
                String langKey = "";
                try {
                    SysMultiLangMgt sysMultiLangMgt;
                    String label;
                    SysMultiLangMgt sysMultiLangMgt2;
                    Object cell1;
                    if (row.getRowNum() == 0) {
                        Iterator cellIterator = row.cellIterator();
                        while (cellIterator.hasNext()) {
                            Cell cell12 = (Cell)cellIterator.next();
                            cell12.setCellType(CellType.STRING);
                            if (cell12.getColumnIndex() == 0 || !LangEnum.checkLang((String)cell12.getStringCellValue())) continue;
                            langs.add(LangEnum.getValueByLabel((String)cell12.getStringCellValue()));
                        }
                        continue;
                    }
                    Cell cell = row.getCell(0);
                    if (this.judgeCellValue(cell)) {
                        String key = this.sysMultiLangMgtService.generateLangKey();
                        langKeys.add(key);
                        Iterator cellIterator = row.cellIterator();
                        ArrayList<String> cellLangs = new ArrayList<String>();
                        while (cellIterator.hasNext()) {
                            cell1 = (Cell)cellIterator.next();
                            cell1.setCellType(CellType.STRING);
                            if (cell1.getColumnIndex() == 0) continue;
                            sysMultiLangMgt2 = new SysMultiLangMgt();
                            sysMultiLangMgt2.setAppId(appId);
                            sysMultiLangMgt2.setLangText(cell1.getStringCellValue());
                            sysMultiLangMgt2.setLangKey(key);
                            sysMultiLangMgt2.setType(type);
                            label = sheet.getRow(0).getCell(cell1.getColumnIndex()).getStringCellValue();
                            if (!LangEnum.checkLang((String)label)) continue;
                            sysMultiLangMgt2.setLang(LangEnum.getValueByLabel((String)label));
                            cellLangs.add(sysMultiLangMgt2.getLang());
                            addList.add(sysMultiLangMgt2);
                        }
                        for (String lang : langs) {
                            if (cellLangs.contains(lang)) continue;
                            sysMultiLangMgt = new SysMultiLangMgt();
                            sysMultiLangMgt.setAppId(appId);
                            sysMultiLangMgt.setLangText("");
                            sysMultiLangMgt.setLangKey(key);
                            sysMultiLangMgt.setLang(lang);
                            sysMultiLangMgt.setType(type);
                            addList.add(sysMultiLangMgt);
                        }
                        continue;
                    }
                    Iterator cellIterator = row.cellIterator();
                    ArrayList<String> cellLangs = new ArrayList<String>();
                    boolean isRepeat = false;
                    while (cellIterator.hasNext()) {
                        cell1 = (Cell)cellIterator.next();
                        cell1.setCellType(CellType.STRING);
                        if (cell1.getColumnIndex() == 0) {
                            langKey = cell1.getStringCellValue();
                            if (!langKeys.contains(langKey)) {
                                langKeys.add(langKey);
                                continue;
                            }
                            isRepeat = true;
                            break;
                        }
                        sysMultiLangMgt2 = new SysMultiLangMgt();
                        sysMultiLangMgt2.setLangKey(row.getCell(0).getStringCellValue());
                        sysMultiLangMgt2.setAppId(appId);
                        sysMultiLangMgt2.setLangText(cell1.getStringCellValue());
                        sysMultiLangMgt2.setType(type);
                        label = sheet.getRow(0).getCell(cell1.getColumnIndex()).getStringCellValue();
                        if (!LangEnum.checkLang((String)label)) continue;
                        sysMultiLangMgt2.setLang(LangEnum.getValueByLabel((String)label));
                        cellLangs.add(sysMultiLangMgt2.getLang());
                        updateList.add(sysMultiLangMgt2);
                    }
                    if (isRepeat) continue;
                    for (String lang : langs) {
                        if (cellLangs.contains(lang)) continue;
                        sysMultiLangMgt = new SysMultiLangMgt();
                        sysMultiLangMgt.setAppId(appId);
                        sysMultiLangMgt.setLangText("");
                        sysMultiLangMgt.setLangKey(row.getCell(0).getStringCellValue());
                        sysMultiLangMgt.setLang(lang);
                        sysMultiLangMgt.setType(type);
                        updateList.add(sysMultiLangMgt);
                    }
                }
                catch (Exception e) {
                    langKeys.remove(langKey);
                    LOGGER.error("\u89e3\u6790\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
                    LOGGER.error("\u89e3\u6790\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38,\u5f02\u5e38\u884c\u6570:{}", (Object)rowIndex);
                    ++errorNum;
                }
            }
        }
        return errorNum;
    }

    @HussarTransactional
    public void batchHandleImportData(List<SysMultiLangMgt> addList, List<String> langKeys, List<SysMultiLangMgt> updateList) {
        List noSysAddList = addList.stream().filter(sysMultiLangMgt -> sysMultiLangMgt.getType().equals(CUSTOM_LANG)).collect(Collectors.toList());
        ArrayList noSysKeyList = new ArrayList();
        noSysAddList.stream().forEach(sysMultiLangMgt -> {
            if (!noSysKeyList.contains(sysMultiLangMgt.getLangKey())) {
                noSysKeyList.add(sysMultiLangMgt.getLangKey());
            }
        });
        ArrayList list = new ArrayList(noSysAddList);
        List noSysUpdateList = updateList.stream().filter(sysMultiLangMgt -> sysMultiLangMgt.getType().equals(CUSTOM_LANG)).collect(Collectors.toList());
        updateList.removeAll(noSysUpdateList);
        noSysUpdateList.stream().forEach(sysMultiLangMgt -> {
            if (!noSysKeyList.contains(sysMultiLangMgt.getLangKey())) {
                noSysKeyList.add(sysMultiLangMgt.getLangKey());
            }
        });
        ArrayList updateLangKey = new ArrayList();
        updateList.stream().forEach(sysMultiLangMgt -> {
            if (!updateLangKey.contains(sysMultiLangMgt.getLangKey())) {
                updateLangKey.add(sysMultiLangMgt.getLangKey());
            }
        });
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysMultiLangMgt::getLangKey, updateLangKey);
        List sysUpdateList = this.sysMultiLangMgtService.list((Wrapper)queryWrapper);
        ArrayList sysUpdateLangList = new ArrayList();
        Map<String, List<String>> keyList = sysUpdateList.stream().collect(Collectors.groupingBy(SysMultiLangMgt::getLangKey, Collectors.mapping(SysMultiLangMgt::getLang, Collectors.toList())));
        ArrayList<String> keyListIncludeUpAndLow = new ArrayList<String>();
        keyListIncludeUpAndLow.addAll(keyList.keySet());
        keyListIncludeUpAndLow.addAll(noSysKeyList);
        LOGGER.info("------------\u5904\u7406\u91cd\u590d\u7684key------------");
        this.deDuplicate(keyList);
        LOGGER.info("------------\u91cd\u590d\u7684key\u5904\u7406\u5b8c\u6210------------");
        updateList.stream().forEach(smlm -> {
            for (SysMultiLangMgt sysMultiLangMgt : sysUpdateList) {
                if (!sysMultiLangMgt.getLangKey().trim().equalsIgnoreCase(smlm.getLangKey().trim())) continue;
                if (sysMultiLangMgt.getLang().equals(smlm.getLang())) {
                    sysMultiLangMgt.setLangText(smlm.getLangText());
                    break;
                }
                if (HussarUtils.isEmpty(keyList.get(smlm.getLangKey()))) {
                    for (String langKey : keyList.keySet()) {
                        if (!langKey.trim().equalsIgnoreCase(smlm.getLangKey().trim())) continue;
                        smlm.setLangKey(langKey);
                        break;
                    }
                }
                List langList = new ArrayList();
                langList = HussarUtils.isNotEmpty(keyList.get(smlm.getLangKey().trim())) ? (List)keyList.get(smlm.getLangKey().trim()) : (List)keyList.get(smlm.getLangKey());
                if (langList.contains(smlm.getLang())) continue;
                SysMultiLangMgt sysMultiLangMgt1 = new SysMultiLangMgt();
                sysMultiLangMgt1.setLangKey(smlm.getLangKey());
                sysMultiLangMgt1.setLangText(smlm.getLangText());
                sysMultiLangMgt1.setLang(smlm.getLang());
                sysMultiLangMgt1.setType(smlm.getType());
                sysUpdateLangList.add(sysMultiLangMgt1);
                break;
            }
        });
        sysUpdateList.addAll(sysUpdateLangList);
        list.addAll(noSysUpdateList);
        list.addAll(sysUpdateList);
        LOGGER.info("------------\u5904\u7406\u91cd\u590d\u6570\u636e------------");
        HashMap noDupMap = new HashMap();
        List realupdateList = list.stream().filter(s -> {
            if (HussarUtils.isNotEmpty(noDupMap.get(s.getLangKey().toLowerCase()))) {
                if (((List)noDupMap.get(s.getLangKey().toLowerCase())).contains(s.getLang())) {
                    return false;
                }
                ((List)noDupMap.get(s.getLangKey().toLowerCase())).add(s.getLang());
                return true;
            }
            ArrayList<String> langList = new ArrayList<String>();
            langList.add(s.getLang());
            noDupMap.put(s.getLangKey().toLowerCase(), langList);
            return true;
        }).collect(Collectors.toList());
        LOGGER.info("------------\u91cd\u590d\u6570\u636e\u5904\u7406\u5b8c\u6210------------");
        String dataSourceKey = HussarContextHolder.getConnName();
        ThreadPoolUtil.execute(() -> {
            RequestContextHolder.resetRequestAttributes();
            this.updateLangTime(realupdateList, dataSourceKey);
        });
        langKeys.clear();
        langKeys.addAll(new ArrayList<String>(keyList.keySet()));
        langKeys.addAll(noSysKeyList);
        LOGGER.info("------------\u6570\u636e\u5220\u9664\u5f00\u59cb------------");
        for (int num = 0; keyListIncludeUpAndLow.size() >= num; num += 1000) {
            List keyListGroup = keyListIncludeUpAndLow.subList(num, Math.min(keyListIncludeUpAndLow.size(), num + 1000));
            LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
            queryWrapper1.in(SysMultiLangMgt::getLangKey, keyListGroup);
            this.sysMultiLangMgtService.remove((Wrapper)queryWrapper1);
        }
        LOGGER.info("------------\u6570\u636e\u5220\u9664\u5b8c\u6210------------");
        try {
            this.sysMultiLangMgtService.saveBatch(realupdateList);
        }
        catch (DuplicateKeyException e) {
            throw new BaseException("\u8054\u5408\u552f\u4e00\u7d22\u5f15\u91cd\u590d");
        }
        LOGGER.info("------------\u6570\u636e\u63d2\u5165\u5b8c\u6210------------");
        Executor executor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        executor.execute(() -> {
            if (list.size() != 0) {
                this.saveOrUpdateCacheForImport(list);
            }
        });
    }

    private void opImportLang(Long appId, Set<String> langs) {
        SysMultiLangVo sysMultiLangVo = this.sysMultiLangService.getLang(appId);
        List sysMultiLangs = sysMultiLangVo.getSysMultiLangs();
        ArrayList<String> langList = new ArrayList<String>();
        for (SysMultiLang sysMultiLang : sysMultiLangs) {
            langList.add(LangEnum.getValueByLabel((String)sysMultiLang.getLang()));
        }
        for (String lang : langs) {
            if (langList.contains(lang) || !HussarUtils.isNotEmpty((Object)lang)) continue;
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysMultiLang::getLangCode, (Object)lang);
            SysMultiLang one = (SysMultiLang)this.sysMultiLangService.getOne((Wrapper)queryWrapper);
            one.setIsShow(1);
            this.sysMultiLangService.updateById((Object)one);
        }
    }

    @HussarDs(value="#dataSourceKey")
    public void updateLangTime(List<SysMultiLangMgt> list, String dataSourceKey) {
        ArrayList<String> langs = new ArrayList<String>();
        for (SysMultiLangMgt sysMultiLangMgt : list) {
            String lang = sysMultiLangMgt.getLang();
            if (langs.contains(lang)) continue;
            langs.add(lang);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysMultiLang::getLangCode, langs);
        List sysMultiLangs = this.sysMultiLangService.getBaseMapper().selectList((Wrapper)queryWrapper);
        this.sysMultiLangService.updateBatchById((Collection)sysMultiLangs);
    }

    @HussarDs(value="#dataSourceKey")
    public void updateLangTime(SysMultiLangMgtDto sysMultiLangMgtDto, String dataSourceKey) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMultiLang::getLangCode, (Object)sysMultiLangMgtDto.getLang());
        SysMultiLang sysMultiLang = (SysMultiLang)this.sysMultiLangService.getOne((Wrapper)queryWrapper);
        this.sysMultiLangService.updateById((Object)sysMultiLang);
    }

    public void saveOrUpdateCacheForImport(List<SysMultiLangMgt> list) {
        Map<String, List<SysMultiLangMgt>> keyList = list.stream().collect(Collectors.groupingBy(SysMultiLangMgt::getLangKey));
        ArrayList<String> langList = new ArrayList<String>();
        this.getLangs(langList);
        String suffix = "master";
        if (HussarUtils.isNotEmpty((Object)this.creatorCachePrefix())) {
            suffix = this.creatorCachePrefix();
        }
        for (String langKey : keyList.keySet()) {
            HashMap<String, Object> cacheMap = new HashMap<String, Object>();
            if (HussarUtils.isNotEmpty(keyList.get(langKey))) {
                cacheMap.put(LANG_KEY, langKey);
                HashMap<String, String> langTextMap = new HashMap<String, String>();
                for (SysMultiLangMgt sysMultiLangMgt : keyList.get(langKey)) {
                    String lang = sysMultiLangMgt.getLang();
                    if (!HussarUtils.isNotEmpty((Object)lang) || !langList.contains(lang)) continue;
                    langTextMap.put(sysMultiLangMgt.getLang(), sysMultiLangMgt.getLangText());
                }
                Map sortMap = TranslateUtil.sortLangText(langTextMap, langList);
                cacheMap.put(LANG_TEXT, sortMap);
            } else {
                cacheMap.put(LANG_KEY, "");
                cacheMap.put(LANG_TEXT, new HashMap());
            }
            HussarCacheUtil.put((String)"lang_text", (Object)(":" + suffix + ":" + langKey), cacheMap);
        }
    }

    public String creatorCachePrefix() {
        boolean tenantOpen = this.hussarTenantProperties.isEnabled();
        String tenantCode = null;
        if (tenantOpen) {
            tenantCode = HussarContextHolder.getHussarTenant().getTenantCode();
        }
        if (HussarUtils.isNotBlank(tenantCode)) {
            return "tenant:" + tenantCode;
        }
        return null;
    }

    public void deDuplicate(Map<String, List<String>> map) {
        HashMap<String, List<String>> noDupMap = new HashMap<String, List<String>>();
        HashSet<String> keys = new HashSet<String>(map.keySet());
        block0: for (String langkey : keys) {
            String langkeyl = langkey.toLowerCase().trim();
            if (HussarUtils.isEmpty(noDupMap.get(langkeyl))) {
                noDupMap.put(langkeyl, map.get(langkey));
                continue;
            }
            ArrayList langs = new ArrayList(map.get(langkey));
            langs.addAll((Collection)noDupMap.get(langkeyl));
            map.remove(langkey);
            for (String langkeyOrigin : map.keySet()) {
                if (!langkeyOrigin.trim().equalsIgnoreCase(langkey.trim())) continue;
                map.put(langkeyOrigin, langs);
                continue block0;
            }
        }
    }
}

