/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.lang.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class GenerateCode {
    private static final Integer CODE_WIDTH = 300;
    private static final Integer QrCODE_HEIGHT = 300;
    private static final Integer BarCODE_HEIGHT = 120;
    private static final Integer FRONT_COLOR = 0;
    private static final Integer BACKGROUND_COLOR = 0xFFFFFF;

    public static BufferedImage generateCode(String qrMessage, String mode, BarcodeFormat barcodeFormat, ErrorCorrectionLevel errorCorrectionLevel) throws WriterException {
        int height = 0;
        if ("qrcode".equals(mode)) {
            height = QrCODE_HEIGHT;
        } else if ("barcode".equals(mode)) {
            height = BarCODE_HEIGHT;
        }
        HashMap<EncodeHintType, Object> typeObjectHashMap = new HashMap<EncodeHintType, Object>();
        typeObjectHashMap.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        typeObjectHashMap.put(EncodeHintType.ERROR_CORRECTION, errorCorrectionLevel);
        typeObjectHashMap.put(EncodeHintType.MARGIN, 1);
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        BitMatrix bitMatrix = multiFormatWriter.encode(qrMessage, barcodeFormat, CODE_WIDTH.intValue(), height, typeObjectHashMap);
        BufferedImage bufferedImage = new BufferedImage(CODE_WIDTH, height, 4);
        for (int x = 0; x < CODE_WIDTH; ++x) {
            for (int y = 0; y < height; ++y) {
                bufferedImage.setRGB(x, y, bitMatrix.get(x, y) ? FRONT_COLOR : BACKGROUND_COLOR);
            }
        }
        return bufferedImage;
    }
}

