/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.lang.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.application.lang.enums.LangEnum;
import com.jxdinfo.hussar.lang.dao.SysMultiLangMapper;
import com.jxdinfo.hussar.lang.dto.SysMultiLangDto;
import com.jxdinfo.hussar.lang.model.SysMultiLang;
import com.jxdinfo.hussar.lang.service.ISysMultiLangService;
import com.jxdinfo.hussar.lang.vo.SysMultiLangVo;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.lang.service.impl.SysMultiLangImpl")
public class SysMultiLangImpl
extends HussarServiceImpl<SysMultiLangMapper, SysMultiLang>
implements ISysMultiLangService {
    private static final int ENABLED = 1;
    private static final int NO_ENABLED = 0;
    private static final int DEFAULT = 1;
    private static final int NO_DEFAULT = 0;
    private static final int SHOW = 1;
    private static final int NO_SHOW = 0;

    public SysMultiLangVo getLang(Long appId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysMultiLang::getIsShow, (Object)1)).orderByAsc(SysMultiLang::getAddTime);
        List sysMultiLangs = ((SysMultiLangMapper)this.getBaseMapper()).selectList((Wrapper)queryWrapper);
        SysMultiLangVo sysMultiLangVo = new SysMultiLangVo();
        if (HussarUtils.isNotEmpty((Object)sysMultiLangs)) {
            sysMultiLangs.forEach(sysMultiLang -> {
                if (HussarUtils.isNotEmpty((Object)sysMultiLang.getLang()) && sysMultiLang.getLang().equals(LangEnum.ZH_CN.getLangLabel())) {
                    sysMultiLangVo.setEnabled(sysMultiLang.getEnabled() == 1);
                }
            });
            sysMultiLangVo.setFirstOpen(false);
        }
        sysMultiLangVo.setSysMultiLangs(sysMultiLangs);
        return sysMultiLangVo;
    }

    public SysMultiLangVo getAllLangList(Long appId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List sysMultiLangs = ((SysMultiLangMapper)this.getBaseMapper()).selectList((Wrapper)queryWrapper);
        SysMultiLangVo sysMultiLangVo = new SysMultiLangVo();
        if (HussarUtils.isNotEmpty((Object)sysMultiLangs)) {
            sysMultiLangs.forEach(sysMultiLang -> {
                if (HussarUtils.isNotEmpty((Object)sysMultiLang.getLang()) && sysMultiLang.getLang().equals(LangEnum.ZH_CN.getLangLabel())) {
                    sysMultiLangVo.setEnabled(sysMultiLang.getEnabled() == 1);
                }
            });
            sysMultiLangVo.setFirstOpen(false);
        }
        sysMultiLangVo.setSysMultiLangs(sysMultiLangs);
        return sysMultiLangVo;
    }

    @HussarTransactional
    public SysMultiLangVo addLang(SysMultiLangDto sysMultiLangDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMultiLang::getLangCode, (Object)sysMultiLangDto.getLangCode());
        SysMultiLang one = (SysMultiLang)this.getOne((Wrapper)queryWrapper);
        one.setIsShow(1);
        LocalDateTime now = LocalDateTime.now();
        one.setAddTime(now);
        this.updateById((BaseEntity)one);
        return this.getLang(null);
    }

    public SysMultiLangVo switchLang(Long appId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMultiLang::getLang, (Object)LangEnum.ZH_CN.getLangLabel());
        SysMultiLang sysMultiLang = (SysMultiLang)this.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)sysMultiLang)) {
            if (sysMultiLang.getEnabled() == 1) {
                sysMultiLang.setEnabled(0);
            } else {
                sysMultiLang.setEnabled(1);
            }
        }
        this.updateById((BaseEntity)sysMultiLang);
        return this.getLang(sysMultiLang.getAppId());
    }

    @HussarTransactional
    public SysMultiLangVo setDefaultLang(SysMultiLangDto sysMultiLangDto) {
        List sysMultiLangs = sysMultiLangDto.getSysMultiLangs();
        this.updateBatchById(sysMultiLangs);
        return this.getLang(null);
    }

    @HussarTransactional
    public SysMultiLangVo delLang(SysMultiLang sysMultiLang) {
        if (HussarUtils.isNotEmpty((Object)sysMultiLang)) {
            if (sysMultiLang.getIsDefault() == 1) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(SysMultiLang::getLang, (Object)LangEnum.ZH_CN.getLangLabel());
                SysMultiLang one = (SysMultiLang)this.getOne((Wrapper)queryWrapper);
                one.setIsDefault(1);
                this.updateById((BaseEntity)one);
            }
            SysMultiLang lang = (SysMultiLang)this.getById(sysMultiLang.getLangId());
            lang.setIsDefault(0);
            lang.setIsShow(0);
            this.updateById((BaseEntity)lang);
            return this.getLang(null);
        }
        throw new BaseException("\u4f20\u5165\u7684\u53c2\u6570\u4e3a\u7a7a");
    }
}

