/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.lang.run;

import com.jxdinfo.hussar.lang.model.SysMultiLangMgt;
import com.jxdinfo.hussar.lang.service.ISysMultiLangMgtService;
import com.jxdinfo.hussar.lang.service.impl.LangAsync;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1000003)
public class LangTextRunner
implements ApplicationRunner {
    public static final String LANG_KEY = "langKey";
    public static final String LANG_TEXT = "langText";
    @Resource
    private ISysMultiLangMgtService sysMultiLangMgtService;
    @Resource
    private LangAsync langAsync;

    public void run(ApplicationArguments args) throws Exception {
        String cacheName = "lang_text";
        List cacheKeys = HussarCacheUtil.getKeysLike((String)cacheName, (String)"?");
        for (String cacheKey : cacheKeys) {
            HussarCacheUtil.evict((String)cacheName, (Object)cacheKey);
        }
        ArrayList<String> langList = new ArrayList<String>();
        this.langAsync.getLangs(langList);
        List sysMultiLangMgts = this.sysMultiLangMgtService.list();
        for (int i = 0; i < sysMultiLangMgts.size(); ++i) {
            SysMultiLangMgt sysMultiLangMgtRes = (SysMultiLangMgt)sysMultiLangMgts.get(i);
            List collects = sysMultiLangMgts.stream().filter(res -> sysMultiLangMgtRes.getLangKey().equalsIgnoreCase(res.getLangKey())).collect(Collectors.toList());
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (HussarUtils.isNotEmpty((Object)sysMultiLangMgts)) {
                map.put(LANG_KEY, sysMultiLangMgtRes.getLangKey());
                HashMap<String, String> langTextMap = new HashMap<String, String>();
                for (SysMultiLangMgt collect : collects) {
                    String lang = collect.getLang();
                    if (!HussarUtils.isNotEmpty((Object)lang) || !langList.contains(lang)) continue;
                    langTextMap.put(collect.getLang(), collect.getLangText());
                }
                map.put(LANG_TEXT, langTextMap);
            } else {
                map.put(LANG_KEY, "");
                map.put(LANG_TEXT, new HashMap());
            }
            HussarCacheUtil.put((String)"lang_text", (Object)sysMultiLangMgtRes.getLangKey(), map);
        }
    }
}

