/*
 * Decompiled with CFR 0.152.
 */
package com.sgcc.isc.service.adapter.factory.agent.config;

import com.sgcc.isc.core.orm.domain.BusinessApplication;
import com.sgcc.isc.service.adapter.exception.ISCServiceAgentException;
import com.sgcc.isc.service.adapter.factory.agent.config.CacheConfig;
import com.sgcc.isc.service.adapter.factory.agent.config.LogConfig;
import com.sgcc.isc.service.adapter.factory.agent.config.ServiceAgentConfiguration;
import com.sgcc.isc.service.adapter.utils.PropertyUtil;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class ConfigHolder {
    public static Log log = LogFactory.getLog(ConfigHolder.class);
    public static final String agentConfigFileName = "iscservicesadapter";
    public static BusinessApplication application = new BusinessApplication();
    private static ServiceAgentConfiguration config;
    private static ServiceAgentConfiguration defaultConfig;

    public static void setServiceAgentConfiguration(ServiceAgentConfiguration config) {
        Assert.notNull((Object)config, (String)"\u524d\u7f6e\u8282\u70b9\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            config = (ServiceAgentConfiguration)config.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)"\u524d\u7f6e\u8282\u70b9\u914d\u7f6e\u4fe1\u606f\u8bbe\u7f6e\u5931\u8d25");
            throw new ISCServiceAgentException("\u524d\u7f6e\u8282\u70b9\u914d\u7f6e\u4fe1\u606f\u8bbe\u7f6e\u5931\u8d25, \u53ef\u80fd\u7684\u5931\u8d25\u539f\u56e0\uff1a " + e.getMessage());
        }
    }

    public static ServiceAgentConfiguration getServiceAgentConfiguration() {
        if (config == null) {
            log.info((Object)"\u9274\u6743\u4ee3\u7406\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6iscservicesadapter\u4e2d\u9ed8\u8ba4\u914d\u7f6e\u4fe1\u606f......");
            config = ConfigHolder.getDefaultServiceAgentConfiguration();
        }
        return config;
    }

    public static ServiceAgentConfiguration getDefaultServiceAgentConfiguration() {
        if (defaultConfig != null) {
            return defaultConfig;
        }
        PropertyUtil.newInstance((String)agentConfigFileName);
        Properties props = PropertyUtil.getSnapProps();
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.setCacheJmsTopic(props.getProperty("jms_topic"));
        cacheConfig.setCacheJmsURI(props.getProperty("jms_url"));
        cacheConfig.setIscache(Boolean.valueOf(props.getProperty("iscache")).booleanValue());
        cacheConfig.setTempCacheTimeToLiveSeconds(Integer.parseInt(props.getProperty("temp_cache_timeToLiveSeconds")));
        cacheConfig.setTempCacheTimeToIdleSeconds(Integer.parseInt(props.getProperty("temp_cache_timeToIdleSeconds")));
        LogConfig logConfig = new LogConfig();
        logConfig.setInvokeSysId(props.getProperty("invokeSysId"));
        logConfig.setInvokeSysName(props.getProperty("invokeSysName"));
        logConfig.setIslog(Boolean.valueOf(props.getProperty("islog")).booleanValue());
        logConfig.setLogLevel(props.getProperty("logLevel"));
        logConfig.setLogJmsQueue(props.getProperty("msgQueue"));
        logConfig.setLogJmsURI(props.getProperty("jms_cluster_url"));
        defaultConfig = new ServiceAgentConfiguration();
        defaultConfig.setCacheConfig(cacheConfig);
        defaultConfig.setLogConfig(logConfig);
        PropertyUtil.newInstance((String)"isc-conf");
        if (Boolean.valueOf(PropertyUtil.getMsg((String)"isc-conf", (String)"hussar.isc.conf.active")).booleanValue()) {
            defaultConfig.setServiceURI(PropertyUtil.getMsg((String)"isc-conf", (String)"hussar.isc.conf.sm-uri"));
            defaultConfig.setAppId(PropertyUtil.getMsg((String)"isc-conf", (String)"hussar.isc.conf.app-id"));
        } else {
            defaultConfig.setServiceURI(props.getProperty("uri"));
            defaultConfig.setAppId(props.getProperty("appId"));
        }
        return defaultConfig;
    }

    public static boolean iscache() {
        return ConfigHolder.getServiceAgentConfiguration().getCacheConfig().isIscache();
    }

    public static boolean islog() {
        return ConfigHolder.getServiceAgentConfiguration().getLogConfig().isIslog();
    }

    public static BusinessApplication getApplication() {
        return application;
    }

    public static void setApplication(String appId) {
        application.setId(appId);
    }

    public static void setApplication(BusinessApplication app) {
        application = app;
    }

    public static String getAppId() {
        return ConfigHolder.getServiceAgentConfiguration().getAppId();
    }
}

