/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.utils;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationJsonException;
import com.jxdinfo.hussar.integration.support.jackson.HussarIntegrationObjectMapper;
import com.jxdinfo.hussar.integration.support.jackson.config.JsonConfiguration;
import com.jxdinfo.hussar.platform.core.utils.type.TypeReference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.lang.Nullable;

public final class HussarIntegrationJsonUtils {
    private static volatile JsonUtilsBean BEAN = null;

    private HussarIntegrationJsonUtils() {
    }

    public static String toString(Object value) {
        return HussarIntegrationJsonUtils.getUtilsBean().toString(value);
    }

    public static byte[] toByteArray(Object value) {
        return HussarIntegrationJsonUtils.getUtilsBean().toByteArray(value);
    }

    public static void write(Object value, OutputStream output) throws IOException {
        HussarIntegrationJsonUtils.getUtilsBean().write(value, output);
    }

    public static void write(Object value, File output) throws IOException {
        HussarIntegrationJsonUtils.getUtilsBean().write(value, output);
    }

    public static <T> T parse(String text, Class<T> clazz) {
        return HussarIntegrationJsonUtils.getUtilsBean().parse(text, clazz);
    }

    public static <T> T parse(String text, TypeReference<T> typeReference) {
        return HussarIntegrationJsonUtils.getUtilsBean().parse(text, typeReference);
    }

    public static <T> T parse(String text, JavaType javaType) {
        return HussarIntegrationJsonUtils.getUtilsBean().parse(text, javaType);
    }

    public static <T> T parse(byte[] bytes, Class<T> clazz) {
        return HussarIntegrationJsonUtils.getUtilsBean().parse(bytes, clazz);
    }

    public static <T> T parse(byte[] bytes, TypeReference<T> typeReference) {
        return HussarIntegrationJsonUtils.getUtilsBean().parse(bytes, typeReference);
    }

    public static <T> T parse(byte[] bytes, JavaType javaType) {
        return HussarIntegrationJsonUtils.getUtilsBean().parse(bytes, javaType);
    }

    public static <T> T parse(InputStream input, Class<T> clazz) {
        return HussarIntegrationJsonUtils.getUtilsBean().parse(input, clazz);
    }

    public static <T> T parse(InputStream input, TypeReference<T> typeReference) {
        return HussarIntegrationJsonUtils.getUtilsBean().parse(input, typeReference);
    }

    public static <T> T parse(InputStream input, JavaType javaType) {
        return HussarIntegrationJsonUtils.getUtilsBean().parse(input, javaType);
    }

    public static <T> T convert(Object original, Class<T> clazz) {
        return HussarIntegrationJsonUtils.getUtilsBean().convert(original, clazz);
    }

    public static <T> T convert(Object original, TypeReference<T> typeReference) {
        return HussarIntegrationJsonUtils.getUtilsBean().convert(original, typeReference);
    }

    public static <T> T convert(Object original, JavaType javaType) {
        return HussarIntegrationJsonUtils.getUtilsBean().convert(original, javaType);
    }

    public static boolean isSerializable(@Nullable Object value) {
        return HussarIntegrationJsonUtils.getUtilsBean().isSerializable(value);
    }

    public static ObjectMapper getObjectMapper() {
        return HussarIntegrationJsonUtils.getUtilsBean().getObjectMapper();
    }

    public static TypeFactory getTypeFactory() {
        return HussarIntegrationJsonUtils.getUtilsBean().getTypeFactory();
    }

    public static JsonUtilsBean createUtilsBean() {
        return new JsonUtilsBean();
    }

    public static JsonUtilsBean createUtilsBean(JsonConfiguration configuration) {
        return new JsonUtilsBean(HussarIntegrationObjectMapper.createInstance(configuration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JsonUtilsBean getUtilsBean() {
        if (BEAN != null) return BEAN;
        Class<HussarIntegrationJsonUtils> clazz = HussarIntegrationJsonUtils.class;
        synchronized (HussarIntegrationJsonUtils.class) {
            if (BEAN != null) return BEAN;
            BEAN = HussarIntegrationJsonUtils.createUtilsBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return BEAN;
        }
    }

    public static final class Contextual {
        private static final TransmittableThreadLocal<JsonContextState> STATE = TransmittableThreadLocal.withInitial(JsonContextState::create);

        private Contextual() {
        }

        public static JsonConfiguration getConfigure() {
            JsonContextState state = (JsonContextState)STATE.get();
            return state.getConfiguration();
        }

        public static void setConfigure(JsonConfiguration configuration) {
            JsonContextState previousState = (JsonContextState)STATE.get();
            JsonContextState nextState = previousState.configure(configuration);
            STATE.set((Object)nextState);
        }

        public static void computeConfigure(Function<JsonConfiguration, JsonConfiguration> configurator) {
            JsonContextState previousState = (JsonContextState)STATE.get();
            JsonConfiguration configuration = configurator.apply(previousState.getConfiguration());
            JsonContextState nextState = previousState.configure(configuration);
            STATE.set((Object)nextState);
        }

        public static void clearThreadLocal() {
            STATE.remove();
        }

        public static String toString(Object value) {
            return Contextual.getUtilsBean().toString(value);
        }

        public static byte[] toByteArray(Object value) {
            return Contextual.getUtilsBean().toByteArray(value);
        }

        public static void write(Object value, OutputStream output) throws IOException {
            Contextual.getUtilsBean().write(value, output);
        }

        public static void write(Object value, File output) throws IOException {
            Contextual.getUtilsBean().write(value, output);
        }

        public static <T> T parse(String text, Class<T> clazz) {
            return Contextual.getUtilsBean().parse(text, clazz);
        }

        public static <T> T parse(String text, TypeReference<T> typeReference) {
            return Contextual.getUtilsBean().parse(text, typeReference);
        }

        public static <T> T parse(String text, JavaType javaType) {
            return Contextual.getUtilsBean().parse(text, javaType);
        }

        public static <T> T parse(byte[] bytes, Class<T> clazz) {
            return Contextual.getUtilsBean().parse(bytes, clazz);
        }

        public static <T> T parse(byte[] bytes, TypeReference<T> typeReference) {
            return Contextual.getUtilsBean().parse(bytes, typeReference);
        }

        public static <T> T parse(byte[] bytes, JavaType javaType) {
            return Contextual.getUtilsBean().parse(bytes, javaType);
        }

        public static <T> T parse(InputStream input, Class<T> clazz) {
            return Contextual.getUtilsBean().parse(input, clazz);
        }

        public static <T> T parse(InputStream input, TypeReference<T> typeReference) {
            return Contextual.getUtilsBean().parse(input, typeReference);
        }

        public static <T> T parse(InputStream input, JavaType javaType) {
            return Contextual.getUtilsBean().parse(input, javaType);
        }

        public static <T> T convert(Object original, Class<T> clazz) {
            return Contextual.getUtilsBean().convert(original, clazz);
        }

        public static <T> T convert(Object original, TypeReference<T> typeReference) {
            return Contextual.getUtilsBean().convert(original, typeReference);
        }

        public static <T> T convert(Object original, JavaType javaType) {
            return Contextual.getUtilsBean().convert(original, javaType);
        }

        public static boolean isSerializable(@Nullable Object value) {
            return Contextual.getUtilsBean().isSerializable(value);
        }

        public static ObjectMapper getObjectMapper() {
            return Contextual.getUtilsBean().getObjectMapper();
        }

        public static TypeFactory getTypeFactory() {
            return Contextual.getUtilsBean().getTypeFactory();
        }

        public static JsonUtilsBean createUtilsBean() {
            JsonContextState state = (JsonContextState)STATE.get();
            return state.createReactiveJsonUtilsBean();
        }

        private static JsonUtilsBean getUtilsBean() {
            JsonContextState state = (JsonContextState)STATE.get();
            return state.getJsonUtils();
        }

        private static final class ReactiveContextAwareJsonUtilsBean
        extends JsonUtilsBean {
            private JsonConfiguration configuration;

            public ReactiveContextAwareJsonUtilsBean(HussarIntegrationObjectMapper objectMapper) {
                super(objectMapper);
                this.configuration = objectMapper.getConfiguration();
            }

            @Override
            public synchronized ObjectMapper getObjectMapper() {
                JsonConfiguration configuration = ((JsonContextState)STATE.get()).getConfiguration();
                if (Objects.equals(configuration, this.configuration)) {
                    return this.objectMapper;
                }
                this.objectMapper = HussarIntegrationObjectMapper.createInstance(configuration);
                this.configuration = configuration;
                return this.objectMapper;
            }

            public synchronized JsonConfiguration getConfiguration() {
                return this.configuration;
            }
        }

        private static final class JsonContextState {
            private final JsonConfiguration configuration;
            private final HussarIntegrationObjectMapper objectMapper;
            private final JsonUtilsBean jsonUtils;

            private JsonContextState() {
                this.configuration = JsonConfiguration.DEFAULT;
                this.objectMapper = HussarIntegrationObjectMapper.createInstance();
                this.jsonUtils = new JsonUtilsBean(this.objectMapper);
            }

            private JsonContextState(JsonConfiguration configuration, HussarIntegrationObjectMapper objectMapper, JsonUtilsBean jsonUtils) {
                this.configuration = configuration;
                this.objectMapper = objectMapper;
                this.jsonUtils = jsonUtils;
            }

            public static JsonContextState create() {
                return new JsonContextState();
            }

            public JsonContextState configure(JsonConfiguration configuration) {
                JsonConfiguration jsonConfiguration = configuration = configuration != null ? configuration : JsonConfiguration.DEFAULT;
                if (Objects.equals(configuration, this.configuration)) {
                    return this;
                }
                HussarIntegrationObjectMapper objectMapper = HussarIntegrationObjectMapper.createInstance(configuration);
                JsonUtilsBean jsonUtils = new JsonUtilsBean(objectMapper);
                return new JsonContextState(configuration, objectMapper, jsonUtils);
            }

            public JsonUtilsBean createReactiveJsonUtilsBean() {
                HussarIntegrationObjectMapper objectMapper = HussarIntegrationObjectMapper.createInstance(this.configuration);
                return new ReactiveContextAwareJsonUtilsBean(objectMapper);
            }

            public JsonConfiguration getConfiguration() {
                return this.configuration;
            }

            public HussarIntegrationObjectMapper getObjectMapper() {
                return this.objectMapper;
            }

            public JsonUtilsBean getJsonUtils() {
                return this.jsonUtils;
            }
        }
    }

    public static class JsonUtilsBean {
        protected ObjectMapper objectMapper;

        public JsonUtilsBean() {
            this(null);
        }

        public JsonUtilsBean(ObjectMapper objectMapper) {
            if (objectMapper == null) {
                objectMapper = HussarIntegrationObjectMapper.createInstance();
            }
            this.objectMapper = objectMapper;
        }

        public String toString(Object value) {
            try {
                return this.getObjectMapper().writeValueAsString(value);
            }
            catch (JsonProcessingException ex) {
                throw new HussarIntegrationJsonException(ex);
            }
        }

        public byte[] toByteArray(Object value) {
            try {
                return this.getObjectMapper().writeValueAsBytes(value);
            }
            catch (JsonProcessingException ex) {
                throw new HussarIntegrationJsonException(ex);
            }
        }

        public void write(Object value, OutputStream output) throws IOException {
            this.getObjectMapper().writeValue(output, value);
        }

        public void write(Object value, File output) throws IOException {
            this.getObjectMapper().writeValue(output, value);
        }

        public <T> T parse(String text, Class<T> clazz) {
            try {
                return (T)this.getObjectMapper().readValue(text, clazz);
            }
            catch (JsonProcessingException ex) {
                throw new HussarIntegrationJsonException(ex);
            }
        }

        public <T> T parse(String text, TypeReference<T> typeReference) {
            try {
                return (T)this.getObjectMapper().readValue(text, this.toJavaType(typeReference));
            }
            catch (JsonProcessingException ex) {
                throw new HussarIntegrationJsonException(ex);
            }
        }

        public <T> T parse(String text, JavaType javaType) {
            try {
                return (T)this.getObjectMapper().readValue(text, javaType);
            }
            catch (JsonProcessingException ex) {
                throw new HussarIntegrationJsonException(ex);
            }
        }

        public <T> T parse(byte[] bytes, Class<T> clazz) {
            try {
                return (T)this.getObjectMapper().readValue(bytes, clazz);
            }
            catch (IOException ex) {
                throw new HussarIntegrationJsonException(ex);
            }
        }

        public <T> T parse(byte[] bytes, TypeReference<T> typeReference) {
            try {
                return (T)this.getObjectMapper().readValue(bytes, this.toJavaType(typeReference));
            }
            catch (IOException ex) {
                throw new HussarIntegrationJsonException(ex);
            }
        }

        public <T> T parse(byte[] bytes, JavaType javaType) {
            try {
                return (T)this.getObjectMapper().readValue(bytes, javaType);
            }
            catch (IOException ex) {
                throw new HussarIntegrationJsonException(ex);
            }
        }

        public <T> T parse(InputStream input, Class<T> clazz) {
            try {
                return (T)this.getObjectMapper().readValue(input, clazz);
            }
            catch (IOException ex) {
                throw new HussarIntegrationJsonException(ex);
            }
        }

        public <T> T parse(InputStream input, TypeReference<T> typeReference) {
            try {
                return (T)this.getObjectMapper().readValue(input, this.toJavaType(typeReference));
            }
            catch (IOException ex) {
                throw new HussarIntegrationJsonException(ex);
            }
        }

        public <T> T parse(InputStream input, JavaType javaType) {
            try {
                return (T)this.getObjectMapper().readValue(input, javaType);
            }
            catch (IOException ex) {
                throw new HussarIntegrationJsonException(ex);
            }
        }

        public <T> T convert(Object original, Class<T> clazz) {
            try {
                return (T)this.getObjectMapper().convertValue(original, clazz);
            }
            catch (IllegalArgumentException ex) {
                throw new HussarIntegrationJsonException(ex);
            }
        }

        public <T> T convert(Object original, TypeReference<T> typeReference) {
            try {
                return (T)this.getObjectMapper().convertValue(original, this.toJavaType(typeReference));
            }
            catch (IllegalArgumentException ex) {
                throw new HussarIntegrationJsonException(ex);
            }
        }

        public <T> T convert(Object original, JavaType javaType) {
            try {
                return (T)this.getObjectMapper().convertValue(original, javaType);
            }
            catch (IllegalArgumentException ex) {
                throw new HussarIntegrationJsonException(ex);
            }
        }

        public boolean isSerializable(@Nullable Object value) {
            return value == null || this.getObjectMapper().canSerialize(value.getClass());
        }

        public ObjectMapper getObjectMapper() {
            return this.objectMapper;
        }

        public TypeFactory getTypeFactory() {
            return this.getObjectMapper().getTypeFactory();
        }

        public void setTypeFactory(TypeFactory typeFactory) {
            this.getObjectMapper().setTypeFactory(typeFactory);
        }

        private JavaType toJavaType(TypeReference<?> typeReference) {
            return this.getTypeFactory().constructType(typeReference.getType());
        }
    }
}

